/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.db.Unit;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import org.hibernate.annotations.Index;
import org.joda.time.DateTime;

@Entity
@Cacheable
@Table(name="BASE_GENERAL")
public class General
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Today date", help="true")
    private DateTime today;
    @Widget(title="Default Project unit", help="true")
    @Index(name="BASE_GENERAL_DEFAULT_PROJECT_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit defaultProjectUnit;
    @Widget(title="Default Partner language", help="true", selection="select.language")
    private String defaultPartnerLanguage;
    @Widget(title="Manage mail account by user ?")
    private Boolean mailAccountByUser = Boolean.FALSE;
    @Widget(title="URL to QAS WSDL", help="true")
    private String qasWsdlUrl;
    @Widget(title="Mapping service provider", selection="base.general.map.api.select")
    private Integer mapApiSelect = 1;
    @Widget(title="Currency Ws URL", help="true")
    private String currencyWsURL;
    @Widget(title="Currency conversion table", help="true")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="general", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CurrencyConversionLine> currencyConversionLineList;
    @Widget(title="Use QAS Validation ?", help="true")
    private Boolean hasQasValidation = Boolean.FALSE;
    @Widget(title="Products ATI/WT", selection="base.in.ati.select")
    private Integer productInAtiSelect = 1;
    @Widget(title="Nb of digits for unit prices")
    @Max(value=10L)
    private Integer nbDecimalDigitForUnitPrice = 2;
    @Widget(title="Compute Method for Discounts", selection="base.compute.method.discount.select")
    private Integer computeMethodDiscountSelect = 1;
    @Widget(title="Time logging preference", selection="hr.time.logging.preference.select")
    private String timeLoggingPreferenceSelect = "days";
    @Widget(title="Daily Work Hours")
    private BigDecimal dailyWorkHours = BigDecimal.ZERO;
    @Widget(title="Days Unit")
    @Index(name="BASE_GENERAL_UNIT_DAYS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitDays;
    @Widget(title="Hours Unit")
    @Index(name="BASE_GENERAL_UNIT_HOURS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitHours;
    @Widget(title="Minutes Unit")
    @Index(name="BASE_GENERAL_UNIT_MINUTES_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitMinutes;
    @Widget(title="Team Management")
    private Boolean teamManagement = Boolean.TRUE;
    @Widget(title="Activate sending email")
    private Boolean activateSendingEmail = Boolean.TRUE;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_GENERAL_SEQ")
    @SequenceGenerator(name="BASE_GENERAL_SEQ", sequenceName="BASE_GENERAL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Generate/Select Project for Order")
    private Boolean generateProjectOrder = Boolean.FALSE;
    @Widget(title="Automatic Project")
    private Boolean automaticProject = Boolean.FALSE;
    @Widget(title="Project/Task in Sale Order Lines")
    private Boolean projectTaskSaleOrderLines = Boolean.FALSE;
    @Widget(title="Project/Task in Purchase Order Lines")
    private Boolean projectTaskPurchaseOrderLines = Boolean.FALSE;
    @Widget(title="Project/Task in Invoice Lines")
    private Boolean projectTaskInvoiceLines = Boolean.FALSE;
    @Widget(title="Project/Task Label")
    private String projectTaskLabel;

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public DateTime getToday() {
        return this.today;
    }

    public void setToday(DateTime today) {
        this.today = today;
    }

    public Unit getDefaultProjectUnit() {
        return this.defaultProjectUnit;
    }

    public void setDefaultProjectUnit(Unit defaultProjectUnit) {
        this.defaultProjectUnit = defaultProjectUnit;
    }

    public String getDefaultPartnerLanguage() {
        return this.defaultPartnerLanguage;
    }

    public void setDefaultPartnerLanguage(String defaultPartnerLanguage) {
        this.defaultPartnerLanguage = defaultPartnerLanguage;
    }

    public Boolean getMailAccountByUser() {
        return this.mailAccountByUser == null ? Boolean.FALSE : this.mailAccountByUser;
    }

    public void setMailAccountByUser(Boolean mailAccountByUser) {
        this.mailAccountByUser = mailAccountByUser;
    }

    public String getQasWsdlUrl() {
        return this.qasWsdlUrl;
    }

    public void setQasWsdlUrl(String qasWsdlUrl) {
        this.qasWsdlUrl = qasWsdlUrl;
    }

    public Integer getMapApiSelect() {
        return this.mapApiSelect == null ? 0 : this.mapApiSelect;
    }

    public void setMapApiSelect(Integer mapApiSelect) {
        this.mapApiSelect = mapApiSelect;
    }

    public String getCurrencyWsURL() {
        return this.currencyWsURL;
    }

    public void setCurrencyWsURL(String currencyWsURL) {
        this.currencyWsURL = currencyWsURL;
    }

    public List<CurrencyConversionLine> getCurrencyConversionLineList() {
        return this.currencyConversionLineList;
    }

    public void setCurrencyConversionLineList(List<CurrencyConversionLine> currencyConversionLineList) {
        this.currencyConversionLineList = currencyConversionLineList;
    }

    public void addCurrencyConversionLineListItem(CurrencyConversionLine item) {
        if (this.currencyConversionLineList == null) {
            this.currencyConversionLineList = new ArrayList<CurrencyConversionLine>();
        }
        this.currencyConversionLineList.add(item);
        item.setGeneral(this);
    }

    public void removeCurrencyConversionLineListItem(CurrencyConversionLine item) {
        if (this.currencyConversionLineList == null) {
            return;
        }
        this.currencyConversionLineList.remove(item);
    }

    public void clearCurrencyConversionLineList() {
        if (this.currencyConversionLineList != null) {
            this.currencyConversionLineList.clear();
        }
    }

    public Boolean getHasQasValidation() {
        return this.hasQasValidation == null ? Boolean.FALSE : this.hasQasValidation;
    }

    public void setHasQasValidation(Boolean hasQasValidation) {
        this.hasQasValidation = hasQasValidation;
    }

    public Integer getProductInAtiSelect() {
        return this.productInAtiSelect == null ? 0 : this.productInAtiSelect;
    }

    public void setProductInAtiSelect(Integer productInAtiSelect) {
        this.productInAtiSelect = productInAtiSelect;
    }

    public Integer getNbDecimalDigitForUnitPrice() {
        return this.nbDecimalDigitForUnitPrice == null ? 0 : this.nbDecimalDigitForUnitPrice;
    }

    public void setNbDecimalDigitForUnitPrice(Integer nbDecimalDigitForUnitPrice) {
        this.nbDecimalDigitForUnitPrice = nbDecimalDigitForUnitPrice;
    }

    public Integer getComputeMethodDiscountSelect() {
        return this.computeMethodDiscountSelect == null ? 0 : this.computeMethodDiscountSelect;
    }

    public void setComputeMethodDiscountSelect(Integer computeMethodDiscountSelect) {
        this.computeMethodDiscountSelect = computeMethodDiscountSelect;
    }

    public String getTimeLoggingPreferenceSelect() {
        return this.timeLoggingPreferenceSelect;
    }

    public void setTimeLoggingPreferenceSelect(String timeLoggingPreferenceSelect) {
        this.timeLoggingPreferenceSelect = timeLoggingPreferenceSelect;
    }

    public BigDecimal getDailyWorkHours() {
        return this.dailyWorkHours == null ? BigDecimal.ZERO : this.dailyWorkHours;
    }

    public void setDailyWorkHours(BigDecimal dailyWorkHours) {
        this.dailyWorkHours = dailyWorkHours;
    }

    public Unit getUnitDays() {
        return this.unitDays;
    }

    public void setUnitDays(Unit unitDays) {
        this.unitDays = unitDays;
    }

    public Unit getUnitHours() {
        return this.unitHours;
    }

    public void setUnitHours(Unit unitHours) {
        this.unitHours = unitHours;
    }

    public Unit getUnitMinutes() {
        return this.unitMinutes;
    }

    public void setUnitMinutes(Unit unitMinutes) {
        this.unitMinutes = unitMinutes;
    }

    public Boolean getTeamManagement() {
        return this.teamManagement == null ? Boolean.FALSE : this.teamManagement;
    }

    public void setTeamManagement(Boolean teamManagement) {
        this.teamManagement = teamManagement;
    }

    public Boolean getActivateSendingEmail() {
        return this.activateSendingEmail == null ? Boolean.FALSE : this.activateSendingEmail;
    }

    public void setActivateSendingEmail(Boolean activateSendingEmail) {
        this.activateSendingEmail = activateSendingEmail;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getGenerateProjectOrder() {
        return this.generateProjectOrder == null ? Boolean.FALSE : this.generateProjectOrder;
    }

    public void setGenerateProjectOrder(Boolean generateProjectOrder) {
        this.generateProjectOrder = generateProjectOrder;
    }

    public Boolean getAutomaticProject() {
        return this.automaticProject == null ? Boolean.FALSE : this.automaticProject;
    }

    public void setAutomaticProject(Boolean automaticProject) {
        this.automaticProject = automaticProject;
    }

    public Boolean getProjectTaskSaleOrderLines() {
        return this.projectTaskSaleOrderLines == null ? Boolean.FALSE : this.projectTaskSaleOrderLines;
    }

    public void setProjectTaskSaleOrderLines(Boolean projectTaskSaleOrderLines) {
        this.projectTaskSaleOrderLines = projectTaskSaleOrderLines;
    }

    public Boolean getProjectTaskPurchaseOrderLines() {
        return this.projectTaskPurchaseOrderLines == null ? Boolean.FALSE : this.projectTaskPurchaseOrderLines;
    }

    public void setProjectTaskPurchaseOrderLines(Boolean projectTaskPurchaseOrderLines) {
        this.projectTaskPurchaseOrderLines = projectTaskPurchaseOrderLines;
    }

    public Boolean getProjectTaskInvoiceLines() {
        return this.projectTaskInvoiceLines == null ? Boolean.FALSE : this.projectTaskInvoiceLines;
    }

    public void setProjectTaskInvoiceLines(Boolean projectTaskInvoiceLines) {
        this.projectTaskInvoiceLines = projectTaskInvoiceLines;
    }

    public String getProjectTaskLabel() {
        return this.projectTaskLabel;
    }

    public void setProjectTaskLabel(String projectTaskLabel) {
        this.projectTaskLabel = projectTaskLabel;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof General)) {
            return false;
        }
        General other = (General)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("today", (Object)this.getToday());
        tsh.add("defaultPartnerLanguage", (Object)this.getDefaultPartnerLanguage());
        tsh.add("mailAccountByUser", (Object)this.getMailAccountByUser());
        tsh.add("qasWsdlUrl", (Object)this.getQasWsdlUrl());
        tsh.add("mapApiSelect", (Object)this.getMapApiSelect());
        tsh.add("currencyWsURL", (Object)this.getCurrencyWsURL());
        tsh.add("hasQasValidation", (Object)this.getHasQasValidation());
        tsh.add("productInAtiSelect", (Object)this.getProductInAtiSelect());
        tsh.add("nbDecimalDigitForUnitPrice", (Object)this.getNbDecimalDigitForUnitPrice());
        tsh.add("computeMethodDiscountSelect", (Object)this.getComputeMethodDiscountSelect());
        return tsh.omitNullValues().toString();
    }
}

