/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.apps.base.db.BirtTemplate;
import com.axelor.apps.base.db.TemplateContext;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MESSAGE_TEMPLATE")
public class Template
extends AuditableModel {
    @Widget(title="Name")
    @NameColumn
    @NotNull
    @Index(name="MESSAGE_TEMPLATE_NAME_IDX")
    private String name;
    @Widget(title="Content", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String content;
    @Widget(title="Suject", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String subject;
    @Widget(title="From", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String fromAdress;
    @Widget(title="Reply to", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String replyToRecipients;
    @Widget(title="To", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String toRecipients;
    @Widget(title="Cc", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String ccRecipients;
    @Widget(title="Bcc", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String bccRecipients;
    @Widget(title="Target receptor")
    private String target;
    @Widget(title="Media Type", help="true", selection="message.media.type.select")
    @NotNull
    private Integer mediaTypeSelect = 0;
    @Widget(title="Address Block", help="true", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String addressBlock;
    @Widget(title="Model", help="true")
    @Index(name="MESSAGE_TEMPLATE_META_MODEL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Default ?", help="true")
    private Boolean isDefault = Boolean.FALSE;
    @Widget(title="System ?", help="true")
    private Boolean isSystem = Boolean.FALSE;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_TEMPLATE_SEQ")
    @SequenceGenerator(name="MESSAGE_TEMPLATE_SEQ", sequenceName="MESSAGE_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Index(name="MESSAGE_TEMPLATE_TEMPLATE_CONTEXT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TemplateContext templateContext;
    @Widget(title="Birt Template", help="true")
    @Index(name="MESSAGE_TEMPLATE_BIRT_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BirtTemplate birtTemplate;

    public Template() {
    }

    public Template(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFromAdress() {
        return this.fromAdress;
    }

    public void setFromAdress(String fromAdress) {
        this.fromAdress = fromAdress;
    }

    public String getReplyToRecipients() {
        return this.replyToRecipients;
    }

    public void setReplyToRecipients(String replyToRecipients) {
        this.replyToRecipients = replyToRecipients;
    }

    public String getToRecipients() {
        return this.toRecipients;
    }

    public void setToRecipients(String toRecipients) {
        this.toRecipients = toRecipients;
    }

    public String getCcRecipients() {
        return this.ccRecipients;
    }

    public void setCcRecipients(String ccRecipients) {
        this.ccRecipients = ccRecipients;
    }

    public String getBccRecipients() {
        return this.bccRecipients;
    }

    public void setBccRecipients(String bccRecipients) {
        this.bccRecipients = bccRecipients;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Integer getMediaTypeSelect() {
        return this.mediaTypeSelect == null ? 0 : this.mediaTypeSelect;
    }

    public void setMediaTypeSelect(Integer mediaTypeSelect) {
        this.mediaTypeSelect = mediaTypeSelect;
    }

    public String getAddressBlock() {
        return this.addressBlock;
    }

    public void setAddressBlock(String addressBlock) {
        this.addressBlock = addressBlock;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public Boolean getIsDefault() {
        return this.isDefault == null ? Boolean.FALSE : this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsSystem() {
        return this.isSystem == null ? Boolean.FALSE : this.isSystem;
    }

    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    public void setTemplateContext(TemplateContext templateContext) {
        this.templateContext = templateContext;
    }

    public BirtTemplate getBirtTemplate() {
        return this.birtTemplate;
    }

    public void setBirtTemplate(BirtTemplate birtTemplate) {
        this.birtTemplate = birtTemplate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("target", (Object)this.getTarget());
        tsh.add("mediaTypeSelect", (Object)this.getMediaTypeSelect());
        tsh.add("isDefault", (Object)this.getIsDefault());
        tsh.add("isSystem", (Object)this.getIsSystem());
        return tsh.omitNullValues().toString();
    }
}

