/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.project.db.ProjectPlanningLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Cacheable
@Table(name="PROJECT_PROJECT_PLANNING")
public class ProjectPlanning
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_PLANNING_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_PLANNING_SEQ", sequenceName="PROJECT_PROJECT_PLANNING_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Year", readonly=true)
    private Integer year = 0;
    @Widget(title="Week", readonly=true)
    private Integer week = 0;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ProjectPlanningLine> projectPlanningLineList;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getYear() {
        return this.year == null ? 0 : this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getWeek() {
        return this.week == null ? 0 : this.week;
    }

    public void setWeek(Integer week) {
        this.week = week;
    }

    public List<ProjectPlanningLine> getProjectPlanningLineList() {
        return this.projectPlanningLineList;
    }

    public void setProjectPlanningLineList(List<ProjectPlanningLine> projectPlanningLineList) {
        this.projectPlanningLineList = projectPlanningLineList;
    }

    public void addProjectPlanningLineListItem(ProjectPlanningLine item) {
        if (this.projectPlanningLineList == null) {
            this.projectPlanningLineList = new ArrayList<ProjectPlanningLine>();
        }
        this.projectPlanningLineList.add(item);
    }

    public void removeProjectPlanningLineListItem(ProjectPlanningLine item) {
        if (this.projectPlanningLineList == null) {
            return;
        }
        this.projectPlanningLineList.remove((Object)item);
    }

    public void clearProjectPlanningLineList() {
        if (this.projectPlanningLineList != null) {
            this.projectPlanningLineList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectPlanning)) {
            return false;
        }
        ProjectPlanning other = (ProjectPlanning)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("year", (Object)this.getYear());
        tsh.add("week", (Object)this.getWeek());
        return tsh.omitNullValues().toString();
    }
}

