/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.project.db.ProjectTask;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Index;

@Entity
@Cacheable
@Table(name="PROJECT_PROJECT_PLANNING_LINE")
public class ProjectPlanningLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_PLANNING_LINE_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_PLANNING_LINE_SEQ", sequenceName="PROJECT_PROJECT_PLANNING_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User", readonly=true)
    @Index(name="PROJECT_PROJECT_PLANNING_LINE_USER_ID_IDX")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Project/Task", readonly=true)
    @Index(name="PROJECT_PROJECT_PLANNING_LINE_PROJECT_TASK_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProjectTask projectTask;
    @Widget(title="Year")
    private Integer year = 0;
    @Widget(title="Week")
    private Integer week = 0;
    @Digits(integer=3, fraction=1)
    private BigDecimal monday = BigDecimal.ZERO;
    @Digits(integer=3, fraction=1)
    private BigDecimal tuesday = BigDecimal.ZERO;
    @Digits(integer=3, fraction=1)
    private BigDecimal wednesday = BigDecimal.ZERO;
    @Digits(integer=3, fraction=1)
    private BigDecimal thursday = BigDecimal.ZERO;
    @Digits(integer=3, fraction=1)
    private BigDecimal friday = BigDecimal.ZERO;
    @Digits(integer=3, fraction=1)
    private BigDecimal saturday = BigDecimal.ZERO;
    @Digits(integer=3, fraction=1)
    private BigDecimal sunday = BigDecimal.ZERO;
    private Boolean toSave = Boolean.FALSE;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ProjectTask getProjectTask() {
        return this.projectTask;
    }

    public void setProjectTask(ProjectTask projectTask) {
        this.projectTask = projectTask;
    }

    public Integer getYear() {
        return this.year == null ? 0 : this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getWeek() {
        return this.week == null ? 0 : this.week;
    }

    public void setWeek(Integer week) {
        this.week = week;
    }

    public BigDecimal getMonday() {
        return this.monday == null ? BigDecimal.ZERO : this.monday;
    }

    public void setMonday(BigDecimal monday) {
        this.monday = monday;
    }

    public BigDecimal getTuesday() {
        return this.tuesday == null ? BigDecimal.ZERO : this.tuesday;
    }

    public void setTuesday(BigDecimal tuesday) {
        this.tuesday = tuesday;
    }

    public BigDecimal getWednesday() {
        return this.wednesday == null ? BigDecimal.ZERO : this.wednesday;
    }

    public void setWednesday(BigDecimal wednesday) {
        this.wednesday = wednesday;
    }

    public BigDecimal getThursday() {
        return this.thursday == null ? BigDecimal.ZERO : this.thursday;
    }

    public void setThursday(BigDecimal thursday) {
        this.thursday = thursday;
    }

    public BigDecimal getFriday() {
        return this.friday == null ? BigDecimal.ZERO : this.friday;
    }

    public void setFriday(BigDecimal friday) {
        this.friday = friday;
    }

    public BigDecimal getSaturday() {
        return this.saturday == null ? BigDecimal.ZERO : this.saturday;
    }

    public void setSaturday(BigDecimal saturday) {
        this.saturday = saturday;
    }

    public BigDecimal getSunday() {
        return this.sunday == null ? BigDecimal.ZERO : this.sunday;
    }

    public void setSunday(BigDecimal sunday) {
        this.sunday = sunday;
    }

    public Boolean getToSave() {
        return this.toSave == null ? Boolean.FALSE : this.toSave;
    }

    public void setToSave(Boolean toSave) {
        this.toSave = toSave;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectPlanningLine)) {
            return false;
        }
        ProjectPlanningLine other = (ProjectPlanningLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("year", (Object)this.getYear());
        tsh.add("week", (Object)this.getWeek());
        tsh.add("monday", (Object)this.getMonday());
        tsh.add("tuesday", (Object)this.getTuesday());
        tsh.add("wednesday", (Object)this.getWednesday());
        tsh.add("thursday", (Object)this.getThursday());
        tsh.add("friday", (Object)this.getFriday());
        tsh.add("saturday", (Object)this.getSaturday());
        tsh.add("sunday", (Object)this.getSunday());
        tsh.add("toSave", (Object)this.getToSave());
        return tsh.omitNullValues().toString();
    }
}

