/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDateTime;

@Entity
@Cacheable
@Table(name="PROJECT_PROJECT_TASK")
public class ProjectTask
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_TASK_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_TASK_SEQ", sequenceName="PROJECT_PROJECT_TASK_SEQ", allocationSize=1)
    private Long id;
    private Integer importId = 0;
    @Widget(title="Project")
    @Index(name="PROJECT_PROJECT_TASK_PROJECT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProjectTask project;
    @Widget(title="Child Projects/Tasks")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjectTask> childProjectTaskList;
    @Widget(title="Name")
    @NotNull
    @Index(name="PROJECT_PROJECT_TASK_NAME_IDX")
    private String name;
    @Widget(title="Assigned to")
    @Index(name="PROJECT_PROJECT_TASK_ASSIGNED_TO_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedTo;
    @Widget(title="Type", selection="project.task.type.select")
    private String typeSelect;
    @Widget(title="Status", selection="project.task.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Code")
    @Index(name="PROJECT_PROJECT_TASK_CODE_IDX")
    private String code;
    @Widget(title="Membres")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> membersUserSet;
    @Widget(title="Customer")
    @Index(name="PROJECT_PROJECT_TASK_CLIENT_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="From Date")
    private LocalDateTime fromDate;
    @Widget(title="To Date")
    private LocalDateTime toDate;
    @Widget(title="Due Date")
    private LocalDateTime dueDate;
    @Widget(title="Duration")
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Time Spent")
    private BigDecimal timeSpent = BigDecimal.ZERO;
    @Widget(title="Lead/Delay")
    private BigDecimal leadDelay = BigDecimal.ZERO;
    @Widget(title="Progress (%)")
    private BigDecimal progress = BigDecimal.ZERO;
    @Widget(title="Sequence")
    private BigDecimal sequence = BigDecimal.ZERO;
    @Widget(title="Finish tasks to start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectTask> finishToStartTaskSet;
    @Widget(title="Start tasks to start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectTask> startToStartTaskSet;
    @Widget(title="Finish tasks to finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectTask> finishToFinishTaskSet;
    @Widget(title="Start tasks to finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectTask> startToFinishTaskSet;
    @Widget(title="Company")
    @Index(name="PROJECT_PROJECT_TASK_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Activities")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productList;
    @Widget(title="Name")
    @NameColumn
    @Index(name="PROJECT_PROJECT_TASK_FULL_NAME_IDX")
    private String fullName;

    public ProjectTask() {
    }

    public ProjectTask(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public ProjectTask getProject() {
        return this.project;
    }

    public void setProject(ProjectTask project) {
        this.project = project;
    }

    public List<ProjectTask> getChildProjectTaskList() {
        return this.childProjectTaskList;
    }

    public void setChildProjectTaskList(List<ProjectTask> childProjectTaskList) {
        this.childProjectTaskList = childProjectTaskList;
    }

    public void addChildProjectTaskListItem(ProjectTask item) {
        if (this.childProjectTaskList == null) {
            this.childProjectTaskList = new ArrayList<ProjectTask>();
        }
        this.childProjectTaskList.add(item);
        item.setProject(this);
    }

    public void removeChildProjectTaskListItem(ProjectTask item) {
        if (this.childProjectTaskList == null) {
            return;
        }
        this.childProjectTaskList.remove((Object)item);
    }

    public void clearChildProjectTaskList() {
        if (this.childProjectTaskList != null) {
            this.childProjectTaskList.clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public String getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Set<User> getMembersUserSet() {
        return this.membersUserSet;
    }

    public void setMembersUserSet(Set<User> membersUserSet) {
        this.membersUserSet = membersUserSet;
    }

    public void addMembersUserSetItem(User item) {
        if (this.membersUserSet == null) {
            this.membersUserSet = new HashSet<User>();
        }
        this.membersUserSet.add(item);
    }

    public void removeMembersUserSetItem(User item) {
        if (this.membersUserSet == null) {
            return;
        }
        this.membersUserSet.remove((Object)item);
    }

    public void clearMembersUserSet() {
        if (this.membersUserSet != null) {
            this.membersUserSet.clear();
        }
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
    }

    public LocalDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public BigDecimal getTimeSpent() {
        return this.timeSpent == null ? BigDecimal.ZERO : this.timeSpent;
    }

    public void setTimeSpent(BigDecimal timeSpent) {
        this.timeSpent = timeSpent;
    }

    public BigDecimal getLeadDelay() {
        return this.leadDelay == null ? BigDecimal.ZERO : this.leadDelay;
    }

    public void setLeadDelay(BigDecimal leadDelay) {
        this.leadDelay = leadDelay;
    }

    public BigDecimal getProgress() {
        return this.progress == null ? BigDecimal.ZERO : this.progress;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public BigDecimal getSequence() {
        return this.sequence == null ? BigDecimal.ZERO : this.sequence;
    }

    public void setSequence(BigDecimal sequence) {
        this.sequence = sequence;
    }

    public Set<ProjectTask> getFinishToStartTaskSet() {
        return this.finishToStartTaskSet;
    }

    public void setFinishToStartTaskSet(Set<ProjectTask> finishToStartTaskSet) {
        this.finishToStartTaskSet = finishToStartTaskSet;
    }

    public void addFinishToStartTaskSetItem(ProjectTask item) {
        if (this.finishToStartTaskSet == null) {
            this.finishToStartTaskSet = new HashSet<ProjectTask>();
        }
        this.finishToStartTaskSet.add(item);
    }

    public void removeFinishToStartTaskSetItem(ProjectTask item) {
        if (this.finishToStartTaskSet == null) {
            return;
        }
        this.finishToStartTaskSet.remove((Object)item);
    }

    public void clearFinishToStartTaskSet() {
        if (this.finishToStartTaskSet != null) {
            this.finishToStartTaskSet.clear();
        }
    }

    public Set<ProjectTask> getStartToStartTaskSet() {
        return this.startToStartTaskSet;
    }

    public void setStartToStartTaskSet(Set<ProjectTask> startToStartTaskSet) {
        this.startToStartTaskSet = startToStartTaskSet;
    }

    public void addStartToStartTaskSetItem(ProjectTask item) {
        if (this.startToStartTaskSet == null) {
            this.startToStartTaskSet = new HashSet<ProjectTask>();
        }
        this.startToStartTaskSet.add(item);
    }

    public void removeStartToStartTaskSetItem(ProjectTask item) {
        if (this.startToStartTaskSet == null) {
            return;
        }
        this.startToStartTaskSet.remove((Object)item);
    }

    public void clearStartToStartTaskSet() {
        if (this.startToStartTaskSet != null) {
            this.startToStartTaskSet.clear();
        }
    }

    public Set<ProjectTask> getFinishToFinishTaskSet() {
        return this.finishToFinishTaskSet;
    }

    public void setFinishToFinishTaskSet(Set<ProjectTask> finishToFinishTaskSet) {
        this.finishToFinishTaskSet = finishToFinishTaskSet;
    }

    public void addFinishToFinishTaskSetItem(ProjectTask item) {
        if (this.finishToFinishTaskSet == null) {
            this.finishToFinishTaskSet = new HashSet<ProjectTask>();
        }
        this.finishToFinishTaskSet.add(item);
    }

    public void removeFinishToFinishTaskSetItem(ProjectTask item) {
        if (this.finishToFinishTaskSet == null) {
            return;
        }
        this.finishToFinishTaskSet.remove((Object)item);
    }

    public void clearFinishToFinishTaskSet() {
        if (this.finishToFinishTaskSet != null) {
            this.finishToFinishTaskSet.clear();
        }
    }

    public Set<ProjectTask> getStartToFinishTaskSet() {
        return this.startToFinishTaskSet;
    }

    public void setStartToFinishTaskSet(Set<ProjectTask> startToFinishTaskSet) {
        this.startToFinishTaskSet = startToFinishTaskSet;
    }

    public void addStartToFinishTaskSetItem(ProjectTask item) {
        if (this.startToFinishTaskSet == null) {
            this.startToFinishTaskSet = new HashSet<ProjectTask>();
        }
        this.startToFinishTaskSet.add(item);
    }

    public void removeStartToFinishTaskSetItem(ProjectTask item) {
        if (this.startToFinishTaskSet == null) {
            return;
        }
        this.startToFinishTaskSet.remove((Object)item);
    }

    public void clearStartToFinishTaskSet() {
        if (this.startToFinishTaskSet != null) {
            this.startToFinishTaskSet.clear();
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Product> getProductList() {
        return this.productList;
    }

    public void setProductList(Set<Product> productList) {
        this.productList = productList;
    }

    public void addProductListItem(Product item) {
        if (this.productList == null) {
            this.productList = new HashSet<Product>();
        }
        this.productList.add(item);
    }

    public void removeProductListItem(Product item) {
        if (this.productList == null) {
            return;
        }
        this.productList.remove(item);
    }

    public void clearProductList() {
        if (this.productList != null) {
            this.productList.clear();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectTask)) {
            return false;
        }
        ProjectTask other = (ProjectTask)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("typeSelect", (Object)this.getTypeSelect());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        tsh.add("code", (Object)this.getCode());
        tsh.add("fromDate", (Object)this.getFromDate());
        tsh.add("toDate", (Object)this.getToDate());
        tsh.add("dueDate", (Object)this.getDueDate());
        tsh.add("duration", (Object)this.getDuration());
        tsh.add("timeSpent", (Object)this.getTimeSpent());
        tsh.add("leadDelay", (Object)this.getLeadDelay());
        return tsh.omitNullValues().toString();
    }
}

