/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.base.db.Team;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.project.db.ProjectPlanning;
import com.axelor.apps.project.db.ProjectPlanningLine;
import com.axelor.apps.project.db.ProjectTask;
import com.axelor.apps.project.db.repo.ProjectPlanningLineRepository;
import com.axelor.apps.project.db.repo.ProjectPlanningRepository;
import com.axelor.apps.project.db.repo.ProjectTaskRepository;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class ProjectPlanningService {
    @Inject
    protected ProjectPlanningLineRepository projectPlanningLineRepository;
    @Inject
    protected GeneralService generalService;
    @Inject
    protected ProjectPlanningRepository projectPlanningRepo;

    @Transactional
    public ProjectPlanning createPlanning(int year, int week) throws AxelorException {
        ProjectPlanning planning = new ProjectPlanning();
        planning.setYear(year);
        planning.setWeek(week);
        this.projectPlanningRepo.save((Model)planning);
        return planning;
    }

    public static String getNameForColumns(int year, int week, int day) {
        LocalDate date = new LocalDate().withYear(year).withWeekOfWeekyear(week).withDayOfWeek(1);
        LocalDate newDate = date.plusDays(day - 1);
        return " " + Integer.toString(newDate.getDayOfMonth()) + "/" + Integer.toString(newDate.getMonthOfYear());
    }

    @Transactional
    public List<ProjectPlanningLine> populateMyPlanning(ProjectPlanning planning, User user) throws AxelorException {
        ArrayList<ProjectPlanningLine> planningLineList = new ArrayList<ProjectPlanningLine>();
        String query = "self.assignedTo = ?1 OR ?1 MEMBER OF self.membersUserSet";
        List projectTaskList = ((ProjectTaskRepository)((Object)Beans.get(ProjectTaskRepository.class))).all().filter(query, new Object[]{user}).fetch();
        if (projectTaskList == null || projectTaskList.isEmpty()) {
            throw new AxelorException(String.format(I18n.get((String)"You have no projects or tasks bound to you, your planning can't be generated."), new Object[0]), 4, new Object[0]);
        }
        for (ProjectTask projectTask : projectTaskList) {
            ProjectPlanningLine projectPlanningLine = null;
            projectPlanningLine = (ProjectPlanningLine)this.projectPlanningLineRepository.all().filter("self.user = ?1 AND self.projectTask = ?2 AND self.year = ?3 AND self.week = ?4", new Object[]{user, projectTask, planning.getYear(), planning.getWeek()}).fetchOne();
            if (projectPlanningLine == null) {
                projectPlanningLine = new ProjectPlanningLine();
                projectPlanningLine.setUser(user);
                projectPlanningLine.setProjectTask(projectTask);
                projectPlanningLine.setYear(planning.getYear());
                projectPlanningLine.setWeek(planning.getWeek());
                this.projectPlanningLineRepository.save((Model)projectPlanningLine);
            }
            planningLineList.add(projectPlanningLine);
        }
        return planningLineList;
    }

    @Transactional
    public List<ProjectPlanningLine> populateMyTeamPlanning(ProjectPlanning planning, Team team) throws AxelorException {
        ArrayList<ProjectPlanningLine> planningLineList = new ArrayList<ProjectPlanningLine>();
        List projectTaskList = null;
        Set userList = team.getUserSet();
        for (User user : userList) {
            String query = "self.assignedTo = ?1 OR ?1 MEMBER OF self.membersUserSet";
            projectTaskList = ((ProjectTaskRepository)((Object)Beans.get(ProjectTaskRepository.class))).all().filter(query, new Object[]{user}).fetch();
            if (projectTaskList == null || projectTaskList.isEmpty()) continue;
            for (ProjectTask projectTask : projectTaskList) {
                ProjectPlanningLine projectPlanningLine = null;
                projectPlanningLine = (ProjectPlanningLine)this.projectPlanningLineRepository.all().filter("self.user = ?1 AND self.projectTask = ?2 AND self.year = ?3 AND self.week = ?4", new Object[]{user, projectTask, planning.getYear(), planning.getWeek()}).fetchOne();
                if (projectPlanningLine == null) {
                    projectPlanningLine = new ProjectPlanningLine();
                    projectPlanningLine.setUser(user);
                    projectPlanningLine.setProjectTask(projectTask);
                    projectPlanningLine.setYear(planning.getYear());
                    projectPlanningLine.setWeek(planning.getWeek());
                    this.projectPlanningLineRepository.save((Model)projectPlanningLine);
                }
                planningLineList.add(projectPlanningLine);
            }
        }
        if (planningLineList.isEmpty()) {
            throw new AxelorException(String.format(I18n.get((String)"Your team has no projects or tasks bound to it, the planning can't be generated."), new Object[0]), 4, new Object[0]);
        }
        return planningLineList;
    }

    public LocalDate getFromDate() {
        LocalDate todayDate = this.generalService.getTodayDate();
        return new LocalDate(todayDate.getYear(), todayDate.getMonthOfYear(), todayDate.dayOfMonth().getMinimumValue());
    }

    public LocalDate getToDate() {
        LocalDate todayDate = this.generalService.getTodayDate();
        return new LocalDate(todayDate.getYear(), todayDate.getMonthOfYear(), todayDate.dayOfMonth().getMaximumValue());
    }

    public void getTasksForUser(ActionRequest request, ActionResponse response) {
        ArrayList dataList = new ArrayList();
        try {
            LocalDate todayDate = ((GeneralService)Beans.get(GeneralService.class)).getTodayDate();
            List linesList = ((ProjectPlanningLineRepository)((Object)Beans.get(ProjectPlanningLineRepository.class))).all().filter("self.user.id = ?1 AND self.year >= ?2 AND self.week >= ?3", new Object[]{AuthUtils.getUser().getId(), todayDate.getYear(), todayDate.getWeekOfWeekyear()}).fetch();
            for (ProjectPlanningLine line : linesList) {
                HashMap<String, String> map;
                LocalDate date;
                if (line.getMonday().compareTo(BigDecimal.ZERO) != 0 && ((date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(1)).isAfter((ReadablePartial)todayDate) || date.isEqual((ReadablePartial)todayDate))) {
                    map = new HashMap<String, String>();
                    map.put("taskId", line.getProjectTask().getId().toString());
                    map.put("name", line.getProjectTask().getFullName());
                    if (line.getProjectTask().getProject() != null) {
                        map.put("projectName", line.getProjectTask().getProject().getFullName());
                    } else {
                        map.put("projectName", "");
                    }
                    map.put("date", date.toString());
                    map.put("duration", line.getMonday().toString());
                    dataList.add(map);
                }
                if (line.getTuesday().compareTo(BigDecimal.ZERO) != 0 && ((date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(2)).isAfter((ReadablePartial)todayDate) || date.isEqual((ReadablePartial)todayDate))) {
                    map = new HashMap();
                    map.put("taskId", line.getProjectTask().getId().toString());
                    map.put("name", line.getProjectTask().getFullName());
                    if (line.getProjectTask().getProject() != null) {
                        map.put("projectName", line.getProjectTask().getProject().getFullName());
                    } else {
                        map.put("projectName", "");
                    }
                    map.put("date", date.toString());
                    map.put("duration", line.getTuesday().toString());
                    dataList.add(map);
                }
                if (line.getWednesday().compareTo(BigDecimal.ZERO) != 0 && ((date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(3)).isAfter((ReadablePartial)todayDate) || date.isEqual((ReadablePartial)todayDate))) {
                    map = new HashMap();
                    map.put("taskId", line.getProjectTask().getId().toString());
                    map.put("name", line.getProjectTask().getFullName());
                    if (line.getProjectTask().getProject() != null) {
                        map.put("projectName", line.getProjectTask().getProject().getFullName());
                    } else {
                        map.put("projectName", "");
                    }
                    map.put("date", date.toString());
                    map.put("duration", line.getWednesday().toString());
                    dataList.add(map);
                }
                if (line.getThursday().compareTo(BigDecimal.ZERO) != 0 && ((date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(4)).isAfter((ReadablePartial)todayDate) || date.isEqual((ReadablePartial)todayDate))) {
                    map = new HashMap();
                    map.put("taskId", line.getProjectTask().getId().toString());
                    map.put("name", line.getProjectTask().getFullName());
                    if (line.getProjectTask().getProject() != null) {
                        map.put("projectName", line.getProjectTask().getProject().getFullName());
                    } else {
                        map.put("projectName", "");
                    }
                    map.put("date", date.toString());
                    map.put("duration", line.getThursday().toString());
                    dataList.add(map);
                }
                if (line.getFriday().compareTo(BigDecimal.ZERO) != 0 && ((date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(5)).isAfter((ReadablePartial)todayDate) || date.isEqual((ReadablePartial)todayDate))) {
                    map = new HashMap();
                    map.put("taskId", line.getProjectTask().getId().toString());
                    map.put("name", line.getProjectTask().getFullName());
                    if (line.getProjectTask().getProject() != null) {
                        map.put("projectName", line.getProjectTask().getProject().getFullName());
                    } else {
                        map.put("projectName", "");
                    }
                    map.put("date", date.toString());
                    map.put("duration", line.getFriday().toString());
                    dataList.add(map);
                }
                if (line.getSaturday().compareTo(BigDecimal.ZERO) != 0 && ((date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(6)).isAfter((ReadablePartial)todayDate) || date.isEqual((ReadablePartial)todayDate))) {
                    map = new HashMap();
                    map.put("taskId", line.getProjectTask().getId().toString());
                    map.put("name", line.getProjectTask().getFullName());
                    if (line.getProjectTask().getProject() != null) {
                        map.put("projectName", line.getProjectTask().getProject().getFullName());
                    } else {
                        map.put("projectName", "");
                    }
                    map.put("date", date.toString());
                    map.put("duration", line.getSaturday().toString());
                    dataList.add(map);
                }
                if (line.getSunday().compareTo(BigDecimal.ZERO) == 0 || !(date = new LocalDate().withYear(line.getYear().intValue()).withWeekOfWeekyear(line.getWeek().intValue()).withDayOfWeek(7)).isAfter((ReadablePartial)todayDate) && !date.isEqual((ReadablePartial)todayDate)) continue;
                map = new HashMap();
                map.put("taskId", line.getProjectTask().getId().toString());
                map.put("name", line.getProjectTask().getFullName());
                if (line.getProjectTask().getProject() != null) {
                    map.put("projectName", line.getProjectTask().getProject().getFullName());
                } else {
                    map.put("projectName", "");
                }
                map.put("date", date.toString());
                map.put("duration", line.getSunday().toString());
                dataList.add(map);
            }
            response.setData(dataList);
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setError(e.getMessage());
        }
    }
}

