/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.project.db.ProjectTask;
import com.axelor.apps.project.db.repo.ProjectTaskRepository;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import javax.persistence.TypedQuery;

public class ProjectTaskService {
    public static int MAX_LEVEL_OF_PROJECT = 10;

    public ProjectTask generateProject(ProjectTask parentProject, String fullName, User assignedTo, Company company, Partner clientPartner) {
        ProjectTask project = new ProjectTask();
        project.setTypeSelect("project");
        project.setStatusSelect(ProjectTaskRepository.STATE_PLANNED);
        project.setProject(parentProject);
        project.setName(fullName);
        if (Strings.isNullOrEmpty((String)fullName)) {
            project.setName("project");
        }
        project.setFullName(project.getName());
        project.setCompany(company);
        project.setClientPartner(clientPartner);
        project.setAssignedTo(assignedTo);
        project.setProgress(BigDecimal.ZERO);
        project.addMembersUserSetItem(assignedTo);
        return project;
    }

    public ProjectTask generateTask(ProjectTask project, String fullName, User assignedTo) {
        ProjectTask task = new ProjectTask();
        task.setTypeSelect("task");
        task.setStatusSelect(ProjectTaskRepository.STATE_PLANNED);
        task.setProject(project);
        task.setName(fullName);
        if (Strings.isNullOrEmpty((String)fullName)) {
            task.setName(project.getFullName() + "_task");
        }
        task.setFullName(task.getName());
        task.setAssignedTo(assignedTo);
        task.setProgress(BigDecimal.ZERO);
        return task;
    }

    public Partner getClientPartnerFromProjectTask(ProjectTask projectTask) throws AxelorException {
        return this.getClientPartnerFromProjectTask(projectTask, 0);
    }

    private Partner getClientPartnerFromProjectTask(ProjectTask projectTask, int counter) throws AxelorException {
        if (projectTask.getProject() == null) {
            if (projectTask.getClientPartner() == null) {
                throw new AxelorException(String.format(I18n.get((String)"The selected project/task doesn't contain any customers"), new Object[0]), 4, new Object[0]);
            }
            return projectTask.getClientPartner();
        }
        if (counter > MAX_LEVEL_OF_PROJECT) {
            throw new AxelorException(String.format(I18n.get((String)"The deep limit of the project is too high "), new Object[0]), 4, new Object[0]);
        }
        return this.getClientPartnerFromProjectTask(projectTask.getProject(), counter++);
    }

    public BigDecimal computeDurationFromChildren(Long projectTaskId) {
        TypedQuery q = null;
        BigDecimal totalDuration = BigDecimal.ZERO;
        String query = "SELECT SUM(pt.duration) FROM ProjectTask as pt WHERE pt.project.id = :projectTaskId";
        q = JPA.em().createQuery(query, BigDecimal.class);
        q.setParameter("projectTaskId", (Object)projectTaskId);
        totalDuration = (BigDecimal)q.getSingleResult();
        return totalDuration;
    }
}

