/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.web;

import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.project.db.ProjectPlanning;
import com.axelor.apps.project.db.ProjectPlanningLine;
import com.axelor.apps.project.db.repo.ProjectPlanningLineRepository;
import com.axelor.apps.project.db.repo.ProjectPlanningRepository;
import com.axelor.apps.project.service.ProjectPlanningService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;
import org.joda.time.LocalDate;

public class ProjectPlanningController {
    @Inject
    protected ProjectPlanningService projectPlanningService;
    @Inject
    protected ProjectPlanningLineRepository projectPlanningLineRepository;
    @Inject
    protected ProjectPlanningRepository projectPlanningRepo;
    @Inject
    protected GeneralService generalService;

    public void myPlanning(ActionRequest request, ActionResponse response) throws AxelorException {
        LocalDate todayDate = this.generalService.getTodayDate();
        ProjectPlanning planning = (ProjectPlanning)this.projectPlanningRepo.all().filter("self.year = ?1 AND self.week = ?2", new Object[]{todayDate.getYear(), todayDate.getWeekOfWeekyear()}).fetchOne();
        if (planning == null) {
            planning = this.projectPlanningService.createPlanning(todayDate.getYear(), todayDate.getWeekOfWeekyear());
        }
        response.setView(ActionView.define((String)("Week" + planning.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planning.getId())).context("_type", (Object)"user").map());
    }

    public void myTeamPlanning(ActionRequest request, ActionResponse response) throws AxelorException {
        LocalDate todayDate = this.generalService.getTodayDate();
        ProjectPlanning planning = (ProjectPlanning)this.projectPlanningRepo.all().filter("self.year = ?1 AND self.week = ?2", new Object[]{todayDate.getYear(), todayDate.getWeekOfWeekyear()}).fetchOne();
        if (planning == null) {
            planning = this.projectPlanningService.createPlanning(todayDate.getYear(), todayDate.getWeekOfWeekyear());
        }
        response.setView(ActionView.define((String)("Week" + planning.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-team-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planning.getId())).context("_type", (Object)"team").map());
    }

    public void planningPreviousWeek(ActionRequest request, ActionResponse response) throws AxelorException {
        ProjectPlanning planning = (ProjectPlanning)((Object)request.getContext().asType(ProjectPlanning.class));
        int previousWeek = planning.getWeek() - 1;
        int year = planning.getYear();
        if (previousWeek < 1) {
            previousWeek = 52;
            --year;
        }
        ProjectPlanning planningPreviousWeek = null;
        planningPreviousWeek = (ProjectPlanning)this.projectPlanningRepo.all().filter("self.year = ?1 AND self.week = ?2", new Object[]{year, previousWeek}).fetchOne();
        if (planningPreviousWeek == null) {
            planningPreviousWeek = this.projectPlanningService.createPlanning(year, previousWeek);
        }
        String type = request.getContext().get((Object)"_type").toString();
        response.setCanClose(true);
        if (type.contentEquals("user")) {
            response.setView(ActionView.define((String)("Week" + planningPreviousWeek.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planningPreviousWeek.getId())).context("_type", (Object)"user").map());
        } else {
            response.setView(ActionView.define((String)("Week" + planningPreviousWeek.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-team-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planningPreviousWeek.getId())).context("_type", (Object)"team").map());
        }
    }

    public void planningNextWeek(ActionRequest request, ActionResponse response) throws AxelorException {
        ProjectPlanning planning = (ProjectPlanning)((Object)request.getContext().asType(ProjectPlanning.class));
        int nextWeek = planning.getWeek() + 1;
        int year = planning.getYear();
        if (nextWeek > 52) {
            nextWeek = 1;
            ++year;
        }
        ProjectPlanning planningNextWeek = null;
        planningNextWeek = (ProjectPlanning)this.projectPlanningRepo.all().filter("self.year = ?1 AND self.week = ?2", new Object[]{year, nextWeek}).fetchOne();
        if (planningNextWeek == null) {
            planningNextWeek = this.projectPlanningService.createPlanning(year, nextWeek);
        }
        String type = request.getContext().get((Object)"_type").toString();
        response.setCanClose(true);
        if (type.contentEquals("user")) {
            response.setView(ActionView.define((String)("Week" + planningNextWeek.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planningNextWeek.getId())).context("_type", (Object)"user").map());
        } else {
            response.setView(ActionView.define((String)("Week" + planningNextWeek.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-team-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planningNextWeek.getId())).context("_type", (Object)"team").map());
        }
    }

    public void planningCurrentWeek(ActionRequest request, ActionResponse response) throws AxelorException {
        request.getContext().asType(ProjectPlanning.class);
        LocalDate currentDate = this.generalService.getTodayDate();
        int year = currentDate.getYear();
        int week = currentDate.getWeekOfWeekyear();
        ProjectPlanning planningCurrentWeek = null;
        planningCurrentWeek = (ProjectPlanning)this.projectPlanningRepo.all().filter("self.year = ?1 AND self.week = ?2", new Object[]{year, week}).fetchOne();
        if (planningCurrentWeek == null) {
            planningCurrentWeek = this.projectPlanningService.createPlanning(year, week);
        }
        String type = request.getContext().get((Object)"_type").toString();
        response.setCanClose(true);
        if (type.contentEquals("user")) {
            response.setView(ActionView.define((String)("Week" + planningCurrentWeek.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planningCurrentWeek.getId())).context("_type", (Object)"user").map());
        } else {
            response.setView(ActionView.define((String)("Week" + planningCurrentWeek.getWeek())).model(ProjectPlanning.class.getName()).add("form", "project-my-team-planning-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(planningCurrentWeek.getId())).context("_type", (Object)"team").map());
        }
    }

    public void populate(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = AuthUtils.getUser();
        ProjectPlanning planning = (ProjectPlanning)((Object)request.getContext().asType(ProjectPlanning.class));
        String type = request.getContext().get((Object)"_type").toString();
        List<ProjectPlanningLine> projectPlanningLineList = null;
        try {
            if (type.contentEquals("user")) {
                projectPlanningLineList = this.projectPlanningService.populateMyPlanning(planning, user);
            } else {
                if (user.getActiveTeam() == null) {
                    throw new AxelorException("You have no active team, the planning can't be generated", 4, new Object[0]);
                }
                projectPlanningLineList = this.projectPlanningService.populateMyTeamPlanning(planning, user.getActiveTeam());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
        response.setValue("$projectPlanningLineList", projectPlanningLineList);
    }

    @Transactional
    public void saveLines(ActionRequest request, ActionResponse response) throws AxelorException {
        List planningLineList = (List)request.getContext().get((Object)"projectPlanningLineList");
        if (planningLineList != null) {
            for (ProjectPlanningLine projectPlanningLine : planningLineList) {
                if (!(projectPlanningLine = (ProjectPlanningLine)((Object)EntityHelper.getEntity((Object)((Object)projectPlanningLine)))).getToSave().booleanValue()) continue;
                this.projectPlanningLineRepository.save((Model)projectPlanningLine);
            }
        }
    }
}

