/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Team;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaPermission;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Index;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@Table(name="AUTH_USER")
public class User
extends AuditableModel {
    @HashKey
    @Widget(title="Login")
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @HashKey
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String name;
    @Widget(password=true)
    @NotNull
    @Size(min=4)
    private String password;
    @Widget(image=true, title="Photo", help="Max size 4MB.")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] image;
    @HashKey
    @Column(unique=true)
    private String email;
    @Widget(selection="select.language")
    private String language;
    private String homeAction;
    private String theme;
    @Widget(help="Whether to use tabbed ui.")
    private Boolean singleTab = Boolean.FALSE;
    @Widget(help="Whether to show help messages.")
    private Boolean noHelp = Boolean.FALSE;
    @Widget(help="Specify whether to block the user for an indeterminate times.")
    private Boolean blocked = Boolean.FALSE;
    @Widget(help="Activate the user from the specified date.")
    private LocalDate activateOn;
    @Widget(help="Disable the user from the specified date.")
    private LocalDate expiresOn;
    @Index(name="AUTH_USER_GROUP_ID_IDX")
    @JoinColumn(name="group_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Group group;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Permission> permissions;
    @Widget(title="Permissions (fields)")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaPermission> metaPermissions;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_USER_SEQ")
    @SequenceGenerator(name="AUTH_USER_SEQ", sequenceName="AUTH_USER_SEQ", allocationSize=1)
    private Long id;
    private String importId;
    @Widget(title="Company")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Active company", help="true")
    @Index(name="AUTH_USER_ACTIVE_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company activeCompany;
    @Widget(title="Partner", help="true")
    @Index(name="AUTH_USER_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Today date", help="true")
    private DateTime today;
    @Widget(title="Teams")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Team> teamSet;
    @Widget(title="Active Team", help="true")
    @Index(name="AUTH_USER_ACTIVE_TEAM_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team activeTeam;
    @Widget(title="Partner name", search={"partner", "name"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Index(name="AUTH_USER_FULL_NAME_IDX")
    private String fullName;

    public User() {
    }

    public User(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getHomeAction() {
        return this.homeAction;
    }

    public void setHomeAction(String homeAction) {
        this.homeAction = homeAction;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Boolean getSingleTab() {
        return this.singleTab == null ? Boolean.FALSE : this.singleTab;
    }

    public void setSingleTab(Boolean singleTab) {
        this.singleTab = singleTab;
    }

    public Boolean getNoHelp() {
        return this.noHelp == null ? Boolean.FALSE : this.noHelp;
    }

    public void setNoHelp(Boolean noHelp) {
        this.noHelp = noHelp;
    }

    public Boolean getBlocked() {
        return this.blocked == null ? Boolean.FALSE : this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public LocalDate getActivateOn() {
        return this.activateOn;
    }

    public void setActivateOn(LocalDate activateOn) {
        this.activateOn = activateOn;
    }

    public LocalDate getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(LocalDate expiresOn) {
        this.expiresOn = expiresOn;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.roles == null) {
            this.roles = new HashSet<Role>();
        }
        this.roles.add(item);
    }

    public void removeRole(Role item) {
        if (this.roles == null) {
            return;
        }
        this.roles.remove(item);
    }

    public void clearRoles() {
        if (this.roles != null) {
            this.roles.clear();
        }
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission item) {
        if (this.permissions == null) {
            this.permissions = new HashSet<Permission>();
        }
        this.permissions.add(item);
    }

    public void removePermission(Permission item) {
        if (this.permissions == null) {
            return;
        }
        this.permissions.remove(item);
    }

    public void clearPermissions() {
        if (this.permissions != null) {
            this.permissions.clear();
        }
    }

    public Set<MetaPermission> getMetaPermissions() {
        return this.metaPermissions;
    }

    public void setMetaPermissions(Set<MetaPermission> metaPermissions) {
        this.metaPermissions = metaPermissions;
    }

    public void addMetaPermission(MetaPermission item) {
        if (this.metaPermissions == null) {
            this.metaPermissions = new HashSet<MetaPermission>();
        }
        this.metaPermissions.add(item);
    }

    public void removeMetaPermission(MetaPermission item) {
        if (this.metaPermissions == null) {
            return;
        }
        this.metaPermissions.remove(item);
    }

    public void clearMetaPermissions() {
        if (this.metaPermissions != null) {
            this.metaPermissions.clear();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.companySet == null) {
            this.companySet = new HashSet<Company>();
        }
        this.companySet.add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.companySet == null) {
            return;
        }
        this.companySet.remove(item);
    }

    public void clearCompanySet() {
        if (this.companySet != null) {
            this.companySet.clear();
        }
    }

    public Company getActiveCompany() {
        return this.activeCompany;
    }

    public void setActiveCompany(Company activeCompany) {
        this.activeCompany = activeCompany;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public DateTime getToday() {
        return this.today;
    }

    public void setToday(DateTime today) {
        this.today = today;
    }

    public Set<Team> getTeamSet() {
        return this.teamSet;
    }

    public void setTeamSet(Set<Team> teamSet) {
        this.teamSet = teamSet;
    }

    public void addTeamSetItem(Team item) {
        if (this.teamSet == null) {
            this.teamSet = new HashSet<Team>();
        }
        this.teamSet.add(item);
    }

    public void removeTeamSetItem(Team item) {
        if (this.teamSet == null) {
            return;
        }
        this.teamSet.remove(item);
    }

    public void clearTeamSet() {
        if (this.teamSet != null) {
            this.teamSet.clear();
        }
    }

    public Team getActiveTeam() {
        return this.activeTeam;
    }

    public void setActiveTeam(Team activeTeam) {
        this.activeTeam = activeTeam;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        if (this.partner != null) {
            if (this.partner.getFirstName() != null) {
                return this.partner.getFirstName() + " " + this.partner.getName();
            }
            return this.partner.getName();
        }
        return this.name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            return false;
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        return Objects.equals(this.getEmail(), other.getEmail());
    }

    public int hashCode() {
        return Objects.hash(2645995, this.getCode(), this.getName(), this.getEmail());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("code", (Object)this.getCode());
        tsh.add("name", (Object)this.getName());
        tsh.add("email", (Object)this.getEmail());
        tsh.add("language", (Object)this.getLanguage());
        tsh.add("homeAction", (Object)this.getHomeAction());
        tsh.add("theme", (Object)this.getTheme());
        tsh.add("singleTab", (Object)this.getSingleTab());
        tsh.add("noHelp", (Object)this.getNoHelp());
        tsh.add("blocked", (Object)this.getBlocked());
        tsh.add("activateOn", (Object)this.getActivateOn());
        tsh.add("expiresOn", (Object)this.getExpiresOn());
        return tsh.omitNullValues().toString();
    }
}

