/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AnalyticAccount;
import com.axelor.apps.account.db.AnalyticAxis;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticJournal;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;

@Entity
@Table(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE")
public class AnalyticDistributionLine
extends AuditableModel {
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SALE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_PURCHASE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrderLine purchaseOrderLine;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SEQ", sequenceName="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SEQ", allocationSize=1)
    private Long id;
    @Index(name="idx_acc_ana_dist_line_ana_dist_template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_INVOICE_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceLine invoiceLine;
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_MOVE_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Axis")
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_ANALYTIC_AXIS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAxis analyticAxis;
    @Widget(title="Analytic Acc.")
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_ANALYTIC_ACCOUNT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount analyticAccount;
    @Widget(title="%")
    private BigDecimal percentage = BigDecimal.ZERO;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Date")
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Analytic Journal")
    @Index(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_ANALYTIC_JOURNAL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticJournal analyticJournal;

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public PurchaseOrderLine getPurchaseOrderLine() {
        return this.purchaseOrderLine;
    }

    public void setPurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        this.purchaseOrderLine = purchaseOrderLine;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public InvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(InvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public AnalyticAxis getAnalyticAxis() {
        return this.analyticAxis;
    }

    public void setAnalyticAxis(AnalyticAxis analyticAxis) {
        this.analyticAxis = analyticAxis;
    }

    public AnalyticAccount getAnalyticAccount() {
        return this.analyticAccount;
    }

    public void setAnalyticAccount(AnalyticAccount analyticAccount) {
        this.analyticAccount = analyticAccount;
    }

    public BigDecimal getPercentage() {
        return this.percentage == null ? BigDecimal.ZERO : this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public AnalyticJournal getAnalyticJournal() {
        return this.analyticJournal;
    }

    public void setAnalyticJournal(AnalyticJournal analyticJournal) {
        this.analyticJournal = analyticJournal;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnalyticDistributionLine)) {
            return false;
        }
        AnalyticDistributionLine other = (AnalyticDistributionLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("percentage", (Object)this.getPercentage());
        tsh.add("amount", (Object)this.getAmount());
        tsh.add("date", (Object)this.getDate());
        return tsh.omitNullValues().toString();
    }
}

