/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountEquiv;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Table(name="ACCOUNT_FISCAL_POSITION")
public class FiscalPosition
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Name")
    @NotNull
    @Index(name="ACCOUNT_FISCAL_POSITION_NAME_IDX")
    private String name;
    @Widget(title="Code")
    @NotNull
    @Index(name="ACCOUNT_FISCAL_POSITION_CODE_IDX")
    private String code;
    @Widget(title="Tax equivalences")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fiscalPosition", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxEquiv> taxEquivList;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_FISCAL_POSITION_SEQ")
    @SequenceGenerator(name="ACCOUNT_FISCAL_POSITION_SEQ", sequenceName="ACCOUNT_FISCAL_POSITION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Account equivalences")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fiscalPosition", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountEquiv> accountEquivList;

    public FiscalPosition() {
    }

    public FiscalPosition(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<TaxEquiv> getTaxEquivList() {
        return this.taxEquivList;
    }

    public void setTaxEquivList(List<TaxEquiv> taxEquivList) {
        this.taxEquivList = taxEquivList;
    }

    public void addTaxEquivListItem(TaxEquiv item) {
        if (this.taxEquivList == null) {
            this.taxEquivList = new ArrayList<TaxEquiv>();
        }
        this.taxEquivList.add(item);
        item.setFiscalPosition(this);
    }

    public void removeTaxEquivListItem(TaxEquiv item) {
        if (this.taxEquivList == null) {
            return;
        }
        this.taxEquivList.remove(item);
    }

    public void clearTaxEquivList() {
        if (this.taxEquivList != null) {
            this.taxEquivList.clear();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<AccountEquiv> getAccountEquivList() {
        return this.accountEquivList;
    }

    public void setAccountEquivList(List<AccountEquiv> accountEquivList) {
        this.accountEquivList = accountEquivList;
    }

    public void addAccountEquivListItem(AccountEquiv item) {
        if (this.accountEquivList == null) {
            this.accountEquivList = new ArrayList<AccountEquiv>();
        }
        this.accountEquivList.add(item);
        item.setFiscalPosition(this);
    }

    public void removeAccountEquivListItem(AccountEquiv item) {
        if (this.accountEquivList == null) {
            return;
        }
        this.accountEquivList.remove(item);
    }

    public void clearAccountEquivList() {
        if (this.accountEquivList != null) {
            this.accountEquivList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FiscalPosition)) {
            return false;
        }
        FiscalPosition other = (FiscalPosition)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("code", (Object)this.getCode());
        return tsh.omitNullValues().toString();
    }
}

