/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.BankOrderFileFormat;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Cacheable
@Table(name="ACCOUNT_PAYMENT_MODE")
public class PaymentMode
extends AuditableModel {
    private Integer importId = 0;
    @HashKey
    @Widget(title="Label")
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Code")
    @NotNull
    @Index(name="ACCOUNT_PAYMENT_MODE_CODE_IDX")
    private String code;
    @Widget(title="Type", help="true", selection="iaccount.payment.mode.type.select")
    private Integer typeSelect = 0;
    @Widget(title="In / Out ?", help="true", selection="iaccount.payment.mode.in.out.select")
    private Integer inOutSelect = 0;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_MODE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_MODE_SEQ", sequenceName="ACCOUNT_PAYMENT_MODE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Accounting settings")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="paymentMode", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    @Widget(title="Invoice label", help="true")
    private String invoiceLabel;
    @Widget(title="Generate Bank order")
    private Boolean generateBankOrder = Boolean.FALSE;
    @Widget(title="Transmit automatically to Bank")
    private Boolean automaticTransmission = Boolean.FALSE;
    @Widget(title="Order Type", selection="iaccount.bank.order.type.select")
    private Integer orderTypeSelect = 0;
    @Widget(help="true")
    private String bankOrderExportFolderPath;
    @Widget(title="File format")
    @Index(name="ACCOUNT_PAYMENT_MODE_BANK_ORDER_FILE_FORMAT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderFileFormat bankOrderFileFormat;

    public PaymentMode() {
    }

    public PaymentMode(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getInOutSelect() {
        return this.inOutSelect == null ? 0 : this.inOutSelect;
    }

    public void setInOutSelect(Integer inOutSelect) {
        this.inOutSelect = inOutSelect;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.accountManagementList == null) {
            this.accountManagementList = new ArrayList<AccountManagement>();
        }
        this.accountManagementList.add(item);
        item.setPaymentMode(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.accountManagementList == null) {
            return;
        }
        this.accountManagementList.remove((Object)item);
    }

    public void clearAccountManagementList() {
        if (this.accountManagementList != null) {
            this.accountManagementList.clear();
        }
    }

    public String getInvoiceLabel() {
        return this.invoiceLabel;
    }

    public void setInvoiceLabel(String invoiceLabel) {
        this.invoiceLabel = invoiceLabel;
    }

    public Boolean getGenerateBankOrder() {
        return this.generateBankOrder == null ? Boolean.FALSE : this.generateBankOrder;
    }

    public void setGenerateBankOrder(Boolean generateBankOrder) {
        this.generateBankOrder = generateBankOrder;
    }

    public Boolean getAutomaticTransmission() {
        return this.automaticTransmission == null ? Boolean.FALSE : this.automaticTransmission;
    }

    public void setAutomaticTransmission(Boolean automaticTransmission) {
        this.automaticTransmission = automaticTransmission;
    }

    public Integer getOrderTypeSelect() {
        return this.orderTypeSelect == null ? 0 : this.orderTypeSelect;
    }

    public void setOrderTypeSelect(Integer orderTypeSelect) {
        this.orderTypeSelect = orderTypeSelect;
    }

    public String getBankOrderExportFolderPath() {
        return this.bankOrderExportFolderPath;
    }

    public void setBankOrderExportFolderPath(String bankOrderExportFolderPath) {
        this.bankOrderExportFolderPath = bankOrderExportFolderPath;
    }

    public BankOrderFileFormat getBankOrderFileFormat() {
        return this.bankOrderFileFormat;
    }

    public void setBankOrderFileFormat(BankOrderFileFormat bankOrderFileFormat) {
        this.bankOrderFileFormat = bankOrderFileFormat;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentMode)) {
            return false;
        }
        PaymentMode other = (PaymentMode)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(127276201, this.getName());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("code", (Object)this.getCode());
        tsh.add("typeSelect", (Object)this.getTypeSelect());
        tsh.add("inOutSelect", (Object)this.getInOutSelect());
        tsh.add("invoiceLabel", (Object)this.getInvoiceLabel());
        tsh.add("generateBankOrder", (Object)this.getGenerateBankOrder());
        tsh.add("automaticTransmission", (Object)this.getAutomaticTransmission());
        tsh.add("orderTypeSelect", (Object)this.getOrderTypeSelect());
        tsh.add("bankOrderExportFolderPath", (Object)this.getBankOrderExportFolderPath());
        return tsh.omitNullValues().toString();
    }
}

