/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.TaxAccount;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Cacheable
@Table(name="ACCOUNT_TAX", uniqueConstraints={@UniqueConstraint(columnNames={"code", "name"})})
public class Tax
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Name")
    @NotNull
    @Index(name="ACCOUNT_TAX_NAME_IDX")
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Tax active version")
    @Index(name="ACCOUNT_TAX_ACTIVE_TAX_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine activeTaxLine;
    @Widget(title="Tax versions history")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tax", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxLine> taxLineList;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_TAX_SEQ")
    @SequenceGenerator(name="ACCOUNT_TAX_SEQ", sequenceName="ACCOUNT_TAX_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Tax account configuration")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tax", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxAccount> taxAccountList;

    public Tax() {
    }

    public Tax(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public TaxLine getActiveTaxLine() {
        return this.activeTaxLine;
    }

    public void setActiveTaxLine(TaxLine activeTaxLine) {
        this.activeTaxLine = activeTaxLine;
    }

    public List<TaxLine> getTaxLineList() {
        return this.taxLineList;
    }

    public void setTaxLineList(List<TaxLine> taxLineList) {
        this.taxLineList = taxLineList;
    }

    public void addTaxLineListItem(TaxLine item) {
        if (this.taxLineList == null) {
            this.taxLineList = new ArrayList<TaxLine>();
        }
        this.taxLineList.add(item);
        item.setTax(this);
    }

    public void removeTaxLineListItem(TaxLine item) {
        if (this.taxLineList == null) {
            return;
        }
        this.taxLineList.remove(item);
    }

    public void clearTaxLineList() {
        if (this.taxLineList != null) {
            this.taxLineList.clear();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<TaxAccount> getTaxAccountList() {
        return this.taxAccountList;
    }

    public void setTaxAccountList(List<TaxAccount> taxAccountList) {
        this.taxAccountList = taxAccountList;
    }

    public void addTaxAccountListItem(TaxAccount item) {
        if (this.taxAccountList == null) {
            this.taxAccountList = new ArrayList<TaxAccount>();
        }
        this.taxAccountList.add(item);
        item.setTax(this);
    }

    public void removeTaxAccountListItem(TaxAccount item) {
        if (this.taxAccountList == null) {
            return;
        }
        this.taxAccountList.remove(item);
    }

    public void clearTaxAccountList() {
        if (this.taxAccountList != null) {
            this.taxAccountList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tax)) {
            return false;
        }
        Tax other = (Tax)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(83851, this.getCode());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("code", (Object)this.getCode());
        return tsh.omitNullValues().toString();
    }
}

