/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.InvoiceBatch;
import com.axelor.apps.base.db.AlarmEngineBatch;
import com.axelor.apps.base.db.BaseBatch;
import com.axelor.apps.base.db.MailBatch;
import com.axelor.apps.crm.db.CrmBatch;
import com.axelor.apps.sale.db.SaleBatch;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="BASE_BATCH")
public class Batch
extends AuditableModel {
    @Index(name="BASE_BATCH_ALARM_ENGINE_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AlarmEngineBatch alarmEngineBatch;
    @Index(name="BASE_BATCH_BASE_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BaseBatch baseBatch;
    @Index(name="BASE_BATCH_MAIL_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailBatch mailBatch;
    @Widget(title="Start Date", readonly=true)
    private DateTime startDate;
    @Widget(title="End Date", readonly=true)
    private DateTime endDate;
    @Widget(title="Duration", readonly=true)
    private Integer duration = 0;
    @Widget(title="Succeeded")
    private Integer done = 0;
    @Widget(title="Anomaly")
    private Integer anomaly = 0;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String comments;
    @Index(name="BASE_BATCH_SUPPLYCHAIN_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SupplychainBatch supplychainBatch;
    @Index(name="BASE_BATCH_CRM_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CrmBatch crmBatch;
    @Index(name="BASE_BATCH_SALE_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleBatch saleBatch;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BATCH_SEQ")
    @SequenceGenerator(name="BASE_BATCH_SEQ", sequenceName="BASE_BATCH_SEQ", allocationSize=1)
    private Long id;
    @Index(name="BASE_BATCH_INVOICE_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceBatch invoiceBatch;
    @Index(name="BASE_BATCH_ACCOUNTING_BATCH_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountingBatch accountingBatch;

    public AlarmEngineBatch getAlarmEngineBatch() {
        return this.alarmEngineBatch;
    }

    public void setAlarmEngineBatch(AlarmEngineBatch alarmEngineBatch) {
        this.alarmEngineBatch = alarmEngineBatch;
    }

    public BaseBatch getBaseBatch() {
        return this.baseBatch;
    }

    public void setBaseBatch(BaseBatch baseBatch) {
        this.baseBatch = baseBatch;
    }

    public MailBatch getMailBatch() {
        return this.mailBatch;
    }

    public void setMailBatch(MailBatch mailBatch) {
        this.mailBatch = mailBatch;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(DateTime endDate) {
        this.endDate = endDate;
    }

    public Integer getDuration() {
        return this.duration == null ? 0 : this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDone() {
        return this.done == null ? 0 : this.done;
    }

    public void setDone(Integer done) {
        this.done = done;
    }

    public Integer getAnomaly() {
        return this.anomaly == null ? 0 : this.anomaly;
    }

    public void setAnomaly(Integer anomaly) {
        this.anomaly = anomaly;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public SupplychainBatch getSupplychainBatch() {
        return this.supplychainBatch;
    }

    public void setSupplychainBatch(SupplychainBatch supplychainBatch) {
        this.supplychainBatch = supplychainBatch;
    }

    public CrmBatch getCrmBatch() {
        return this.crmBatch;
    }

    public void setCrmBatch(CrmBatch crmBatch) {
        this.crmBatch = crmBatch;
    }

    public SaleBatch getSaleBatch() {
        return this.saleBatch;
    }

    public void setSaleBatch(SaleBatch saleBatch) {
        this.saleBatch = saleBatch;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public InvoiceBatch getInvoiceBatch() {
        return this.invoiceBatch;
    }

    public void setInvoiceBatch(InvoiceBatch invoiceBatch) {
        this.invoiceBatch = invoiceBatch;
    }

    public AccountingBatch getAccountingBatch() {
        return this.accountingBatch;
    }

    public void setAccountingBatch(AccountingBatch accountingBatch) {
        this.accountingBatch = accountingBatch;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Batch)) {
            return false;
        }
        Batch other = (Batch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("startDate", (Object)this.getStartDate());
        tsh.add("endDate", (Object)this.getEndDate());
        tsh.add("duration", (Object)this.getDuration());
        tsh.add("done", (Object)this.getDone());
        tsh.add("anomaly", (Object)this.getAnomaly());
        return tsh.omitNullValues().toString();
    }
}

