/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.StopReason;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_BLOCKING")
public class Blocking
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Company")
    @Index(name="BASE_BLOCKING_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Partner")
    @Index(name="BASE_BLOCKING_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Block Reminders ?")
    private Boolean reminderBlockingOk = Boolean.FALSE;
    @Widget(title="Block until")
    private LocalDate reminderBlockingToDate;
    @Widget(title="Blocking reason")
    @Index(name="BASE_BLOCKING_REMINDER_BLOCKING_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason reminderBlockingReason;
    @Widget(title="Blocking done by")
    @Index(name="BASE_BLOCKING_REMINDER_BLOCKING_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User reminderBlockingByUser;
    @Widget(title="Block Invoicing ?")
    private Boolean invoicingBlockingOk = Boolean.FALSE;
    @Widget(title="Block until")
    private LocalDate invoicingBlockingToDate;
    @Widget(title="Blocking reason")
    @Index(name="BASE_BLOCKING_INVOICING_BLOCKING_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason invoicingBlockingReason;
    @Widget(title="Blocking done by")
    @Index(name="BASE_BLOCKING_INVOICING_BLOCKING_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User invoicingBlockingByUser;
    @Widget(title="Block Reimbursement ?")
    private Boolean reimbursementBlockingOk = Boolean.FALSE;
    @Widget(title="Block until")
    private LocalDate reimbursementBlockingToDate;
    @Widget(title="Blocking reason")
    @Index(name="BASE_BLOCKING_REIMBURSEMENT_BLOCKING_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason reimbursementBlockingReason;
    @Widget(title="Blocking done by")
    @Index(name="BASE_BLOCKING_REIMBURSEMENT_BLOCKING_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User reimbursementBlockingByUser;
    @Widget(title="Reference", search={"company", "partner"})
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Index(name="BASE_BLOCKING_NAME_IDX")
    private String name;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BLOCKING_SEQ")
    @SequenceGenerator(name="BASE_BLOCKING_SEQ", sequenceName="BASE_BLOCKING_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Block Direct Debit ?")
    private Boolean debitBlockingOk = Boolean.FALSE;
    @Widget(title="Block until")
    private LocalDate debitBlockingToDate;
    @Widget(title="Blocking reason")
    @Index(name="BASE_BLOCKING_DEBIT_BLOCKING_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason debitBlockingReason;
    @Widget(title="Blocking done by")
    @Index(name="BASE_BLOCKING_DEBIT_BLOCKING_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User debitBlockingByUser;

    public Blocking() {
    }

    public Blocking(String name) {
        this.name = name;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Boolean getReminderBlockingOk() {
        return this.reminderBlockingOk == null ? Boolean.FALSE : this.reminderBlockingOk;
    }

    public void setReminderBlockingOk(Boolean reminderBlockingOk) {
        this.reminderBlockingOk = reminderBlockingOk;
    }

    public LocalDate getReminderBlockingToDate() {
        return this.reminderBlockingToDate;
    }

    public void setReminderBlockingToDate(LocalDate reminderBlockingToDate) {
        this.reminderBlockingToDate = reminderBlockingToDate;
    }

    public StopReason getReminderBlockingReason() {
        return this.reminderBlockingReason;
    }

    public void setReminderBlockingReason(StopReason reminderBlockingReason) {
        this.reminderBlockingReason = reminderBlockingReason;
    }

    public User getReminderBlockingByUser() {
        return this.reminderBlockingByUser;
    }

    public void setReminderBlockingByUser(User reminderBlockingByUser) {
        this.reminderBlockingByUser = reminderBlockingByUser;
    }

    public Boolean getInvoicingBlockingOk() {
        return this.invoicingBlockingOk == null ? Boolean.FALSE : this.invoicingBlockingOk;
    }

    public void setInvoicingBlockingOk(Boolean invoicingBlockingOk) {
        this.invoicingBlockingOk = invoicingBlockingOk;
    }

    public LocalDate getInvoicingBlockingToDate() {
        return this.invoicingBlockingToDate;
    }

    public void setInvoicingBlockingToDate(LocalDate invoicingBlockingToDate) {
        this.invoicingBlockingToDate = invoicingBlockingToDate;
    }

    public StopReason getInvoicingBlockingReason() {
        return this.invoicingBlockingReason;
    }

    public void setInvoicingBlockingReason(StopReason invoicingBlockingReason) {
        this.invoicingBlockingReason = invoicingBlockingReason;
    }

    public User getInvoicingBlockingByUser() {
        return this.invoicingBlockingByUser;
    }

    public void setInvoicingBlockingByUser(User invoicingBlockingByUser) {
        this.invoicingBlockingByUser = invoicingBlockingByUser;
    }

    public Boolean getReimbursementBlockingOk() {
        return this.reimbursementBlockingOk == null ? Boolean.FALSE : this.reimbursementBlockingOk;
    }

    public void setReimbursementBlockingOk(Boolean reimbursementBlockingOk) {
        this.reimbursementBlockingOk = reimbursementBlockingOk;
    }

    public LocalDate getReimbursementBlockingToDate() {
        return this.reimbursementBlockingToDate;
    }

    public void setReimbursementBlockingToDate(LocalDate reimbursementBlockingToDate) {
        this.reimbursementBlockingToDate = reimbursementBlockingToDate;
    }

    public StopReason getReimbursementBlockingReason() {
        return this.reimbursementBlockingReason;
    }

    public void setReimbursementBlockingReason(StopReason reimbursementBlockingReason) {
        this.reimbursementBlockingReason = reimbursementBlockingReason;
    }

    public User getReimbursementBlockingByUser() {
        return this.reimbursementBlockingByUser;
    }

    public void setReimbursementBlockingByUser(User reimbursementBlockingByUser) {
        this.reimbursementBlockingByUser = reimbursementBlockingByUser;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.company != null && this.partner != null) {
            return this.company.getCode() + " - " + this.partner.getName();
        }
        if (this.partner != null) {
            return this.partner.getName();
        }
        if (this.company != null) {
            return this.company.getCode();
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getDebitBlockingOk() {
        return this.debitBlockingOk == null ? Boolean.FALSE : this.debitBlockingOk;
    }

    public void setDebitBlockingOk(Boolean debitBlockingOk) {
        this.debitBlockingOk = debitBlockingOk;
    }

    public LocalDate getDebitBlockingToDate() {
        return this.debitBlockingToDate;
    }

    public void setDebitBlockingToDate(LocalDate debitBlockingToDate) {
        this.debitBlockingToDate = debitBlockingToDate;
    }

    public StopReason getDebitBlockingReason() {
        return this.debitBlockingReason;
    }

    public void setDebitBlockingReason(StopReason debitBlockingReason) {
        this.debitBlockingReason = debitBlockingReason;
    }

    public User getDebitBlockingByUser() {
        return this.debitBlockingByUser;
    }

    public void setDebitBlockingByUser(User debitBlockingByUser) {
        this.debitBlockingByUser = debitBlockingByUser;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Blocking)) {
            return false;
        }
        Blocking other = (Blocking)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("reminderBlockingOk", (Object)this.getReminderBlockingOk());
        tsh.add("reminderBlockingToDate", (Object)this.getReminderBlockingToDate());
        tsh.add("invoicingBlockingOk", (Object)this.getInvoicingBlockingOk());
        tsh.add("invoicingBlockingToDate", (Object)this.getInvoicingBlockingToDate());
        tsh.add("reimbursementBlockingOk", (Object)this.getReimbursementBlockingOk());
        tsh.add("reimbursementBlockingToDate", (Object)this.getReimbursementBlockingToDate());
        tsh.add("debitBlockingOk", (Object)this.getDebitBlockingOk());
        tsh.add("debitBlockingToDate", (Object)this.getDebitBlockingToDate());
        return tsh.omitNullValues().toString();
    }
}

