/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.ReportedBalance;
import com.axelor.apps.account.db.Umr;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Blocking;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.IndustrySector;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.PartnerCategory;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Source;
import com.axelor.apps.base.db.Team;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.supplychain.db.CustomerCreditLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_PARTNER")
public class Partner
extends AuditableModel {
    private String importId;
    @Widget(title="Category")
    @Index(name="BASE_PARTNER_PARTNER_CATEGORY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PartnerCategory partnerCategory;
    @HashKey
    @Widget(title="Reference", readonly=true)
    @Column(unique=true)
    private String partnerSeq;
    @Widget(title="Partner Type", selection="partner.partner.type.select")
    private Integer partnerTypeSelect = 0;
    @Widget(title="Civility", selection="partner.title.type.select", massUpdate=true)
    private Integer titleSelect = 0;
    @Widget(title="Name/Company Name")
    @NotNull
    @Index(name="BASE_PARTNER_NAME_IDX")
    private String name;
    @Widget(title="First Name")
    private String firstName;
    @Widget(title="Function")
    private String jobTitle;
    @Widget(title="Photo")
    @Index(name="BASE_PARTNER_PICTURE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile picture;
    @Widget(title="Customer?")
    private Boolean isCustomer = Boolean.FALSE;
    @Widget(title="Has Ordered")
    private Boolean hasOrdered = Boolean.FALSE;
    @Widget(title="Supplier?")
    private Boolean isSupplier = Boolean.FALSE;
    @Widget(title="Employee")
    private Boolean isEmployee = Boolean.FALSE;
    @Widget(title="Contact ?")
    private Boolean isContact = Boolean.FALSE;
    @Widget(title="Language", help="true", selection="select.language", massUpdate=true)
    private String languageSelect;
    @Widget(title="Mother company", massUpdate=true)
    @Index(name="BASE_PARTNER_PARENT_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner parentPartner;
    @Widget(title="Addresses")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PartnerAddress> partnerAddressList;
    @Widget(title="Delivery delay (days)")
    private Integer deliveryDelay = 0;
    @Widget(title="Contacts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> contactPartnerSet;
    @Widget(title="Main company", help="true")
    @Index(name="BASE_PARTNER_MAIN_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner mainPartner;
    @Widget(title="Source")
    @Index(name="BASE_PARTNER_SOURCE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Source source;
    @Widget(title="Email")
    @Index(name="BASE_PARTNER_EMAIL_ADDRESS_IDX")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAddress emailAddress;
    @Widget(title="Fax")
    private String fax;
    @Widget(title="Fixed phone")
    private String fixedPhone;
    @Widget(title="Mobile phone")
    private String mobilePhone;
    @Widget(title="Website")
    private String webSite;
    @Widget(title="Dept./Div.")
    private String department;
    @Widget(title="Companies associated to", help="true")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Bank Details list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankDetails> bankDetailsList;
    @Widget(title="Currency", help="true")
    @Index(name="BASE_PARTNER_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Sale Price List")
    @Index(name="BASE_PARTNER_SALE_PRICE_LIST_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList salePriceList;
    @Widget(title="Purchase Price List")
    @Index(name="BASE_PARTNER_PURCHASE_PRICE_LIST_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList purchasePriceList;
    @Widget(title="Blocking follow-up List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Blocking> blockingList;
    @Widget(title="Batches")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Assigned to", help="true")
    @Index(name="BASE_PARTNER_USER_ID_IDX")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team", help="true")
    @Index(name="BASE_PARTNER_TEAM_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Reports to", help="true", massUpdate=true)
    @Index(name="BASE_PARTNER_REPORTS_TO_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner reportsTo;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Industry")
    @Index(name="BASE_PARTNER_INDUSTRY_SECTOR_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private IndustrySector industrySector;
    @Widget(title="Employees (Nbr)")
    private Integer nbrEmployees = 0;
    @Widget(title="Turnover")
    private Integer saleTurnover = 0;
    @Widget(title="Registration code", help="true")
    private String registrationCode;
    @Widget(title="Tax N\u00b0")
    private String taxNbr;
    @Widget(title="Name")
    @NameColumn
    @Index(name="BASE_PARTNER_FULL_NAME_IDX")
    private String fullName;
    @Widget(title="Fiscal position", help="true")
    @Index(name="BASE_PARTNER_FISCAL_POSITION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FiscalPosition fiscalPosition;
    @Widget(title="Address")
    @Index(name="BASE_PARTNER_CONTACT_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address contactAddress;
    @Widget(multiline=true)
    private String purchaseOrderInformation;
    @Widget(title="Customer Credits")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CustomerCreditLine> customerCreditLineList;
    @Widget(multiline=true)
    private String saleOrderInformation;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PARTNER_SEQ")
    @SequenceGenerator(name="BASE_PARTNER_SEQ", sequenceName="BASE_PARTNER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Payer quality", readonly=true)
    private BigDecimal payerQuality = BigDecimal.ZERO;
    @Widget(title="Reported Balance")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ReportedBalance> reportedBalanceList;
    @Widget(title="Accounting situation")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountingSituation> accountingSituationList;
    @Widget(title="Invoice sending media", selection="invoice.account.condition.invoice.sending.format.select")
    private String invoiceSendingFormatSelect;
    @Widget(title="Payment Mode")
    @Index(name="BASE_PARTNER_PAYMENT_MODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @Index(name="BASE_PARTNER_PAYMENT_CONDITION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Reject counter")
    private Integer rejectCounter = 0;
    @Widget(title="UMR List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="partner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Umr> umrList;
    @Widget(title="Active UMR")
    @Index(name="BASE_PARTNER_ACTIVE_UMR_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Umr activeUmr;
    @Widget(title="Analytic distribution template")
    @Index(name="BASE_PARTNER_ANALYTIC_DISTRIBUTION_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;

    public Partner() {
    }

    public Partner(String name) {
        this.name = name;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public PartnerCategory getPartnerCategory() {
        return this.partnerCategory;
    }

    public void setPartnerCategory(PartnerCategory partnerCategory) {
        this.partnerCategory = partnerCategory;
    }

    public String getPartnerSeq() {
        return this.partnerSeq;
    }

    public void setPartnerSeq(String partnerSeq) {
        this.partnerSeq = partnerSeq;
    }

    public Integer getPartnerTypeSelect() {
        return this.partnerTypeSelect == null ? 0 : this.partnerTypeSelect;
    }

    public void setPartnerTypeSelect(Integer partnerTypeSelect) {
        this.partnerTypeSelect = partnerTypeSelect;
    }

    public Integer getTitleSelect() {
        return this.titleSelect == null ? 0 : this.titleSelect;
    }

    public void setTitleSelect(Integer titleSelect) {
        this.titleSelect = titleSelect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public MetaFile getPicture() {
        return this.picture;
    }

    public void setPicture(MetaFile picture) {
        this.picture = picture;
    }

    public Boolean getIsCustomer() {
        return this.isCustomer == null ? Boolean.FALSE : this.isCustomer;
    }

    public void setIsCustomer(Boolean isCustomer) {
        this.isCustomer = isCustomer;
    }

    public Boolean getHasOrdered() {
        return this.hasOrdered == null ? Boolean.FALSE : this.hasOrdered;
    }

    public void setHasOrdered(Boolean hasOrdered) {
        this.hasOrdered = hasOrdered;
    }

    public Boolean getIsSupplier() {
        return this.isSupplier == null ? Boolean.FALSE : this.isSupplier;
    }

    public void setIsSupplier(Boolean isSupplier) {
        this.isSupplier = isSupplier;
    }

    public Boolean getIsEmployee() {
        return this.isEmployee == null ? Boolean.FALSE : this.isEmployee;
    }

    public void setIsEmployee(Boolean isEmployee) {
        this.isEmployee = isEmployee;
    }

    public Boolean getIsContact() {
        return this.isContact == null ? Boolean.FALSE : this.isContact;
    }

    public void setIsContact(Boolean isContact) {
        this.isContact = isContact;
    }

    public String getLanguageSelect() {
        return this.languageSelect;
    }

    public void setLanguageSelect(String languageSelect) {
        this.languageSelect = languageSelect;
    }

    public Partner getParentPartner() {
        return this.parentPartner;
    }

    public void setParentPartner(Partner parentPartner) {
        this.parentPartner = parentPartner;
    }

    public List<PartnerAddress> getPartnerAddressList() {
        return this.partnerAddressList;
    }

    public void setPartnerAddressList(List<PartnerAddress> partnerAddressList) {
        this.partnerAddressList = partnerAddressList;
    }

    public void addPartnerAddressListItem(PartnerAddress item) {
        if (this.partnerAddressList == null) {
            this.partnerAddressList = new ArrayList<PartnerAddress>();
        }
        this.partnerAddressList.add(item);
        item.setPartner(this);
    }

    public void removePartnerAddressListItem(PartnerAddress item) {
        if (this.partnerAddressList == null) {
            return;
        }
        this.partnerAddressList.remove(item);
    }

    public void clearPartnerAddressList() {
        if (this.partnerAddressList != null) {
            this.partnerAddressList.clear();
        }
    }

    public Integer getDeliveryDelay() {
        return this.deliveryDelay == null ? 0 : this.deliveryDelay;
    }

    public void setDeliveryDelay(Integer deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public Set<Partner> getContactPartnerSet() {
        return this.contactPartnerSet;
    }

    public void setContactPartnerSet(Set<Partner> contactPartnerSet) {
        this.contactPartnerSet = contactPartnerSet;
    }

    public void addContactPartnerSetItem(Partner item) {
        if (this.contactPartnerSet == null) {
            this.contactPartnerSet = new HashSet<Partner>();
        }
        this.contactPartnerSet.add(item);
    }

    public void removeContactPartnerSetItem(Partner item) {
        if (this.contactPartnerSet == null) {
            return;
        }
        this.contactPartnerSet.remove((Object)item);
    }

    public void clearContactPartnerSet() {
        if (this.contactPartnerSet != null) {
            this.contactPartnerSet.clear();
        }
    }

    public Partner getMainPartner() {
        return this.mainPartner;
    }

    public void setMainPartner(Partner mainPartner) {
        this.mainPartner = mainPartner;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getFixedPhone() {
        return this.fixedPhone;
    }

    public void setFixedPhone(String fixedPhone) {
        this.fixedPhone = fixedPhone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public void setWebSite(String webSite) {
        this.webSite = webSite;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.companySet == null) {
            this.companySet = new HashSet<Company>();
        }
        this.companySet.add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.companySet == null) {
            return;
        }
        this.companySet.remove((Object)item);
    }

    public void clearCompanySet() {
        if (this.companySet != null) {
            this.companySet.clear();
        }
    }

    public List<BankDetails> getBankDetailsList() {
        return this.bankDetailsList;
    }

    public void setBankDetailsList(List<BankDetails> bankDetailsList) {
        this.bankDetailsList = bankDetailsList;
    }

    public void addBankDetailsListItem(BankDetails item) {
        if (this.bankDetailsList == null) {
            this.bankDetailsList = new ArrayList<BankDetails>();
        }
        this.bankDetailsList.add(item);
        item.setPartner(this);
    }

    public void removeBankDetailsListItem(BankDetails item) {
        if (this.bankDetailsList == null) {
            return;
        }
        this.bankDetailsList.remove(item);
    }

    public void clearBankDetailsList() {
        if (this.bankDetailsList != null) {
            this.bankDetailsList.clear();
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public PriceList getSalePriceList() {
        return this.salePriceList;
    }

    public void setSalePriceList(PriceList salePriceList) {
        this.salePriceList = salePriceList;
    }

    public PriceList getPurchasePriceList() {
        return this.purchasePriceList;
    }

    public void setPurchasePriceList(PriceList purchasePriceList) {
        this.purchasePriceList = purchasePriceList;
    }

    public List<Blocking> getBlockingList() {
        return this.blockingList;
    }

    public void setBlockingList(List<Blocking> blockingList) {
        this.blockingList = blockingList;
    }

    public void addBlockingListItem(Blocking item) {
        if (this.blockingList == null) {
            this.blockingList = new ArrayList<Blocking>();
        }
        this.blockingList.add(item);
        item.setPartner(this);
    }

    public void removeBlockingListItem(Blocking item) {
        if (this.blockingList == null) {
            return;
        }
        this.blockingList.remove((Object)item);
    }

    public void clearBlockingList() {
        if (this.blockingList != null) {
            this.blockingList.clear();
        }
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.batchSet == null) {
            this.batchSet = new HashSet<Batch>();
        }
        this.batchSet.add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.batchSet == null) {
            return;
        }
        this.batchSet.remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.batchSet != null) {
            this.batchSet.clear();
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Partner getReportsTo() {
        return this.reportsTo;
    }

    public void setReportsTo(Partner reportsTo) {
        this.reportsTo = reportsTo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IndustrySector getIndustrySector() {
        return this.industrySector;
    }

    public void setIndustrySector(IndustrySector industrySector) {
        this.industrySector = industrySector;
    }

    public Integer getNbrEmployees() {
        return this.nbrEmployees == null ? 0 : this.nbrEmployees;
    }

    public void setNbrEmployees(Integer nbrEmployees) {
        this.nbrEmployees = nbrEmployees;
    }

    public Integer getSaleTurnover() {
        return this.saleTurnover == null ? 0 : this.saleTurnover;
    }

    public void setSaleTurnover(Integer saleTurnover) {
        this.saleTurnover = saleTurnover;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public void setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
    }

    public String getTaxNbr() {
        return this.taxNbr;
    }

    public void setTaxNbr(String taxNbr) {
        this.taxNbr = taxNbr;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public FiscalPosition getFiscalPosition() {
        return this.fiscalPosition;
    }

    public void setFiscalPosition(FiscalPosition fiscalPosition) {
        this.fiscalPosition = fiscalPosition;
    }

    public Address getContactAddress() {
        return this.contactAddress;
    }

    public void setContactAddress(Address contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String getPurchaseOrderInformation() {
        return this.purchaseOrderInformation;
    }

    public void setPurchaseOrderInformation(String purchaseOrderInformation) {
        this.purchaseOrderInformation = purchaseOrderInformation;
    }

    public List<CustomerCreditLine> getCustomerCreditLineList() {
        return this.customerCreditLineList;
    }

    public void setCustomerCreditLineList(List<CustomerCreditLine> customerCreditLineList) {
        this.customerCreditLineList = customerCreditLineList;
    }

    public void addCustomerCreditLineListItem(CustomerCreditLine item) {
        if (this.customerCreditLineList == null) {
            this.customerCreditLineList = new ArrayList<CustomerCreditLine>();
        }
        this.customerCreditLineList.add(item);
        item.setPartner(this);
    }

    public void removeCustomerCreditLineListItem(CustomerCreditLine item) {
        if (this.customerCreditLineList == null) {
            return;
        }
        this.customerCreditLineList.remove(item);
    }

    public void clearCustomerCreditLineList() {
        if (this.customerCreditLineList != null) {
            this.customerCreditLineList.clear();
        }
    }

    public String getSaleOrderInformation() {
        return this.saleOrderInformation;
    }

    public void setSaleOrderInformation(String saleOrderInformation) {
        this.saleOrderInformation = saleOrderInformation;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getPayerQuality() {
        return this.payerQuality == null ? BigDecimal.ZERO : this.payerQuality;
    }

    public void setPayerQuality(BigDecimal payerQuality) {
        this.payerQuality = payerQuality;
    }

    public List<ReportedBalance> getReportedBalanceList() {
        return this.reportedBalanceList;
    }

    public void setReportedBalanceList(List<ReportedBalance> reportedBalanceList) {
        this.reportedBalanceList = reportedBalanceList;
    }

    public void addReportedBalanceListItem(ReportedBalance item) {
        if (this.reportedBalanceList == null) {
            this.reportedBalanceList = new ArrayList<ReportedBalance>();
        }
        this.reportedBalanceList.add(item);
        item.setPartner(this);
    }

    public void removeReportedBalanceListItem(ReportedBalance item) {
        if (this.reportedBalanceList == null) {
            return;
        }
        this.reportedBalanceList.remove(item);
    }

    public void clearReportedBalanceList() {
        if (this.reportedBalanceList != null) {
            this.reportedBalanceList.clear();
        }
    }

    public List<AccountingSituation> getAccountingSituationList() {
        return this.accountingSituationList;
    }

    public void setAccountingSituationList(List<AccountingSituation> accountingSituationList) {
        this.accountingSituationList = accountingSituationList;
    }

    public void addAccountingSituationListItem(AccountingSituation item) {
        if (this.accountingSituationList == null) {
            this.accountingSituationList = new ArrayList<AccountingSituation>();
        }
        this.accountingSituationList.add(item);
        item.setPartner(this);
    }

    public void removeAccountingSituationListItem(AccountingSituation item) {
        if (this.accountingSituationList == null) {
            return;
        }
        this.accountingSituationList.remove(item);
    }

    public void clearAccountingSituationList() {
        if (this.accountingSituationList != null) {
            this.accountingSituationList.clear();
        }
    }

    public String getInvoiceSendingFormatSelect() {
        return this.invoiceSendingFormatSelect;
    }

    public void setInvoiceSendingFormatSelect(String invoiceSendingFormatSelect) {
        this.invoiceSendingFormatSelect = invoiceSendingFormatSelect;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public Integer getRejectCounter() {
        return this.rejectCounter == null ? 0 : this.rejectCounter;
    }

    public void setRejectCounter(Integer rejectCounter) {
        this.rejectCounter = rejectCounter;
    }

    public List<Umr> getUmrList() {
        return this.umrList;
    }

    public void setUmrList(List<Umr> umrList) {
        this.umrList = umrList;
    }

    public void addUmrListItem(Umr item) {
        if (this.umrList == null) {
            this.umrList = new ArrayList<Umr>();
        }
        this.umrList.add(item);
        item.setPartner(this);
    }

    public void removeUmrListItem(Umr item) {
        if (this.umrList == null) {
            return;
        }
        this.umrList.remove(item);
    }

    public void clearUmrList() {
        if (this.umrList != null) {
            this.umrList.clear();
        }
    }

    public Umr getActiveUmr() {
        return this.activeUmr;
    }

    public void setActiveUmr(Umr activeUmr) {
        this.activeUmr = activeUmr;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Partner)) {
            return false;
        }
        Partner other = (Partner)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getPartnerSeq(), other.getPartnerSeq());
    }

    public int hashCode() {
        return Objects.hash(871724200, this.getPartnerSeq());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("partnerSeq", (Object)this.getPartnerSeq());
        tsh.add("partnerTypeSelect", (Object)this.getPartnerTypeSelect());
        tsh.add("titleSelect", (Object)this.getTitleSelect());
        tsh.add("name", (Object)this.getName());
        tsh.add("firstName", (Object)this.getFirstName());
        tsh.add("jobTitle", (Object)this.getJobTitle());
        tsh.add("isCustomer", (Object)this.getIsCustomer());
        tsh.add("hasOrdered", (Object)this.getHasOrdered());
        tsh.add("isSupplier", (Object)this.getIsSupplier());
        tsh.add("isEmployee", (Object)this.getIsEmployee());
        return tsh.omitNullValues().toString();
    }
}

