/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.base.db.ProductVariant;
import com.axelor.apps.base.db.ProductVariantConfig;
import com.axelor.apps.base.db.SupplierCatalog;
import com.axelor.apps.base.db.TrackingNumberConfiguration;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.supplychain.db.MrpFamily;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;

@Entity
@Table(name="BASE_PRODUCT")
public class Product
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Name")
    @NotNull
    @Index(name="BASE_PRODUCT_NAME_IDX")
    private String name;
    @Widget(title="Code")
    @NotNull
    @Index(name="BASE_PRODUCT_CODE_IDX")
    private String code;
    @HashKey
    @Widget(title="EAN13 Code")
    @Column(unique=true)
    private String ean13;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Internal description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String internalDescription;
    @Index(name="BASE_PRODUCT_PICTURE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile picture;
    @Widget(title="Product category", help="true", massUpdate=true)
    @Index(name="BASE_PRODUCT_PRODUCT_CATEGORY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductCategory productCategory;
    @Widget(title="Family", help="true")
    @Index(name="BASE_PRODUCT_PRODUCT_FAMILY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductFamily productFamily;
    @Widget(title="Unit", help="true", massUpdate=true)
    @Index(name="BASE_PRODUCT_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Sale supply default method", help="true", selection="product.sale.supply.select")
    private Integer saleSupplySelect = 0;
    @Widget(title="Type", help="true", selection="product.product.type.select")
    @NotNull
    private String productTypeSelect;
    @Widget(title="Procurement method", help="true", selection="product.procurement.method.select")
    private String procurementMethodSelect;
    @Widget(title="Raw material", help="true")
    private Boolean isRawMaterial = Boolean.FALSE;
    @Widget(title="Sale price W.T.", massUpdate=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal salePrice = BigDecimal.ZERO;
    @Widget(title="Sale currency")
    @Index(name="BASE_PRODUCT_SALE_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency saleCurrency;
    @Widget(title="Purchase price W.T.", massUpdate=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal purchasePrice = BigDecimal.ZERO;
    @Widget(title="Purchase / Cost currency")
    @Index(name="BASE_PRODUCT_PURCHASE_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency purchaseCurrency;
    @Widget(title="Cost price", help="true", massUpdate=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal costPrice = BigDecimal.ZERO;
    @Widget(title="Management coef.", help="true")
    private BigDecimal managPriceCoef = BigDecimal.ZERO;
    @Widget(title="Product launch Date", help="true")
    private LocalDate startDate;
    @Widget(title="Product pulled off market Date", help="true")
    private LocalDate endDate;
    @Widget(title="Supplier Catalog Lines", help="true")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SupplierCatalog> supplierCatalogList;
    @Widget(title="Tracking Nbr. Config.", help="true")
    @Index(name="BASE_PRODUCT_TRACKING_NUMBER_CONFIGURATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrackingNumberConfiguration trackingNumberConfiguration;
    @Widget(title="Warranty ?")
    private Boolean hasWarranty = Boolean.FALSE;
    @Widget(title="Perishable ?")
    private Boolean isPerishable = Boolean.FALSE;
    @Widget(title="Warranty length (in months)")
    private Integer warrantyNbrOfMonths = 0;
    @Widget(title="Time before expiry (in months)")
    private Integer perishableNbrOfMonths = 0;
    @Index(name="BASE_PRODUCT_PRODUCT_VARIANT_CONFIG_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariantConfig productVariantConfig;
    @Index(name="BASE_PRODUCT_PRODUCT_VARIANT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductVariant productVariant;
    @Widget(title="Parent product", help="true")
    @Index(name="BASE_PRODUCT_PARENT_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product parentProduct;
    @Widget(title="Is model?")
    private Boolean isModel = Boolean.FALSE;
    @Widget(title="Default supplier", help="true")
    @Index(name="BASE_PRODUCT_DEFAULT_SUPPLIER_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner defaultSupplierPartner;
    @Widget(title="Accounts configuration", help="true")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    @Widget(title="Version", selection="base.product.version.select")
    private Integer versionSelect = 0;
    @Widget(title="Sellable")
    private Boolean sellable = Boolean.TRUE;
    @Widget(title="Purchasable")
    private Boolean purchasable = Boolean.TRUE;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Cost type", selection="base.product.cost.type.select")
    private Integer costTypeSelect = 1;
    @Widget(title="Supplier delivery time (days)")
    private Integer supplierDeliveryTime = 0;
    @Widget(title="Barcode")
    @Index(name="BASE_PRODUCT_BAR_CODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile barCode;
    @Widget(title="Full name")
    @NameColumn
    @Index(name="BASE_PRODUCT_FULL_NAME_IDX")
    private String fullName;
    @Widget(title="Purchases unit", help="true", massUpdate=true)
    @Index(name="BASE_PRODUCT_PURCHASES_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit purchasesUnit;
    @Widget(title="Periodicity", selection="product.periodicity.subscription.select")
    private Integer periodicitySelect = 1;
    @Widget(title="MRP family")
    @Index(name="BASE_PRODUCT_MRP_FAMILY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MrpFamily mrpFamily;
    @Widget(title="Exclude from MRP")
    private Boolean excludeFromMrp = Boolean.FALSE;
    @Widget(title="Sales unit", help="true", massUpdate=true)
    @Index(name="BASE_PRODUCT_SALES_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit salesUnit;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PRODUCT_SEQ")
    @SequenceGenerator(name="BASE_PRODUCT_SEQ", sequenceName="BASE_PRODUCT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Use for Analytic Capture")
    private Boolean isAnalyticCapture = Boolean.FALSE;

    public Product() {
    }

    public Product(String name, String code, String description, String internalDescription, MetaFile picture, ProductCategory productCategory, ProductFamily productFamily, Unit unit, Integer saleSupplySelect, String productTypeSelect, String procurementMethodSelect, Boolean isRawMaterial, Currency saleCurrency, Currency purchaseCurrency, LocalDate startDate, LocalDate endDate) {
        this.name = name;
        this.code = code;
        this.description = description;
        this.internalDescription = internalDescription;
        this.picture = picture;
        this.productCategory = productCategory;
        this.productFamily = productFamily;
        this.unit = unit;
        this.saleSupplySelect = saleSupplySelect;
        this.productTypeSelect = productTypeSelect;
        this.procurementMethodSelect = procurementMethodSelect;
        this.isRawMaterial = isRawMaterial;
        this.saleCurrency = saleCurrency;
        this.purchaseCurrency = purchaseCurrency;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEan13() {
        return this.ean13;
    }

    public void setEan13(String ean13) {
        this.ean13 = ean13;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public void setInternalDescription(String internalDescription) {
        this.internalDescription = internalDescription;
    }

    public MetaFile getPicture() {
        return this.picture;
    }

    public void setPicture(MetaFile picture) {
        this.picture = picture;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public ProductFamily getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(ProductFamily productFamily) {
        this.productFamily = productFamily;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Integer getSaleSupplySelect() {
        return this.saleSupplySelect == null ? 0 : this.saleSupplySelect;
    }

    public void setSaleSupplySelect(Integer saleSupplySelect) {
        this.saleSupplySelect = saleSupplySelect;
    }

    public String getProductTypeSelect() {
        return this.productTypeSelect;
    }

    public void setProductTypeSelect(String productTypeSelect) {
        this.productTypeSelect = productTypeSelect;
    }

    public String getProcurementMethodSelect() {
        return this.procurementMethodSelect;
    }

    public void setProcurementMethodSelect(String procurementMethodSelect) {
        this.procurementMethodSelect = procurementMethodSelect;
    }

    public Boolean getIsRawMaterial() {
        return this.isRawMaterial == null ? Boolean.FALSE : this.isRawMaterial;
    }

    public void setIsRawMaterial(Boolean isRawMaterial) {
        this.isRawMaterial = isRawMaterial;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice == null ? BigDecimal.ZERO : this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Currency getSaleCurrency() {
        return this.saleCurrency;
    }

    public void setSaleCurrency(Currency saleCurrency) {
        this.saleCurrency = saleCurrency;
    }

    public BigDecimal getPurchasePrice() {
        return this.purchasePrice == null ? BigDecimal.ZERO : this.purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public Currency getPurchaseCurrency() {
        return this.purchaseCurrency;
    }

    public void setPurchaseCurrency(Currency purchaseCurrency) {
        this.purchaseCurrency = purchaseCurrency;
    }

    public BigDecimal getCostPrice() {
        return this.costPrice == null ? BigDecimal.ZERO : this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getManagPriceCoef() {
        return this.managPriceCoef == null ? BigDecimal.ZERO : this.managPriceCoef;
    }

    public void setManagPriceCoef(BigDecimal managPriceCoef) {
        this.managPriceCoef = managPriceCoef;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public List<SupplierCatalog> getSupplierCatalogList() {
        return this.supplierCatalogList;
    }

    public void setSupplierCatalogList(List<SupplierCatalog> supplierCatalogList) {
        this.supplierCatalogList = supplierCatalogList;
    }

    public void addSupplierCatalogListItem(SupplierCatalog item) {
        if (this.supplierCatalogList == null) {
            this.supplierCatalogList = new ArrayList<SupplierCatalog>();
        }
        this.supplierCatalogList.add(item);
        item.setProduct(this);
    }

    public void removeSupplierCatalogListItem(SupplierCatalog item) {
        if (this.supplierCatalogList == null) {
            return;
        }
        this.supplierCatalogList.remove(item);
    }

    public void clearSupplierCatalogList() {
        if (this.supplierCatalogList != null) {
            this.supplierCatalogList.clear();
        }
    }

    public TrackingNumberConfiguration getTrackingNumberConfiguration() {
        return this.trackingNumberConfiguration;
    }

    public void setTrackingNumberConfiguration(TrackingNumberConfiguration trackingNumberConfiguration) {
        this.trackingNumberConfiguration = trackingNumberConfiguration;
    }

    public Boolean getHasWarranty() {
        return this.hasWarranty == null ? Boolean.FALSE : this.hasWarranty;
    }

    public void setHasWarranty(Boolean hasWarranty) {
        this.hasWarranty = hasWarranty;
    }

    public Boolean getIsPerishable() {
        return this.isPerishable == null ? Boolean.FALSE : this.isPerishable;
    }

    public void setIsPerishable(Boolean isPerishable) {
        this.isPerishable = isPerishable;
    }

    public Integer getWarrantyNbrOfMonths() {
        return this.warrantyNbrOfMonths == null ? 0 : this.warrantyNbrOfMonths;
    }

    public void setWarrantyNbrOfMonths(Integer warrantyNbrOfMonths) {
        this.warrantyNbrOfMonths = warrantyNbrOfMonths;
    }

    public Integer getPerishableNbrOfMonths() {
        return this.perishableNbrOfMonths == null ? 0 : this.perishableNbrOfMonths;
    }

    public void setPerishableNbrOfMonths(Integer perishableNbrOfMonths) {
        this.perishableNbrOfMonths = perishableNbrOfMonths;
    }

    public ProductVariantConfig getProductVariantConfig() {
        return this.productVariantConfig;
    }

    public void setProductVariantConfig(ProductVariantConfig productVariantConfig) {
        this.productVariantConfig = productVariantConfig;
    }

    public ProductVariant getProductVariant() {
        return this.productVariant;
    }

    public void setProductVariant(ProductVariant productVariant) {
        this.productVariant = productVariant;
    }

    public Product getParentProduct() {
        return this.parentProduct;
    }

    public void setParentProduct(Product parentProduct) {
        this.parentProduct = parentProduct;
    }

    public Boolean getIsModel() {
        return this.isModel == null ? Boolean.FALSE : this.isModel;
    }

    public void setIsModel(Boolean isModel) {
        this.isModel = isModel;
    }

    public Partner getDefaultSupplierPartner() {
        return this.defaultSupplierPartner;
    }

    public void setDefaultSupplierPartner(Partner defaultSupplierPartner) {
        this.defaultSupplierPartner = defaultSupplierPartner;
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.accountManagementList == null) {
            this.accountManagementList = new ArrayList<AccountManagement>();
        }
        this.accountManagementList.add(item);
        item.setProduct(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.accountManagementList == null) {
            return;
        }
        this.accountManagementList.remove((Object)item);
    }

    public void clearAccountManagementList() {
        if (this.accountManagementList != null) {
            this.accountManagementList.clear();
        }
    }

    public Integer getVersionSelect() {
        return this.versionSelect == null ? 0 : this.versionSelect;
    }

    public void setVersionSelect(Integer versionSelect) {
        this.versionSelect = versionSelect;
    }

    public Boolean getSellable() {
        return this.sellable == null ? Boolean.FALSE : this.sellable;
    }

    public void setSellable(Boolean sellable) {
        this.sellable = sellable;
    }

    public Boolean getPurchasable() {
        return this.purchasable == null ? Boolean.FALSE : this.purchasable;
    }

    public void setPurchasable(Boolean purchasable) {
        this.purchasable = purchasable;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public Integer getCostTypeSelect() {
        return this.costTypeSelect == null ? 0 : this.costTypeSelect;
    }

    public void setCostTypeSelect(Integer costTypeSelect) {
        this.costTypeSelect = costTypeSelect;
    }

    public Integer getSupplierDeliveryTime() {
        return this.supplierDeliveryTime == null ? 0 : this.supplierDeliveryTime;
    }

    public void setSupplierDeliveryTime(Integer supplierDeliveryTime) {
        this.supplierDeliveryTime = supplierDeliveryTime;
    }

    public MetaFile getBarCode() {
        return this.barCode;
    }

    public void setBarCode(MetaFile barCode) {
        this.barCode = barCode;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Unit getPurchasesUnit() {
        return this.purchasesUnit;
    }

    public void setPurchasesUnit(Unit purchasesUnit) {
        this.purchasesUnit = purchasesUnit;
    }

    public Integer getPeriodicitySelect() {
        return this.periodicitySelect == null ? 0 : this.periodicitySelect;
    }

    public void setPeriodicitySelect(Integer periodicitySelect) {
        this.periodicitySelect = periodicitySelect;
    }

    public MrpFamily getMrpFamily() {
        return this.mrpFamily;
    }

    public void setMrpFamily(MrpFamily mrpFamily) {
        this.mrpFamily = mrpFamily;
    }

    public Boolean getExcludeFromMrp() {
        return this.excludeFromMrp == null ? Boolean.FALSE : this.excludeFromMrp;
    }

    public void setExcludeFromMrp(Boolean excludeFromMrp) {
        this.excludeFromMrp = excludeFromMrp;
    }

    public Unit getSalesUnit() {
        return this.salesUnit;
    }

    public void setSalesUnit(Unit salesUnit) {
        this.salesUnit = salesUnit;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getIsAnalyticCapture() {
        return this.isAnalyticCapture == null ? Boolean.FALSE : this.isAnalyticCapture;
    }

    public void setIsAnalyticCapture(Boolean isAnalyticCapture) {
        this.isAnalyticCapture = isAnalyticCapture;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Product)) {
            return false;
        }
        Product other = (Product)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getEan13(), other.getEan13());
    }

    public int hashCode() {
        return Objects.hash(1355179215, this.getEan13());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("code", (Object)this.getCode());
        tsh.add("ean13", (Object)this.getEan13());
        tsh.add("saleSupplySelect", (Object)this.getSaleSupplySelect());
        tsh.add("productTypeSelect", (Object)this.getProductTypeSelect());
        tsh.add("procurementMethodSelect", (Object)this.getProcurementMethodSelect());
        tsh.add("isRawMaterial", (Object)this.getIsRawMaterial());
        tsh.add("salePrice", (Object)this.getSalePrice());
        tsh.add("purchasePrice", (Object)this.getPurchasePrice());
        tsh.add("costPrice", (Object)this.getCostPrice());
        return tsh.omitNullValues().toString();
    }
}

