/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Lead;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="MESSAGE_EMAIL_ADDRESS")
public class EmailAddress
extends AuditableModel {
    private String importId;
    @Widget(title="Contact")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="emailAddress", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Address", help="true")
    private String address;
    @Widget(readonly=true)
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @NotNull
    @Index(name="MESSAGE_EMAIL_ADDRESS_NAME_IDX")
    private String name;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_EMAIL_ADDRESS_SEQ")
    @SequenceGenerator(name="MESSAGE_EMAIL_ADDRESS_SEQ", sequenceName="MESSAGE_EMAIL_ADDRESS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Lead")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="emailAddress", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Lead lead;

    public EmailAddress() {
    }

    public EmailAddress(String name) {
        this.name = name;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.partner != null) {
            name = name + this.partner.getFullName() + " ";
        }
        if (this.address != null) {
            name = name + "[" + this.address + "]";
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Lead getLead() {
        return this.lead;
    }

    public void setLead(Lead lead) {
        this.lead = lead;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmailAddress)) {
            return false;
        }
        EmailAddress other = (EmailAddress)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("address", (Object)this.getAddress());
        return tsh.omitNullValues().toString();
    }
}

