/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.PurchaseOrderLineTax;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="PURCHASE_PURCHASE_ORDER")
@Track(fields={@TrackField(name="purchaseOrderSeq"), @TrackField(name="supplierPartner"), @TrackField(name="statusSelect", on={TrackEvent.UPDATE})}, messages={@TrackMessage(message="Purchase Order created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Draft", condition="statusSelect == 1", tag="important"), @TrackMessage(message="Requested", condition="statusSelect == 2", tag="important"), @TrackMessage(message="Validated", condition="statusSelect == 3", tag="info"), @TrackMessage(message="Finished", condition="statusSelect == 4", tag="success"), @TrackMessage(message="Canceled", condition="statusSelect == 5", tag="warning")})
public class PurchaseOrder
extends AuditableModel {
    private Integer importId = 0;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Index(name="PURCHASE_PURCHASE_ORDER_FULL_NAME_IDX")
    private String fullName;
    @HashKey
    @Widget(title="Ref.", readonly=true)
    @Column(unique=true)
    private String purchaseOrderSeq;
    @Widget(title="Company")
    @NotNull
    @Index(name="PURCHASE_PURCHASE_ORDER_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Supplier")
    @NotNull
    @Index(name="PURCHASE_PURCHASE_ORDER_SUPPLIER_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierPartner;
    @Widget(title="Contact")
    @Index(name="PURCHASE_PURCHASE_ORDER_CONTACT_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Price list")
    @Index(name="PURCHASE_PURCHASE_ORDER_PRICE_LIST_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Buyer")
    @Index(name="PURCHASE_PURCHASE_ORDER_BUYER_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User buyerUser;
    @Widget(title="Currency")
    @NotNull
    @Index(name="PURCHASE_PURCHASE_ORDER_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Delivery Date")
    private LocalDate deliveryDate;
    @Widget(title="Order Date")
    private LocalDate orderDate;
    @Widget(title="Products list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PurchaseOrderLine> purchaseOrderLineList;
    @Widget(title="Status", readonly=true, selection="purchase.purchase.order.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Supplier ref.")
    private String externalReference;
    @Widget(title="Internal Ref.", help="true")
    private String internalReference;
    @Widget(title="Receipt State", readonly=true, selection="purchase.order.receipt.state")
    private Integer receiptState = 1;
    @Widget(title="Tax Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PurchaseOrderLineTax> purchaseOrderLineTaxList;
    @Widget(title="Validated by", readonly=true)
    @Index(name="PURCHASE_PURCHASE_ORDER_VALIDATED_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedByUser;
    @Widget(title="Validation date", readonly=true)
    private LocalDate validationDate;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total Tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Notes", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String notes;
    @Widget(title="Version Number", readonly=true)
    private Integer versionNumber = 1;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Company bank")
    @Index(name="PURCHASE_PURCHASE_ORDER_COMPANY_BANK_DETAILS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Widget(title="Display price on requested purchase printing")
    private Boolean priceDisplay = Boolean.FALSE;
    @Widget(title="Price request")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String priceRequest;
    @Widget(title="Invoice", readonly=true)
    @Index(name="PURCHASE_PURCHASE_ORDER_INVOICE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Payment mode")
    @Index(name="PURCHASE_PURCHASE_ORDER_PAYMENT_MODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @Index(name="PURCHASE_PURCHASE_ORDER_PAYMENT_CONDITION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Amount invoiced W.T.", readonly=true)
    private BigDecimal amountInvoiced = BigDecimal.ZERO;
    @Widget(title="Location")
    @Index(name="PURCHASE_PURCHASE_ORDER_LOCATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Location location;
    @Widget(title="Timetable")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Timetable> timetableList;
    @Widget(title="Expected realisation date")
    private LocalDate expectedRealisationDate;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_ORDER_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_ORDER_SEQ", sequenceName="PURCHASE_PURCHASE_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Initial purchase order")
    @Index(name="PURCHASE_PURCHASE_ORDER_PARENT_PURCHASE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder parentPurchaseOrder;
    @Widget(title="Purchase order?")
    private Boolean isPurchaseParent = Boolean.FALSE;

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        if (this.purchaseOrderSeq == null && this.supplierPartner == null) {
            return " ";
        }
        return this.purchaseOrderSeq + "-" + this.supplierPartner.getName();
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPurchaseOrderSeq() {
        return this.purchaseOrderSeq;
    }

    public void setPurchaseOrderSeq(String purchaseOrderSeq) {
        this.purchaseOrderSeq = purchaseOrderSeq;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getSupplierPartner() {
        return this.supplierPartner;
    }

    public void setSupplierPartner(Partner supplierPartner) {
        this.supplierPartner = supplierPartner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public User getBuyerUser() {
        return this.buyerUser;
    }

    public void setBuyerUser(User buyerUser) {
        this.buyerUser = buyerUser;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public List<PurchaseOrderLine> getPurchaseOrderLineList() {
        return this.purchaseOrderLineList;
    }

    public void setPurchaseOrderLineList(List<PurchaseOrderLine> purchaseOrderLineList) {
        this.purchaseOrderLineList = purchaseOrderLineList;
    }

    public void addPurchaseOrderLineListItem(PurchaseOrderLine item) {
        if (this.purchaseOrderLineList == null) {
            this.purchaseOrderLineList = new ArrayList<PurchaseOrderLine>();
        }
        this.purchaseOrderLineList.add(item);
        item.setPurchaseOrder(this);
    }

    public void removePurchaseOrderLineListItem(PurchaseOrderLine item) {
        if (this.purchaseOrderLineList == null) {
            return;
        }
        this.purchaseOrderLineList.remove((Object)item);
    }

    public void clearPurchaseOrderLineList() {
        if (this.purchaseOrderLineList != null) {
            this.purchaseOrderLineList.clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public String getInternalReference() {
        return this.internalReference;
    }

    public void setInternalReference(String internalReference) {
        this.internalReference = internalReference;
    }

    public Integer getReceiptState() {
        return this.receiptState == null ? 0 : this.receiptState;
    }

    public void setReceiptState(Integer receiptState) {
        this.receiptState = receiptState;
    }

    public List<PurchaseOrderLineTax> getPurchaseOrderLineTaxList() {
        return this.purchaseOrderLineTaxList;
    }

    public void setPurchaseOrderLineTaxList(List<PurchaseOrderLineTax> purchaseOrderLineTaxList) {
        this.purchaseOrderLineTaxList = purchaseOrderLineTaxList;
    }

    public void addPurchaseOrderLineTaxListItem(PurchaseOrderLineTax item) {
        if (this.purchaseOrderLineTaxList == null) {
            this.purchaseOrderLineTaxList = new ArrayList<PurchaseOrderLineTax>();
        }
        this.purchaseOrderLineTaxList.add(item);
        item.setPurchaseOrder(this);
    }

    public void removePurchaseOrderLineTaxListItem(PurchaseOrderLineTax item) {
        if (this.purchaseOrderLineTaxList == null) {
            return;
        }
        this.purchaseOrderLineTaxList.remove(item);
    }

    public void clearPurchaseOrderLineTaxList() {
        if (this.purchaseOrderLineTaxList != null) {
            this.purchaseOrderLineTaxList.clear();
        }
    }

    public User getValidatedByUser() {
        return this.validatedByUser;
    }

    public void setValidatedByUser(User validatedByUser) {
        this.validatedByUser = validatedByUser;
    }

    public LocalDate getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(LocalDate validationDate) {
        this.validationDate = validationDate;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Integer getVersionNumber() {
        return this.versionNumber == null ? 0 : this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public Boolean getPriceDisplay() {
        return this.priceDisplay == null ? Boolean.FALSE : this.priceDisplay;
    }

    public void setPriceDisplay(Boolean priceDisplay) {
        this.priceDisplay = priceDisplay;
    }

    public String getPriceRequest() {
        return this.priceRequest;
    }

    public void setPriceRequest(String priceRequest) {
        this.priceRequest = priceRequest;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public BigDecimal getAmountInvoiced() {
        return this.amountInvoiced == null ? BigDecimal.ZERO : this.amountInvoiced;
    }

    public void setAmountInvoiced(BigDecimal amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public List<Timetable> getTimetableList() {
        return this.timetableList;
    }

    public void setTimetableList(List<Timetable> timetableList) {
        this.timetableList = timetableList;
    }

    public void addTimetableListItem(Timetable item) {
        if (this.timetableList == null) {
            this.timetableList = new ArrayList<Timetable>();
        }
        this.timetableList.add(item);
        item.setPurchaseOrder(this);
    }

    public void removeTimetableListItem(Timetable item) {
        if (this.timetableList == null) {
            return;
        }
        this.timetableList.remove(item);
    }

    public void clearTimetableList() {
        if (this.timetableList != null) {
            this.timetableList.clear();
        }
    }

    public LocalDate getExpectedRealisationDate() {
        return this.expectedRealisationDate;
    }

    public void setExpectedRealisationDate(LocalDate expectedRealisationDate) {
        this.expectedRealisationDate = expectedRealisationDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PurchaseOrder getParentPurchaseOrder() {
        return this.parentPurchaseOrder;
    }

    public void setParentPurchaseOrder(PurchaseOrder parentPurchaseOrder) {
        this.parentPurchaseOrder = parentPurchaseOrder;
    }

    public Boolean getIsPurchaseParent() {
        return this.isPurchaseParent == null ? Boolean.FALSE : this.isPurchaseParent;
    }

    public void setIsPurchaseParent(Boolean isPurchaseParent) {
        this.isPurchaseParent = isPurchaseParent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseOrder)) {
            return false;
        }
        PurchaseOrder other = (PurchaseOrder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getPurchaseOrderSeq(), other.getPurchaseOrderSeq());
    }

    public int hashCode() {
        return Objects.hash(-539706707, this.getPurchaseOrderSeq());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("purchaseOrderSeq", (Object)this.getPurchaseOrderSeq());
        tsh.add("deliveryDate", (Object)this.getDeliveryDate());
        tsh.add("orderDate", (Object)this.getOrderDate());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        tsh.add("externalReference", (Object)this.getExternalReference());
        tsh.add("internalReference", (Object)this.getInternalReference());
        tsh.add("receiptState", (Object)this.getReceiptState());
        tsh.add("validationDate", (Object)this.getValidationDate());
        tsh.add("exTaxTotal", (Object)this.getExTaxTotal());
        tsh.add("taxTotal", (Object)this.getTaxTotal());
        return tsh.omitNullValues().toString();
    }
}

