/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;

@Entity
@Table(name="SALE_ADVANCE_PAYMENT")
public class AdvancePayment
extends AuditableModel {
    @Widget(title="Amount remaining to use", readonly=true)
    private BigDecimal amountRemainingToUse = BigDecimal.ZERO;
    @Widget(title="Payment mode")
    @Index(name="SALE_ADVANCE_PAYMENT_PAYMENT_MODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Move", readonly=true)
    @Index(name="SALE_ADVANCE_PAYMENT_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_ADVANCE_PAYMENT_SEQ")
    @SequenceGenerator(name="SALE_ADVANCE_PAYMENT_SEQ", sequenceName="SALE_ADVANCE_PAYMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Amount")
    @NotNull
    private BigDecimal amount = new BigDecimal("0");
    @Widget(title="Date")
    @NotNull
    private LocalDate advancePaymentDate;
    @Index(name="SALE_ADVANCE_PAYMENT_SALE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Currency")
    @NotNull
    @Index(name="SALE_ADVANCE_PAYMENT_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Status", selection="advance.payment.status.select")
    private Integer statusSelect = 0;

    public BigDecimal getAmountRemainingToUse() {
        return this.amountRemainingToUse == null ? BigDecimal.ZERO : this.amountRemainingToUse;
    }

    public void setAmountRemainingToUse(BigDecimal amountRemainingToUse) {
        this.amountRemainingToUse = amountRemainingToUse;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getAdvancePaymentDate() {
        return this.advancePaymentDate;
    }

    public void setAdvancePaymentDate(LocalDate advancePaymentDate) {
        this.advancePaymentDate = advancePaymentDate;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvancePayment)) {
            return false;
        }
        AdvancePayment other = (AdvancePayment)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("amountRemainingToUse", (Object)this.getAmountRemainingToUse());
        tsh.add("amount", (Object)this.getAmount());
        tsh.add("advancePaymentDate", (Object)this.getAdvancePaymentDate());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        return tsh.omitNullValues().toString();
    }
}

