/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Duration;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.SchedulerInstance;
import com.axelor.apps.base.db.Team;
import com.axelor.apps.sale.db.AdvancePayment;
import com.axelor.apps.sale.db.CancelReason;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.SaleOrderLineTax;
import com.axelor.apps.sale.db.SaleOrderScheduleLine;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;

@Entity
@Table(name="SALE_SALE_ORDER", uniqueConstraints={@UniqueConstraint(columnNames={"saleOrderSeq", "company"})})
@Track(fields={@TrackField(name="saleOrderSeq"), @TrackField(name="clientPartner"), @TrackField(name="statusSelect"), @TrackField(name="creationDate", on={TrackEvent.CREATE}), @TrackField(name="confirmationDate", on={TrackEvent.UPDATE}), @TrackField(name="inTaxTotal")}, messages={@TrackMessage(message="Sale Order created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Draft", condition="statusSelect == 1", tag="important"), @TrackMessage(message="Finalize", condition="statusSelect == 2", tag="info"), @TrackMessage(message="Order confirmed", condition="statusSelect == 3", tag="success"), @TrackMessage(message="Finished", condition="statusSelect == 4", tag="success"), @TrackMessage(message="Canceled", condition="statusSelect == 5", tag="warning")})
public class SaleOrder
extends AuditableModel {
    @Widget(title="Location")
    @Index(name="SALE_SALE_ORDER_LOCATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Location location;
    @Widget(title="Date of shipment")
    private LocalDate shipmentDate;
    @Widget(title="Amount invoiced W.T.", readonly=true)
    private BigDecimal amountInvoiced = BigDecimal.ZERO;
    @Widget(title="Subscription")
    private Boolean subscription = Boolean.FALSE;
    @Widget(title="Schedule line list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleOrderScheduleLine> saleOrderScheduleLineList;
    @Widget(selection="product.periodicity.subscription.select")
    private Integer periodicity = 0;
    @Widget(title="Date From")
    private LocalDate fromSubDate;
    @Widget(title="Number of Periods")
    private Integer periodNumber = 0;
    @Widget(title="Date To")
    private LocalDate toSubDate;
    @Widget(title="Invoicing Type", selection="supplychain.subscription.invoicing.type.select")
    private Integer subscripInvTypeSelect = 0;
    @Widget(title="Timetable")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Timetable> timetableList;
    @Widget(title="Expected realisation date")
    private LocalDate expectedRealisationDate;
    @Widget(title="Company")
    @NotNull
    @Index(name="SALE_SALE_ORDER_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    private Integer importId = 0;
    @NameColumn
    @Index(name="SALE_SALE_ORDER_FULL_NAME_IDX")
    private String fullName;
    @Widget(title="Internal Number", readonly=true)
    private String saleOrderSeq;
    @Widget(title="Currency", massUpdate=true)
    @NotNull
    @Index(name="SALE_SALE_ORDER_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Customer reference")
    private String externalReference;
    @Widget(title="Creation date", readonly=true)
    @NotNull
    private LocalDate creationDate;
    @Widget(title="Confirmation date", readonly=true)
    private LocalDate confirmationDate;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Bloqued")
    private Boolean bloqued = Boolean.FALSE;
    @Widget(title="Manual Unblock")
    private Boolean manualUnblock = Boolean.FALSE;
    @Widget(title="Customer", massUpdate=true)
    @NotNull
    @Index(name="SALE_SALE_ORDER_CLIENT_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Customer contact")
    @Index(name="SALE_SALE_ORDER_CONTACT_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Main/Invoicing address")
    @Index(name="SALE_SALE_ORDER_MAIN_INVOICING_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address mainInvoicingAddress;
    @Widget(title="Price list")
    @Index(name="SALE_SALE_ORDER_PRICE_LIST_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Delivery address")
    @Index(name="SALE_SALE_ORDER_DELIVERY_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address deliveryAddress;
    @Widget(title="Print subtotal per line")
    private Boolean isToPrintLineSubTotal = Boolean.FALSE;
    @Widget(title="Default value for sublines")
    private Boolean hasSubLineDefaultValue = Boolean.FALSE;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Validity duration")
    @Index(name="SALE_SALE_ORDER_DURATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration duration;
    @Widget(title="End of validity")
    private LocalDate endOfValidityDate;
    @Widget(title="Sale order lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleOrderLine> saleOrderLineList;
    @Widget(title="Tax Lines", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleOrderLineTax> saleOrderLineTaxList;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total cost in company currency", hidden=true)
    private BigDecimal companyCostTotal = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="sale.order.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Salesman", massUpdate=true)
    @Index(name="SALE_SALE_ORDER_SALEMAN_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User salemanUser;
    @Widget(title="Team", massUpdate=true)
    @Index(name="SALE_SALE_ORDER_TEAM_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Order Date")
    private LocalDate orderDate;
    @Widget(title="Order Number")
    private String orderNumber;
    @Widget(title="Scheduler instance")
    @Index(name="SALE_SALE_ORDER_SCHEDULER_INSTANCE_IDX")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SchedulerInstance schedulerInstance;
    @Widget(title="Subscription start date")
    private LocalDate subscriptionStartDate;
    @Widget(title="Invoiced first date")
    private LocalDate invoicedFirstDate;
    @Widget(title="Next invoiced period start date", readonly=true)
    private LocalDate nextInvPeriodStartDate;
    @Widget(title="Subscription end date")
    private LocalDate subscriptionEndDate;
    @Widget(title="Confirmed by", readonly=true)
    @Index(name="SALE_SALE_ORDER_CONFIRMED_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User confirmedByUser;
    @Widget(title="Template", hidden=true)
    private Boolean template = Boolean.FALSE;
    @Widget(title="Version Number", readonly=true)
    private Integer versionNumber = 1;
    @Widget(title="Cancel reason")
    @Index(name="SALE_SALE_ORDER_CANCEL_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CancelReason cancelReason;
    @Widget(title="Delivery State", readonly=true, selection="sale.order.delivery.state")
    private Integer deliveryState = 1;
    @Widget(title="Template created by", readonly=true)
    @Index(name="SALE_SALE_ORDER_TEMPLATE_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User templateUser;
    @Widget(title="Hide Discount on prints?")
    private Boolean hideDiscount = Boolean.FALSE;
    @Widget(title="Delivery date")
    private LocalDate deliveryDate;
    @Widget(title="Delivery conditions", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String deliveryCondition;
    @Widget(title="Advance Payments")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AdvancePayment> advancePaymentList;
    @Widget(title="Company bank")
    @Index(name="SALE_SALE_ORDER_COMPANY_BANK_DETAILS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_ORDER_SEQ")
    @SequenceGenerator(name="SALE_SALE_ORDER_SEQ", sequenceName="SALE_SALE_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Payment mode")
    @Index(name="SALE_SALE_ORDER_PAYMENT_MODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @Index(name="SALE_SALE_ORDER_PAYMENT_CONDITION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public LocalDate getShipmentDate() {
        return this.shipmentDate;
    }

    public void setShipmentDate(LocalDate shipmentDate) {
        this.shipmentDate = shipmentDate;
    }

    public BigDecimal getAmountInvoiced() {
        return this.amountInvoiced == null ? BigDecimal.ZERO : this.amountInvoiced;
    }

    public void setAmountInvoiced(BigDecimal amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
    }

    public Boolean getSubscription() {
        return this.subscription == null ? Boolean.FALSE : this.subscription;
    }

    public void setSubscription(Boolean subscription) {
        this.subscription = subscription;
    }

    public List<SaleOrderScheduleLine> getSaleOrderScheduleLineList() {
        return this.saleOrderScheduleLineList;
    }

    public void setSaleOrderScheduleLineList(List<SaleOrderScheduleLine> saleOrderScheduleLineList) {
        this.saleOrderScheduleLineList = saleOrderScheduleLineList;
    }

    public void addSaleOrderScheduleLineListItem(SaleOrderScheduleLine item) {
        if (this.saleOrderScheduleLineList == null) {
            this.saleOrderScheduleLineList = new ArrayList<SaleOrderScheduleLine>();
        }
        this.saleOrderScheduleLineList.add(item);
        item.setSaleOrder(this);
    }

    public void removeSaleOrderScheduleLineListItem(SaleOrderScheduleLine item) {
        if (this.saleOrderScheduleLineList == null) {
            return;
        }
        this.saleOrderScheduleLineList.remove(item);
    }

    public void clearSaleOrderScheduleLineList() {
        if (this.saleOrderScheduleLineList != null) {
            this.saleOrderScheduleLineList.clear();
        }
    }

    public Integer getPeriodicity() {
        return this.periodicity == null ? 0 : this.periodicity;
    }

    public void setPeriodicity(Integer periodicity) {
        this.periodicity = periodicity;
    }

    public LocalDate getFromSubDate() {
        return this.fromSubDate;
    }

    public void setFromSubDate(LocalDate fromSubDate) {
        this.fromSubDate = fromSubDate;
    }

    public Integer getPeriodNumber() {
        return this.periodNumber == null ? 0 : this.periodNumber;
    }

    public void setPeriodNumber(Integer periodNumber) {
        this.periodNumber = periodNumber;
    }

    public LocalDate getToSubDate() {
        return this.toSubDate;
    }

    public void setToSubDate(LocalDate toSubDate) {
        this.toSubDate = toSubDate;
    }

    public Integer getSubscripInvTypeSelect() {
        return this.subscripInvTypeSelect == null ? 0 : this.subscripInvTypeSelect;
    }

    public void setSubscripInvTypeSelect(Integer subscripInvTypeSelect) {
        this.subscripInvTypeSelect = subscripInvTypeSelect;
    }

    public List<Timetable> getTimetableList() {
        return this.timetableList;
    }

    public void setTimetableList(List<Timetable> timetableList) {
        this.timetableList = timetableList;
    }

    public void addTimetableListItem(Timetable item) {
        if (this.timetableList == null) {
            this.timetableList = new ArrayList<Timetable>();
        }
        this.timetableList.add(item);
        item.setSaleOrder(this);
    }

    public void removeTimetableListItem(Timetable item) {
        if (this.timetableList == null) {
            return;
        }
        this.timetableList.remove(item);
    }

    public void clearTimetableList() {
        if (this.timetableList != null) {
            this.timetableList.clear();
        }
    }

    public LocalDate getExpectedRealisationDate() {
        return this.expectedRealisationDate;
    }

    public void setExpectedRealisationDate(LocalDate expectedRealisationDate) {
        this.expectedRealisationDate = expectedRealisationDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getSaleOrderSeq() {
        return this.saleOrderSeq;
    }

    public void setSaleOrderSeq(String saleOrderSeq) {
        this.saleOrderSeq = saleOrderSeq;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDate getConfirmationDate() {
        return this.confirmationDate;
    }

    public void setConfirmationDate(LocalDate confirmationDate) {
        this.confirmationDate = confirmationDate;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.batchSet == null) {
            this.batchSet = new HashSet<Batch>();
        }
        this.batchSet.add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.batchSet == null) {
            return;
        }
        this.batchSet.remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.batchSet != null) {
            this.batchSet.clear();
        }
    }

    public Boolean getBloqued() {
        return this.bloqued == null ? Boolean.FALSE : this.bloqued;
    }

    public void setBloqued(Boolean bloqued) {
        this.bloqued = bloqued;
    }

    public Boolean getManualUnblock() {
        return this.manualUnblock == null ? Boolean.FALSE : this.manualUnblock;
    }

    public void setManualUnblock(Boolean manualUnblock) {
        this.manualUnblock = manualUnblock;
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public Address getMainInvoicingAddress() {
        return this.mainInvoicingAddress;
    }

    public void setMainInvoicingAddress(Address mainInvoicingAddress) {
        this.mainInvoicingAddress = mainInvoicingAddress;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public Boolean getIsToPrintLineSubTotal() {
        return this.isToPrintLineSubTotal == null ? Boolean.FALSE : this.isToPrintLineSubTotal;
    }

    public void setIsToPrintLineSubTotal(Boolean isToPrintLineSubTotal) {
        this.isToPrintLineSubTotal = isToPrintLineSubTotal;
    }

    public Boolean getHasSubLineDefaultValue() {
        return this.hasSubLineDefaultValue == null ? Boolean.FALSE : this.hasSubLineDefaultValue;
    }

    public void setHasSubLineDefaultValue(Boolean hasSubLineDefaultValue) {
        this.hasSubLineDefaultValue = hasSubLineDefaultValue;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public LocalDate getEndOfValidityDate() {
        return this.endOfValidityDate;
    }

    public void setEndOfValidityDate(LocalDate endOfValidityDate) {
        this.endOfValidityDate = endOfValidityDate;
    }

    public List<SaleOrderLine> getSaleOrderLineList() {
        return this.saleOrderLineList;
    }

    public void setSaleOrderLineList(List<SaleOrderLine> saleOrderLineList) {
        this.saleOrderLineList = saleOrderLineList;
    }

    public void addSaleOrderLineListItem(SaleOrderLine item) {
        if (this.saleOrderLineList == null) {
            this.saleOrderLineList = new ArrayList<SaleOrderLine>();
        }
        this.saleOrderLineList.add(item);
        item.setSaleOrder(this);
    }

    public void removeSaleOrderLineListItem(SaleOrderLine item) {
        if (this.saleOrderLineList == null) {
            return;
        }
        this.saleOrderLineList.remove((Object)item);
    }

    public void clearSaleOrderLineList() {
        if (this.saleOrderLineList != null) {
            this.saleOrderLineList.clear();
        }
    }

    public List<SaleOrderLineTax> getSaleOrderLineTaxList() {
        return this.saleOrderLineTaxList;
    }

    public void setSaleOrderLineTaxList(List<SaleOrderLineTax> saleOrderLineTaxList) {
        this.saleOrderLineTaxList = saleOrderLineTaxList;
    }

    public void addSaleOrderLineTaxListItem(SaleOrderLineTax item) {
        if (this.saleOrderLineTaxList == null) {
            this.saleOrderLineTaxList = new ArrayList<SaleOrderLineTax>();
        }
        this.saleOrderLineTaxList.add(item);
        item.setSaleOrder(this);
    }

    public void removeSaleOrderLineTaxListItem(SaleOrderLineTax item) {
        if (this.saleOrderLineTaxList == null) {
            return;
        }
        this.saleOrderLineTaxList.remove(item);
    }

    public void clearSaleOrderLineTaxList() {
        if (this.saleOrderLineTaxList != null) {
            this.saleOrderLineTaxList.clear();
        }
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyCostTotal() {
        return this.companyCostTotal == null ? BigDecimal.ZERO : this.companyCostTotal;
    }

    public void setCompanyCostTotal(BigDecimal companyCostTotal) {
        this.companyCostTotal = companyCostTotal;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public User getSalemanUser() {
        return this.salemanUser;
    }

    public void setSalemanUser(User salemanUser) {
        this.salemanUser = salemanUser;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public SchedulerInstance getSchedulerInstance() {
        return this.schedulerInstance;
    }

    public void setSchedulerInstance(SchedulerInstance schedulerInstance) {
        this.schedulerInstance = schedulerInstance;
    }

    public LocalDate getSubscriptionStartDate() {
        return this.subscriptionStartDate;
    }

    public void setSubscriptionStartDate(LocalDate subscriptionStartDate) {
        this.subscriptionStartDate = subscriptionStartDate;
    }

    public LocalDate getInvoicedFirstDate() {
        return this.invoicedFirstDate;
    }

    public void setInvoicedFirstDate(LocalDate invoicedFirstDate) {
        this.invoicedFirstDate = invoicedFirstDate;
    }

    public LocalDate getNextInvPeriodStartDate() {
        return this.nextInvPeriodStartDate;
    }

    public void setNextInvPeriodStartDate(LocalDate nextInvPeriodStartDate) {
        this.nextInvPeriodStartDate = nextInvPeriodStartDate;
    }

    public LocalDate getSubscriptionEndDate() {
        return this.subscriptionEndDate;
    }

    public void setSubscriptionEndDate(LocalDate subscriptionEndDate) {
        this.subscriptionEndDate = subscriptionEndDate;
    }

    public User getConfirmedByUser() {
        return this.confirmedByUser;
    }

    public void setConfirmedByUser(User confirmedByUser) {
        this.confirmedByUser = confirmedByUser;
    }

    public Boolean getTemplate() {
        return this.template == null ? Boolean.FALSE : this.template;
    }

    public void setTemplate(Boolean template) {
        this.template = template;
    }

    public Integer getVersionNumber() {
        return this.versionNumber == null ? 0 : this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(CancelReason cancelReason) {
        this.cancelReason = cancelReason;
    }

    public Integer getDeliveryState() {
        return this.deliveryState == null ? 0 : this.deliveryState;
    }

    public void setDeliveryState(Integer deliveryState) {
        this.deliveryState = deliveryState;
    }

    public User getTemplateUser() {
        return this.templateUser;
    }

    public void setTemplateUser(User templateUser) {
        this.templateUser = templateUser;
    }

    public Boolean getHideDiscount() {
        return this.hideDiscount == null ? Boolean.FALSE : this.hideDiscount;
    }

    public void setHideDiscount(Boolean hideDiscount) {
        this.hideDiscount = hideDiscount;
    }

    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getDeliveryCondition() {
        return this.deliveryCondition;
    }

    public void setDeliveryCondition(String deliveryCondition) {
        this.deliveryCondition = deliveryCondition;
    }

    public List<AdvancePayment> getAdvancePaymentList() {
        return this.advancePaymentList;
    }

    public void setAdvancePaymentList(List<AdvancePayment> advancePaymentList) {
        this.advancePaymentList = advancePaymentList;
    }

    public void addAdvancePaymentListItem(AdvancePayment item) {
        if (this.advancePaymentList == null) {
            this.advancePaymentList = new ArrayList<AdvancePayment>();
        }
        this.advancePaymentList.add(item);
        item.setSaleOrder(this);
    }

    public void removeAdvancePaymentListItem(AdvancePayment item) {
        if (this.advancePaymentList == null) {
            return;
        }
        this.advancePaymentList.remove((Object)item);
    }

    public void clearAdvancePaymentList() {
        if (this.advancePaymentList != null) {
            this.advancePaymentList.clear();
        }
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleOrder)) {
            return false;
        }
        SaleOrder other = (SaleOrder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("shipmentDate", (Object)this.getShipmentDate());
        tsh.add("amountInvoiced", (Object)this.getAmountInvoiced());
        tsh.add("subscription", (Object)this.getSubscription());
        tsh.add("periodicity", (Object)this.getPeriodicity());
        tsh.add("fromSubDate", (Object)this.getFromSubDate());
        tsh.add("periodNumber", (Object)this.getPeriodNumber());
        tsh.add("toSubDate", (Object)this.getToSubDate());
        tsh.add("subscripInvTypeSelect", (Object)this.getSubscripInvTypeSelect());
        tsh.add("expectedRealisationDate", (Object)this.getExpectedRealisationDate());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("fullName", (Object)this.getFullName());
        return tsh.omitNullValues().toString();
    }
}

