/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;

@Entity
@Table(name="STOCK_STOCK_MOVE")
public class StockMove
extends AuditableModel {
    private Integer importId = 0;
    @HashKey
    @Widget(title="Ref.", readonly=true)
    @NameColumn
    @Column(unique=true)
    private String stockMoveSeq;
    @Widget(title="Name")
    @Index(name="STOCK_STOCK_MOVE_NAME_IDX")
    private String name;
    @Widget(title="From location")
    @NotNull
    @Index(name="STOCK_STOCK_MOVE_FROM_LOCATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Location fromLocation;
    @Widget(title="To location")
    @NotNull
    @Index(name="STOCK_STOCK_MOVE_TO_LOCATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Location toLocation;
    @Widget(title="Estimated date")
    private LocalDate estimatedDate;
    @Widget(title="Move date", readonly=true)
    private LocalDate realDate;
    @Widget(title="Status", readonly=true, selection="stock.move.status.select")
    @NotNull
    private Integer statusSelect = 0;
    @Widget(title="Type Status", selection="stock.move.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="From address")
    @Index(name="STOCK_STOCK_MOVE_FROM_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address fromAddress;
    @Widget(title="To address")
    @Index(name="STOCK_STOCK_MOVE_TO_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address toAddress;
    @Widget(title="Company")
    @NotNull
    @Index(name="STOCK_STOCK_MOVE_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Partner")
    @Index(name="STOCK_STOCK_MOVE_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Stock move content")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="stockMove", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockMoveLine> stockMoveLineList;
    @Widget(title="Return surplus")
    private Boolean isWithReturnSurplus = Boolean.FALSE;
    @Widget(title="Manage BackOrder")
    private Boolean isWithBackorder = Boolean.TRUE;
    @Widget(title="Tracking Number")
    private String trackingNumber;
    @Widget(title="Number Of Packages")
    private Integer numOfPackages = 0;
    @Widget(title="Number Of Palettes")
    private Integer numOfPalettes = 0;
    @Widget(title="Gross Weight")
    private BigDecimal grossWeight = BigDecimal.ZERO;
    @Widget(title="Total W.T.")
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_MOVE_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_MOVE_SEQ", sequenceName="STOCK_STOCK_MOVE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sale order")
    @Index(name="STOCK_STOCK_MOVE_SALE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Purchase order")
    @Index(name="STOCK_STOCK_MOVE_PURCHASE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder purchaseOrder;
    @Widget(title="Invoice")
    @Index(name="STOCK_STOCK_MOVE_INVOICE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;

    public StockMove() {
    }

    public StockMove(String name) {
        this.name = name;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getStockMoveSeq() {
        return this.stockMoveSeq;
    }

    public void setStockMoveSeq(String stockMoveSeq) {
        this.stockMoveSeq = stockMoveSeq;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getFromLocation() {
        return this.fromLocation;
    }

    public void setFromLocation(Location fromLocation) {
        this.fromLocation = fromLocation;
    }

    public Location getToLocation() {
        return this.toLocation;
    }

    public void setToLocation(Location toLocation) {
        this.toLocation = toLocation;
    }

    public LocalDate getEstimatedDate() {
        return this.estimatedDate;
    }

    public void setEstimatedDate(LocalDate estimatedDate) {
        this.estimatedDate = estimatedDate;
    }

    public LocalDate getRealDate() {
        return this.realDate;
    }

    public void setRealDate(LocalDate realDate) {
        this.realDate = realDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public List<StockMoveLine> getStockMoveLineList() {
        return this.stockMoveLineList;
    }

    public void setStockMoveLineList(List<StockMoveLine> stockMoveLineList) {
        this.stockMoveLineList = stockMoveLineList;
    }

    public void addStockMoveLineListItem(StockMoveLine item) {
        if (this.stockMoveLineList == null) {
            this.stockMoveLineList = new ArrayList<StockMoveLine>();
        }
        this.stockMoveLineList.add(item);
        item.setStockMove(this);
    }

    public void removeStockMoveLineListItem(StockMoveLine item) {
        if (this.stockMoveLineList == null) {
            return;
        }
        this.stockMoveLineList.remove((Object)item);
    }

    public void clearStockMoveLineList() {
        if (this.stockMoveLineList != null) {
            this.stockMoveLineList.clear();
        }
    }

    public Boolean getIsWithReturnSurplus() {
        return this.isWithReturnSurplus == null ? Boolean.FALSE : this.isWithReturnSurplus;
    }

    public void setIsWithReturnSurplus(Boolean isWithReturnSurplus) {
        this.isWithReturnSurplus = isWithReturnSurplus;
    }

    public Boolean getIsWithBackorder() {
        return this.isWithBackorder == null ? Boolean.FALSE : this.isWithBackorder;
    }

    public void setIsWithBackorder(Boolean isWithBackorder) {
        this.isWithBackorder = isWithBackorder;
    }

    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Integer getNumOfPackages() {
        return this.numOfPackages == null ? 0 : this.numOfPackages;
    }

    public void setNumOfPackages(Integer numOfPackages) {
        this.numOfPackages = numOfPackages;
    }

    public Integer getNumOfPalettes() {
        return this.numOfPalettes == null ? 0 : this.numOfPalettes;
    }

    public void setNumOfPalettes(Integer numOfPalettes) {
        this.numOfPalettes = numOfPalettes;
    }

    public BigDecimal getGrossWeight() {
        return this.grossWeight == null ? BigDecimal.ZERO : this.grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public PurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockMove)) {
            return false;
        }
        StockMove other = (StockMove)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getStockMoveSeq(), other.getStockMoveSeq());
    }

    public int hashCode() {
        return Objects.hash(-1023128601, this.getStockMoveSeq());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("stockMoveSeq", (Object)this.getStockMoveSeq());
        tsh.add("name", (Object)this.getName());
        tsh.add("estimatedDate", (Object)this.getEstimatedDate());
        tsh.add("realDate", (Object)this.getRealDate());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        tsh.add("typeSelect", (Object)this.getTypeSelect());
        tsh.add("isWithReturnSurplus", (Object)this.getIsWithReturnSurplus());
        tsh.add("isWithBackorder", (Object)this.getIsWithBackorder());
        tsh.add("trackingNumber", (Object)this.getTrackingNumber());
        tsh.add("numOfPackages", (Object)this.getNumOfPackages());
        return tsh.omitNullValues().toString();
    }
}

