/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderLineServiceImpl;
import com.axelor.apps.suppliermanagement.db.PurchaseOrderSupplierLine;
import com.axelor.apps.suppliermanagement.db.repo.PurchaseOrderSupplierLineRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class PurchaseOrderSupplierLineService {
    @Inject
    PurchaseOrderSupplierLineRepository poSupplierLineRepo;

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void accept(PurchaseOrderSupplierLine purchaseOrderSupplierLine) {
        PurchaseOrderLine purchaseOrderLine = purchaseOrderSupplierLine.getPurchaseOrderLine();
        purchaseOrderLine.setEstimatedDelivDate(purchaseOrderSupplierLine.getEstimatedDelivDate());
        purchaseOrderLine.setSupplierPartner(purchaseOrderSupplierLine.getSupplierPartner());
        purchaseOrderLine.setPrice(purchaseOrderSupplierLine.getPrice());
        purchaseOrderLine.setExTaxTotal(PurchaseOrderLineServiceImpl.computeAmount((BigDecimal)purchaseOrderLine.getQty(), (BigDecimal)purchaseOrderLine.getPrice()));
        purchaseOrderSupplierLine.setStateSelect(3);
        this.poSupplierLineRepo.save((Model)purchaseOrderSupplierLine);
    }

    public PurchaseOrderSupplierLine create(Partner supplierPartner, BigDecimal price) {
        return new PurchaseOrderSupplierLine(price, 1, supplierPartner);
    }
}

