/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.SupplierCatalog;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.suppliermanagement.service.PurchaseOrderSupplierLineService;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderSupplierService {
    private static final Logger LOG = LoggerFactory.getLogger(PurchaseOrderSupplierService.class);
    @Inject
    private PurchaseOrderSupplierLineService purchaseOrderSupplierLineService;
    @Inject
    private PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    @Inject
    private PurchaseOrderLineService purchaseOrderLineService;
    @Inject
    protected GeneralService generalService;
    @Inject
    protected PurchaseOrderRepository poRepo;
    private LocalDate today = ((GeneralService)Beans.get(GeneralService.class)).getTodayDate();
    protected User user = AuthUtils.getUser();

    @Inject
    public PurchaseOrderSupplierService() {
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generateAllSuppliersRequests(PurchaseOrder purchaseOrder) {
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            this.generateSuppliersRequests(purchaseOrderLine);
        }
        this.poRepo.save((Model)purchaseOrder);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generateSuppliersRequests(PurchaseOrderLine purchaseOrderLine) {
        Product product = purchaseOrderLine.getProduct();
        if (product != null && product.getSupplierCatalogList() != null) {
            for (SupplierCatalog supplierCatalog : product.getSupplierCatalogList()) {
                purchaseOrderLine.addPurchaseOrderSupplierLineListItem(this.purchaseOrderSupplierLineService.create(supplierCatalog.getSupplierPartner(), supplierCatalog.getPrice()));
            }
        }
        ((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).save((Model)purchaseOrderLine);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generateSuppliersPurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getPurchaseOrderLineList() == null) {
            return;
        }
        Map<Partner, List<PurchaseOrderLine>> purchaseOrderLinesBySupplierPartner = this.splitBySupplierPartner(purchaseOrder.getPurchaseOrderLineList());
        for (Partner supplierPartner : purchaseOrderLinesBySupplierPartner.keySet()) {
            this.createPurchaseOrder(supplierPartner, purchaseOrderLinesBySupplierPartner.get((Object)supplierPartner), purchaseOrder);
        }
        this.poRepo.save((Model)purchaseOrder);
    }

    public Map<Partner, List<PurchaseOrderLine>> splitBySupplierPartner(List<PurchaseOrderLine> purchaseOrderLineList) throws AxelorException {
        HashMap<Partner, List<PurchaseOrderLine>> purchaseOrderLinesBySupplierPartner = new HashMap<Partner, List<PurchaseOrderLine>>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            Partner supplierPartner = purchaseOrderLine.getSupplierPartner();
            if (supplierPartner == null) {
                throw new AxelorException(String.format(I18n.get((String)"Please, select a supplier for the line %s"), purchaseOrderLine.getProductName()), 4, new Object[0]);
            }
            if (!purchaseOrderLinesBySupplierPartner.containsKey((Object)supplierPartner)) {
                purchaseOrderLinesBySupplierPartner.put(supplierPartner, new ArrayList());
            }
            ((List)purchaseOrderLinesBySupplierPartner.get((Object)supplierPartner)).add(purchaseOrderLine);
        }
        return purchaseOrderLinesBySupplierPartner;
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void createPurchaseOrder(Partner supplierPartner, List<PurchaseOrderLine> purchaseOrderLineList, PurchaseOrder parentPurchaseOrder) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une commande fournisseur depuis le devis fournisseur : {} et le fournisseur : {}", new Object[]{parentPurchaseOrder.getPurchaseOrderSeq(), supplierPartner.getFullName()});
        PurchaseOrder purchaseOrder = this.purchaseOrderServiceSupplychainImpl.createPurchaseOrder(this.user, parentPurchaseOrder.getCompany(), null, supplierPartner.getCurrency(), null, parentPurchaseOrder.getPurchaseOrderSeq(), parentPurchaseOrder.getExternalReference(), this.purchaseOrderServiceSupplychainImpl.getLocation(parentPurchaseOrder.getCompany()), this.today, supplierPartner.getPurchasePriceList(), supplierPartner);
        purchaseOrder.setParentPurchaseOrder(parentPurchaseOrder);
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            purchaseOrder.addPurchaseOrderLineListItem(this.createPurchaseOrderLine(purchaseOrder, purchaseOrderLine));
        }
        this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
        purchaseOrder.setStatusSelect(2);
        purchaseOrder.setReceiptState(1);
        this.poRepo.save((Model)purchaseOrder);
    }

    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une ligne de commande fournisseur pour le produit : {}", new Object[]{purchaseOrderLine.getProductName()});
        return this.purchaseOrderLineService.createPurchaseOrderLine(purchaseOrder, purchaseOrderLine.getProduct(), purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit());
    }
}

