/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.web;

import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.suppliermanagement.service.PurchaseOrderSupplierService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;

public class PurchaseOrderController {
    @Inject
    private PurchaseOrderSupplierService purchaseOrderSupplierService;
    @Inject
    private PurchaseOrderRepository purchaseOrderRepo;

    public void generateSuppliersPurchaseOrder(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        try {
            this.purchaseOrderSupplierService.generateSuppliersPurchaseOrder((PurchaseOrder)this.purchaseOrderRepo.find(purchaseOrder.getId()));
            response.setFlash(I18n.get((String)"Demande de consultations fournisseurs cr\u00e9\u00e9es"));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
    }

    public void generateSuppliersRequests(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        try {
            this.purchaseOrderSupplierService.generateAllSuppliersRequests((PurchaseOrder)this.purchaseOrderRepo.find(purchaseOrder.getId()));
            response.setFlash(I18n.get((String)"G\u00e9n\u00e9ration des devis fournisseurs termin\u00e9e"));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Exception)e);
        }
    }
}

