/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.base.db.Sequence;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Table(name="ACCOUNT_ACCOUNT_MANAGEMENT")
public class AccountManagement
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Type", selection="account.management.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Company")
    @NotNull
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Purchase Tax")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_PURCHASE_TAX_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax purchaseTax;
    @Widget(title="Sale Tax")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_SALE_TAX_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax saleTax;
    @Widget(title="Product")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Product family")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_PRODUCT_FAMILY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductFamily productFamily;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNT_MANAGEMENT_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNT_MANAGEMENT_SEQ", sequenceName="ACCOUNT_ACCOUNT_MANAGEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Purchase account")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_PURCHASE_ACCOUNT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchaseAccount;
    @Widget(title="Sale account")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_SALE_ACCOUNT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account saleAccount;
    @Widget(title="Payment account")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_CASH_ACCOUNT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account cashAccount;
    @Widget(title="Payment mode")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_PAYMENT_MODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Journal")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_JOURNAL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Sequence")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_SEQUENCE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sequence;
    @Widget(title="Analytic distribution template")
    @Index(name="ACCOUNT_ACCOUNT_MANAGEMENT_ANALYTIC_DISTRIBUTION_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Tax getPurchaseTax() {
        return this.purchaseTax;
    }

    public void setPurchaseTax(Tax purchaseTax) {
        this.purchaseTax = purchaseTax;
    }

    public Tax getSaleTax() {
        return this.saleTax;
    }

    public void setSaleTax(Tax saleTax) {
        this.saleTax = saleTax;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public ProductFamily getProductFamily() {
        return this.productFamily;
    }

    public void setProductFamily(ProductFamily productFamily) {
        this.productFamily = productFamily;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Account getPurchaseAccount() {
        return this.purchaseAccount;
    }

    public void setPurchaseAccount(Account purchaseAccount) {
        this.purchaseAccount = purchaseAccount;
    }

    public Account getSaleAccount() {
        return this.saleAccount;
    }

    public void setSaleAccount(Account saleAccount) {
        this.saleAccount = saleAccount;
    }

    public Account getCashAccount() {
        return this.cashAccount;
    }

    public void setCashAccount(Account cashAccount) {
        this.cashAccount = cashAccount;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountManagement)) {
            return false;
        }
        AccountManagement other = (AccountManagement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("typeSelect", (Object)this.getTypeSelect());
        return tsh.omitNullValues().toString();
    }
}

