/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Budget;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;

@Entity
@Cacheable
@Table(name="ACCOUNT_BUDGET_LINE")
public class BudgetLine
extends AuditableModel {
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @Index(name="ACCOUNT_BUDGET_LINE_BUDGET_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Budget budget;
    @Widget(title="Expected amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal amountExpected = BigDecimal.ZERO;
    @Widget(title="Realized amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal amountRealized = BigDecimal.ZERO;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_BUDGET_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_BUDGET_LINE_SEQ", sequenceName="ACCOUNT_BUDGET_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Committed amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal amountCommitted = BigDecimal.ZERO;

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public BigDecimal getAmountExpected() {
        return this.amountExpected == null ? BigDecimal.ZERO : this.amountExpected;
    }

    public void setAmountExpected(BigDecimal amountExpected) {
        this.amountExpected = amountExpected;
    }

    public BigDecimal getAmountRealized() {
        return this.amountRealized == null ? BigDecimal.ZERO : this.amountRealized;
    }

    public void setAmountRealized(BigDecimal amountRealized) {
        this.amountRealized = amountRealized;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmountCommitted() {
        return this.amountCommitted == null ? BigDecimal.ZERO : this.amountCommitted;
    }

    public void setAmountCommitted(BigDecimal amountCommitted) {
        this.amountCommitted = amountCommitted;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BudgetLine)) {
            return false;
        }
        BudgetLine other = (BudgetLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("fromDate", (Object)this.getFromDate());
        tsh.add("toDate", (Object)this.getToDate());
        tsh.add("amountExpected", (Object)this.getAmountExpected());
        tsh.add("amountRealized", (Object)this.getAmountRealized());
        tsh.add("amountCommitted", (Object)this.getAmountCommitted());
        return tsh.omitNullValues().toString();
    }
}

