/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.DirectDebitManagement;
import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.ManagementObject;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.StopReason;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;

@Entity
@Table(name="ACCOUNT_INVOICE", uniqueConstraints={@UniqueConstraint(columnNames={"invoiceId", "company"})})
@Track(fields={@TrackField(name="invoiceId"), @TrackField(name="partner"), @TrackField(name="statusSelect", on={TrackEvent.UPDATE})}, messages={@TrackMessage(message="Invoice created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Validated", condition="statusSelect == 2", tag="important"), @TrackMessage(message="Ventilated", condition="statusSelect == 3", tag="success"), @TrackMessage(message="Important", condition="statuSelect == 3 && dueDate.isAfter(__date__)")})
public class Invoice
extends AuditableModel {
    private Integer importId = 0;
    @Index(name="ACCOUNT_INVOICE_CANCELED_PAYMENT_SCHEDULE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentSchedule canceledPaymentSchedule;
    @Widget(title="Invoice N\u00b0", readonly=true)
    @NameColumn
    @Index(name="ACCOUNT_INVOICE_INVOICE_ID_IDX")
    private String invoiceId;
    @Widget(title="Document Type", selection="iinvoice.operation.type.select")
    @NotNull
    private Integer operationTypeSelect = 0;
    @Widget(title="Company")
    @NotNull
    @Index(name="ACCOUNT_INVOICE_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Partner")
    @NotNull
    @Index(name="ACCOUNT_INVOICE_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Contact")
    @Index(name="ACCOUNT_INVOICE_CONTACT_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Payment mode")
    @NotNull
    @Index(name="ACCOUNT_INVOICE_PAYMENT_MODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @NotNull
    @Index(name="ACCOUNT_INVOICE_PAYMENT_CONDITION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Bank details")
    @Index(name="ACCOUNT_INVOICE_BANK_DETAILS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Customer account")
    @NotNull
    @Index(name="ACCOUNT_INVOICE_PARTNER_ACCOUNT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account partnerAccount;
    @Widget(title="Address")
    @Index(name="ACCOUNT_INVOICE_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @Widget(title="End of cycle")
    private Boolean endOfCycleOk = Boolean.FALSE;
    @Widget(title="Subscription ?")
    private Boolean isSubscription = Boolean.FALSE;
    @Widget(title="Internal Ref.", help="true")
    private String internalReference;
    @Widget(title="External Ref.", help="true")
    private String externalReference;
    @Widget(title="Price list")
    @Index(name="ACCOUNT_INVOICE_PRICE_LIST_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Hide Discount on prints")
    private Boolean hideDiscount = Boolean.FALSE;
    @Widget(title="Invoice Date")
    private LocalDate invoiceDate;
    @Widget(title="Due Date")
    private LocalDate dueDate;
    @Widget(title="Belong to a payment schedule ?")
    private Boolean schedulePaymentOk = Boolean.FALSE;
    @Widget(title="Payment Schedule", readonly=true)
    @Index(name="ACCOUNT_INVOICE_PAYMENT_SCHEDULE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentSchedule paymentSchedule;
    @Widget(title="Journal")
    @NotNull
    @Index(name="ACCOUNT_INVOICE_JOURNAL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Move", readonly=true)
    @Index(name="ACCOUNT_INVOICE_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Widget(title="Previous Move", readonly=true)
    @Index(name="ACCOUNT_INVOICE_OLD_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move oldMove;
    @Widget(title="Doubtful Customer")
    private Boolean doubtfulCustomerOk = Boolean.FALSE;
    @Widget(title="Currency", help="true")
    @Index(name="ACCOUNT_INVOICE_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Payments")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoicePayment> invoicePaymentList;
    @Widget(title="Invoice Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoiceLine> invoiceLineList;
    @Widget(title="Tax Lines", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoiceLineTax> invoiceLineTaxList;
    @Widget(title="Already printed ?", help="true")
    private Boolean alreadyPrintedOk = Boolean.TRUE;
    @Widget(title="Invoice of origin")
    @Index(name="ACCOUNT_INVOICE_ORIGINAL_INVOICE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice originalInvoice;
    @Widget(title="Refunds")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="originalInvoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Invoice> refundInvoiceList;
    @Widget(title="Irrecouvrable status", readonly=true, selection="iaccount.account.schedule.irrecoverable.status.select")
    private Integer irrecoverableStatusSelect = 0;
    @Widget(title="Irrecoverable shifting reason")
    @Index(name="ACCOUNT_INVOICE_MANAGEMENT_OBJECT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManagementObject managementObject;
    @Widget(title="Standard Invoice")
    @Index(name="ACCOUNT_INVOICE_STANDARD_INVOICE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice standardInvoice;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Direct debit blocking")
    private Boolean debitBlockingOk = Boolean.FALSE;
    @Widget(title="Blocking reason")
    @Index(name="ACCOUNT_INVOICE_DEBIT_BLOCKING_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason debitBlockingReason;
    @Widget(title="Blocking until")
    private LocalDate debitBlockingToDate;
    @Widget(title="Blocking done by")
    @Index(name="ACCOUNT_INVOICE_DEBIT_BLOCKING_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User debitBlockingByUser;
    @Widget(title="Reminder blocking")
    private Boolean reminderBlockingOk = Boolean.FALSE;
    @Widget(title="Blocking reason")
    @Index(name="ACCOUNT_INVOICE_REMINDER_BLOCKING_REASON_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason reminderBlockingReason;
    @Widget(title="Blocking until")
    private LocalDate reminderBlockingToDate;
    @Widget(title="Blocking done by")
    @Index(name="ACCOUNT_INVOICE_REMINDER_BLOCKING_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User reminderBlockingByUser;
    @Widget(title="Direct Debit N\u00b0")
    private String debitNumber;
    @Widget(title="Direct debit list")
    @Index(name="ACCOUNT_INVOICE_DIRECT_DEBIT_MANAGEMENT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DirectDebitManagement directDebitManagement;
    @Widget(title="Reject move line")
    @Index(name="ACCOUNT_INVOICE_REJECT_MOVE_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine rejectMoveLine;
    @Widget(title="Transfer(ed) to usher")
    private Boolean usherPassageOk = Boolean.FALSE;
    @Widget(title="Rejected amount")
    private BigDecimal amountRejected = BigDecimal.ZERO;
    @Widget(title="Reject Date")
    private LocalDate rejectDate;
    @Widget(title="Reject reason")
    @Index(name="ACCOUNT_INVOICE_INTERBANK_CODE_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Debited amount", readonly=true)
    private BigDecimal directDebitAmount = BigDecimal.ZERO;
    @Widget(title="Payment Move")
    @Index(name="ACCOUNT_INVOICE_PAYMENT_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move paymentMove;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String note;
    @Widget(title="Total W.T.", help="true", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total Tax", help="true", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", help="true", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Amount paid", readonly=true)
    private BigDecimal amountPaid = BigDecimal.ZERO;
    @Widget(title="Amount remaining", readonly=true)
    private BigDecimal amountRemaining = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total Tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="Remaining to pay", readonly=true)
    private BigDecimal companyInTaxTotalRemaining = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="iaccount.invoice.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Validated by", readonly=true)
    @Index(name="ACCOUNT_INVOICE_VALIDATED_BY_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedByUser;
    @Widget(title="Message")
    private String message;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Supplier invoice number")
    private String supplierInvoiceNb;
    @Widget(title="Company bank")
    @Index(name="ACCOUNT_INVOICE_COMPANY_BANK_DETAILS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_SEQ", sequenceName="ACCOUNT_INVOICE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sale order")
    @Index(name="ACCOUNT_INVOICE_SALE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Purchase order")
    @Index(name="ACCOUNT_INVOICE_PURCHASE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder purchaseOrder;

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public PaymentSchedule getCanceledPaymentSchedule() {
        return this.canceledPaymentSchedule;
    }

    public void setCanceledPaymentSchedule(PaymentSchedule canceledPaymentSchedule) {
        this.canceledPaymentSchedule = canceledPaymentSchedule;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Integer getOperationTypeSelect() {
        return this.operationTypeSelect == null ? 0 : this.operationTypeSelect;
    }

    public void setOperationTypeSelect(Integer operationTypeSelect) {
        this.operationTypeSelect = operationTypeSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public Account getPartnerAccount() {
        return this.partnerAccount;
    }

    public void setPartnerAccount(Account partnerAccount) {
        this.partnerAccount = partnerAccount;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Boolean getEndOfCycleOk() {
        return this.endOfCycleOk == null ? Boolean.FALSE : this.endOfCycleOk;
    }

    public void setEndOfCycleOk(Boolean endOfCycleOk) {
        this.endOfCycleOk = endOfCycleOk;
    }

    public Boolean getIsSubscription() {
        return this.isSubscription == null ? Boolean.FALSE : this.isSubscription;
    }

    public void setIsSubscription(Boolean isSubscription) {
        this.isSubscription = isSubscription;
    }

    public String getInternalReference() {
        return this.internalReference;
    }

    public void setInternalReference(String internalReference) {
        this.internalReference = internalReference;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public Boolean getHideDiscount() {
        return this.hideDiscount == null ? Boolean.FALSE : this.hideDiscount;
    }

    public void setHideDiscount(Boolean hideDiscount) {
        this.hideDiscount = hideDiscount;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public Boolean getSchedulePaymentOk() {
        return this.schedulePaymentOk == null ? Boolean.FALSE : this.schedulePaymentOk;
    }

    public void setSchedulePaymentOk(Boolean schedulePaymentOk) {
        this.schedulePaymentOk = schedulePaymentOk;
    }

    public PaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public void setPaymentSchedule(PaymentSchedule paymentSchedule) {
        this.paymentSchedule = paymentSchedule;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public Move getOldMove() {
        return this.oldMove;
    }

    public void setOldMove(Move oldMove) {
        this.oldMove = oldMove;
    }

    public Boolean getDoubtfulCustomerOk() {
        return this.doubtfulCustomerOk == null ? Boolean.FALSE : this.doubtfulCustomerOk;
    }

    public void setDoubtfulCustomerOk(Boolean doubtfulCustomerOk) {
        this.doubtfulCustomerOk = doubtfulCustomerOk;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public List<InvoicePayment> getInvoicePaymentList() {
        return this.invoicePaymentList;
    }

    public void setInvoicePaymentList(List<InvoicePayment> invoicePaymentList) {
        this.invoicePaymentList = invoicePaymentList;
    }

    public void addInvoicePaymentListItem(InvoicePayment item) {
        if (this.invoicePaymentList == null) {
            this.invoicePaymentList = new ArrayList<InvoicePayment>();
        }
        this.invoicePaymentList.add(item);
        item.setInvoice(this);
    }

    public void removeInvoicePaymentListItem(InvoicePayment item) {
        if (this.invoicePaymentList == null) {
            return;
        }
        this.invoicePaymentList.remove(item);
    }

    public void clearInvoicePaymentList() {
        if (this.invoicePaymentList != null) {
            this.invoicePaymentList.clear();
        }
    }

    public List<InvoiceLine> getInvoiceLineList() {
        return this.invoiceLineList;
    }

    public void setInvoiceLineList(List<InvoiceLine> invoiceLineList) {
        this.invoiceLineList = invoiceLineList;
    }

    public void addInvoiceLineListItem(InvoiceLine item) {
        if (this.invoiceLineList == null) {
            this.invoiceLineList = new ArrayList<InvoiceLine>();
        }
        this.invoiceLineList.add(item);
        item.setInvoice(this);
    }

    public void removeInvoiceLineListItem(InvoiceLine item) {
        if (this.invoiceLineList == null) {
            return;
        }
        this.invoiceLineList.remove((Object)item);
    }

    public void clearInvoiceLineList() {
        if (this.invoiceLineList != null) {
            this.invoiceLineList.clear();
        }
    }

    public List<InvoiceLineTax> getInvoiceLineTaxList() {
        return this.invoiceLineTaxList;
    }

    public void setInvoiceLineTaxList(List<InvoiceLineTax> invoiceLineTaxList) {
        this.invoiceLineTaxList = invoiceLineTaxList;
    }

    public void addInvoiceLineTaxListItem(InvoiceLineTax item) {
        if (this.invoiceLineTaxList == null) {
            this.invoiceLineTaxList = new ArrayList<InvoiceLineTax>();
        }
        this.invoiceLineTaxList.add(item);
        item.setInvoice(this);
    }

    public void removeInvoiceLineTaxListItem(InvoiceLineTax item) {
        if (this.invoiceLineTaxList == null) {
            return;
        }
        this.invoiceLineTaxList.remove(item);
    }

    public void clearInvoiceLineTaxList() {
        if (this.invoiceLineTaxList != null) {
            this.invoiceLineTaxList.clear();
        }
    }

    public Boolean getAlreadyPrintedOk() {
        return this.alreadyPrintedOk == null ? Boolean.FALSE : this.alreadyPrintedOk;
    }

    public void setAlreadyPrintedOk(Boolean alreadyPrintedOk) {
        this.alreadyPrintedOk = alreadyPrintedOk;
    }

    public Invoice getOriginalInvoice() {
        return this.originalInvoice;
    }

    public void setOriginalInvoice(Invoice originalInvoice) {
        this.originalInvoice = originalInvoice;
    }

    public List<Invoice> getRefundInvoiceList() {
        return this.refundInvoiceList;
    }

    public void setRefundInvoiceList(List<Invoice> refundInvoiceList) {
        this.refundInvoiceList = refundInvoiceList;
    }

    public void addRefundInvoiceListItem(Invoice item) {
        if (this.refundInvoiceList == null) {
            this.refundInvoiceList = new ArrayList<Invoice>();
        }
        this.refundInvoiceList.add(item);
        item.setOriginalInvoice(this);
    }

    public void removeRefundInvoiceListItem(Invoice item) {
        if (this.refundInvoiceList == null) {
            return;
        }
        this.refundInvoiceList.remove((Object)item);
    }

    public void clearRefundInvoiceList() {
        if (this.refundInvoiceList != null) {
            this.refundInvoiceList.clear();
        }
    }

    public Integer getIrrecoverableStatusSelect() {
        return this.irrecoverableStatusSelect == null ? 0 : this.irrecoverableStatusSelect;
    }

    public void setIrrecoverableStatusSelect(Integer irrecoverableStatusSelect) {
        this.irrecoverableStatusSelect = irrecoverableStatusSelect;
    }

    public ManagementObject getManagementObject() {
        return this.managementObject;
    }

    public void setManagementObject(ManagementObject managementObject) {
        this.managementObject = managementObject;
    }

    public Invoice getStandardInvoice() {
        return this.standardInvoice;
    }

    public void setStandardInvoice(Invoice standardInvoice) {
        this.standardInvoice = standardInvoice;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.batchSet == null) {
            this.batchSet = new HashSet<Batch>();
        }
        this.batchSet.add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.batchSet == null) {
            return;
        }
        this.batchSet.remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.batchSet != null) {
            this.batchSet.clear();
        }
    }

    public Boolean getDebitBlockingOk() {
        return this.debitBlockingOk == null ? Boolean.FALSE : this.debitBlockingOk;
    }

    public void setDebitBlockingOk(Boolean debitBlockingOk) {
        this.debitBlockingOk = debitBlockingOk;
    }

    public StopReason getDebitBlockingReason() {
        return this.debitBlockingReason;
    }

    public void setDebitBlockingReason(StopReason debitBlockingReason) {
        this.debitBlockingReason = debitBlockingReason;
    }

    public LocalDate getDebitBlockingToDate() {
        return this.debitBlockingToDate;
    }

    public void setDebitBlockingToDate(LocalDate debitBlockingToDate) {
        this.debitBlockingToDate = debitBlockingToDate;
    }

    public User getDebitBlockingByUser() {
        return this.debitBlockingByUser;
    }

    public void setDebitBlockingByUser(User debitBlockingByUser) {
        this.debitBlockingByUser = debitBlockingByUser;
    }

    public Boolean getReminderBlockingOk() {
        return this.reminderBlockingOk == null ? Boolean.FALSE : this.reminderBlockingOk;
    }

    public void setReminderBlockingOk(Boolean reminderBlockingOk) {
        this.reminderBlockingOk = reminderBlockingOk;
    }

    public StopReason getReminderBlockingReason() {
        return this.reminderBlockingReason;
    }

    public void setReminderBlockingReason(StopReason reminderBlockingReason) {
        this.reminderBlockingReason = reminderBlockingReason;
    }

    public LocalDate getReminderBlockingToDate() {
        return this.reminderBlockingToDate;
    }

    public void setReminderBlockingToDate(LocalDate reminderBlockingToDate) {
        this.reminderBlockingToDate = reminderBlockingToDate;
    }

    public User getReminderBlockingByUser() {
        return this.reminderBlockingByUser;
    }

    public void setReminderBlockingByUser(User reminderBlockingByUser) {
        this.reminderBlockingByUser = reminderBlockingByUser;
    }

    public String getDebitNumber() {
        return this.debitNumber;
    }

    public void setDebitNumber(String debitNumber) {
        this.debitNumber = debitNumber;
    }

    public DirectDebitManagement getDirectDebitManagement() {
        return this.directDebitManagement;
    }

    public void setDirectDebitManagement(DirectDebitManagement directDebitManagement) {
        this.directDebitManagement = directDebitManagement;
    }

    public MoveLine getRejectMoveLine() {
        return this.rejectMoveLine;
    }

    public void setRejectMoveLine(MoveLine rejectMoveLine) {
        this.rejectMoveLine = rejectMoveLine;
    }

    public Boolean getUsherPassageOk() {
        return this.usherPassageOk == null ? Boolean.FALSE : this.usherPassageOk;
    }

    public void setUsherPassageOk(Boolean usherPassageOk) {
        this.usherPassageOk = usherPassageOk;
    }

    public BigDecimal getAmountRejected() {
        return this.amountRejected == null ? BigDecimal.ZERO : this.amountRejected;
    }

    public void setAmountRejected(BigDecimal amountRejected) {
        this.amountRejected = amountRejected;
    }

    public LocalDate getRejectDate() {
        return this.rejectDate;
    }

    public void setRejectDate(LocalDate rejectDate) {
        this.rejectDate = rejectDate;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public BigDecimal getDirectDebitAmount() {
        return this.directDebitAmount == null ? BigDecimal.ZERO : this.directDebitAmount;
    }

    public void setDirectDebitAmount(BigDecimal directDebitAmount) {
        this.directDebitAmount = directDebitAmount;
    }

    public Move getPaymentMove() {
        return this.paymentMove;
    }

    public void setPaymentMove(Move paymentMove) {
        this.paymentMove = paymentMove;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public BigDecimal getAmountPaid() {
        return this.amountPaid == null ? BigDecimal.ZERO : this.amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public BigDecimal getAmountRemaining() {
        return this.amountRemaining == null ? BigDecimal.ZERO : this.amountRemaining;
    }

    public void setAmountRemaining(BigDecimal amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyTaxTotal() {
        return this.companyTaxTotal == null ? BigDecimal.ZERO : this.companyTaxTotal;
    }

    public void setCompanyTaxTotal(BigDecimal companyTaxTotal) {
        this.companyTaxTotal = companyTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotalRemaining() {
        return this.companyInTaxTotalRemaining == null ? BigDecimal.ZERO : this.companyInTaxTotalRemaining;
    }

    public void setCompanyInTaxTotalRemaining(BigDecimal companyInTaxTotalRemaining) {
        this.companyInTaxTotalRemaining = companyInTaxTotalRemaining;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public User getValidatedByUser() {
        return this.validatedByUser;
    }

    public void setValidatedByUser(User validatedByUser) {
        this.validatedByUser = validatedByUser;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public String getSupplierInvoiceNb() {
        return this.supplierInvoiceNb;
    }

    public void setSupplierInvoiceNb(String supplierInvoiceNb) {
        this.supplierInvoiceNb = supplierInvoiceNb;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public PurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("invoiceId", (Object)this.getInvoiceId());
        tsh.add("operationTypeSelect", (Object)this.getOperationTypeSelect());
        tsh.add("endOfCycleOk", (Object)this.getEndOfCycleOk());
        tsh.add("isSubscription", (Object)this.getIsSubscription());
        tsh.add("internalReference", (Object)this.getInternalReference());
        tsh.add("externalReference", (Object)this.getExternalReference());
        tsh.add("hideDiscount", (Object)this.getHideDiscount());
        tsh.add("invoiceDate", (Object)this.getInvoiceDate());
        tsh.add("dueDate", (Object)this.getDueDate());
        tsh.add("schedulePaymentOk", (Object)this.getSchedulePaymentOk());
        return tsh.omitNullValues().toString();
    }
}

