/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_INVOICE_LINE")
public class InvoiceLine
extends AuditableModel {
    @Widget(title="Invoice")
    @Index(name="ACCOUNT_INVOICE_LINE_INVOICE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Product")
    @Index(name="ACCOUNT_INVOICE_LINE_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Product Name")
    private String productName;
    @Widget(title="Product Code")
    private String productCode;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Unit")
    @Index(name="ACCOUNT_INVOICE_LINE_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Qty")
    @Digits(integer=18, fraction=2)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Tax")
    @Index(name="ACCOUNT_INVOICE_LINE_TAX_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Discount Type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 3;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Total W.T. in Acc. currency", hidden=true)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I. in company currency", hidden=true)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="From")
    private LocalDate subscriptionFromDate;
    @Widget(title="To")
    private LocalDate subscriptionToDate;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoiceLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticDistributionLine> analyticDistributionLineList;
    @Widget(title="Analytic distribution template")
    @Index(name="ACCOUNT_INVOICE_LINE_ANALYTIC_DISTRIBUTION_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Budget")
    @Index(name="ACCOUNT_INVOICE_LINE_BUDGET_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Budget budget;
    @Widget(title="Budget Distribution")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoiceLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BudgetDistribution> budgetDistributionList;
    @Widget(title="Title Line")
    private Boolean isTitleLine = Boolean.FALSE;
    @Widget(readonly=true)
    @Digits(integer=17, fraction=3)
    private BigDecimal taxRate = BigDecimal.ZERO;
    @Widget(readonly=true)
    private String taxCode;
    @Widget(title="Name", search={"invoice", "productName"})
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Index(name="ACCOUNT_INVOICE_LINE_NAME_IDX")
    private String name;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_LINE_SEQ", sequenceName="ACCOUNT_INVOICE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="SO line")
    @Index(name="ACCOUNT_INVOICE_LINE_SALE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Widget(title="PO line")
    @Index(name="ACCOUNT_INVOICE_LINE_PURCHASE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrderLine purchaseOrderLine;
    @Widget(title="Customer delivery")
    @Index(name="ACCOUNT_INVOICE_LINE_OUTGOING_STOCK_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove outgoingStockMove;
    @Widget(title="Supplier arrival")
    @Index(name="ACCOUNT_INVOICE_LINE_INCOMING_STOCK_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove incomingStockMove;
    @Widget(title="Sale Order")
    @Index(name="ACCOUNT_INVOICE_LINE_SALE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;

    public InvoiceLine() {
    }

    public InvoiceLine(String name) {
        this.name = name;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public LocalDate getSubscriptionFromDate() {
        return this.subscriptionFromDate;
    }

    public void setSubscriptionFromDate(LocalDate subscriptionFromDate) {
        this.subscriptionFromDate = subscriptionFromDate;
    }

    public LocalDate getSubscriptionToDate() {
        return this.subscriptionToDate;
    }

    public void setSubscriptionToDate(LocalDate subscriptionToDate) {
        this.subscriptionToDate = subscriptionToDate;
    }

    public List<AnalyticDistributionLine> getAnalyticDistributionLineList() {
        return this.analyticDistributionLineList;
    }

    public void setAnalyticDistributionLineList(List<AnalyticDistributionLine> analyticDistributionLineList) {
        this.analyticDistributionLineList = analyticDistributionLineList;
    }

    public void addAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.analyticDistributionLineList == null) {
            this.analyticDistributionLineList = new ArrayList<AnalyticDistributionLine>();
        }
        this.analyticDistributionLineList.add(item);
        item.setInvoiceLine(this);
    }

    public void removeAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.analyticDistributionLineList == null) {
            return;
        }
        this.analyticDistributionLineList.remove((Object)item);
    }

    public void clearAnalyticDistributionLineList() {
        if (this.analyticDistributionLineList != null) {
            this.analyticDistributionLineList.clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public List<BudgetDistribution> getBudgetDistributionList() {
        return this.budgetDistributionList;
    }

    public void setBudgetDistributionList(List<BudgetDistribution> budgetDistributionList) {
        this.budgetDistributionList = budgetDistributionList;
    }

    public void addBudgetDistributionListItem(BudgetDistribution item) {
        if (this.budgetDistributionList == null) {
            this.budgetDistributionList = new ArrayList<BudgetDistribution>();
        }
        this.budgetDistributionList.add(item);
        item.setInvoiceLine(this);
    }

    public void removeBudgetDistributionListItem(BudgetDistribution item) {
        if (this.budgetDistributionList == null) {
            return;
        }
        this.budgetDistributionList.remove((Object)item);
    }

    public void clearBudgetDistributionList() {
        if (this.budgetDistributionList != null) {
            this.budgetDistributionList.clear();
        }
    }

    public Boolean getIsTitleLine() {
        return this.isTitleLine == null ? Boolean.FALSE : this.isTitleLine;
    }

    public void setIsTitleLine(Boolean isTitleLine) {
        this.isTitleLine = isTitleLine;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate == null ? BigDecimal.ZERO : this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.invoice != null && this.invoice.getInvoiceId() != null) {
            name = name + this.invoice.getInvoiceId();
        }
        if (this.productName != null) {
            name = name + "-";
            name = this.productName.length() > 100 ? name + this.productName.substring(1, 100) : name + this.productName;
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public PurchaseOrderLine getPurchaseOrderLine() {
        return this.purchaseOrderLine;
    }

    public void setPurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        this.purchaseOrderLine = purchaseOrderLine;
    }

    public StockMove getOutgoingStockMove() {
        return this.outgoingStockMove;
    }

    public void setOutgoingStockMove(StockMove outgoingStockMove) {
        this.outgoingStockMove = outgoingStockMove;
    }

    public StockMove getIncomingStockMove() {
        return this.incomingStockMove;
    }

    public void setIncomingStockMove(StockMove incomingStockMove) {
        this.incomingStockMove = incomingStockMove;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoiceLine)) {
            return false;
        }
        InvoiceLine other = (InvoiceLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("sequence", (Object)this.getSequence());
        tsh.add("productName", (Object)this.getProductName());
        tsh.add("productCode", (Object)this.getProductCode());
        tsh.add("price", (Object)this.getPrice());
        tsh.add("priceDiscounted", (Object)this.getPriceDiscounted());
        tsh.add("qty", (Object)this.getQty());
        tsh.add("exTaxTotal", (Object)this.getExTaxTotal());
        tsh.add("inTaxTotal", (Object)this.getInTaxTotal());
        tsh.add("discountAmount", (Object)this.getDiscountAmount());
        tsh.add("discountTypeSelect", (Object)this.getDiscountTypeSelect());
        tsh.add("companyExTaxTotal", (Object)this.getCompanyExTaxTotal());
        return tsh.omitNullValues().toString();
    }
}

