/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.crm.db.CrmConfig;
import com.axelor.apps.purchase.db.PurchaseConfig;
import com.axelor.apps.sale.db.SaleConfig;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_COMPANY")
public class Company
extends AuditableModel {
    private Integer importId = 0;
    @HashKey
    @Widget(title="Name")
    @NotNull
    @Column(unique=true)
    private String name;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String code;
    @Widget(title="Address")
    @Index(name="BASE_COMPANY_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @Widget(title="Partner")
    @Index(name="BASE_COMPANY_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Parent company", help="true")
    @Index(name="BASE_COMPANY_PARENT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company parent;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String notes;
    @Widget(title="Logo", help="true")
    @Index(name="BASE_COMPANY_LOGO_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile logo;
    @Widget(title="Currency", help="true")
    @Index(name="BASE_COMPANY_CURRENCY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Default Bank Account", help="true")
    @Index(name="BASE_COMPANY_DEFAULT_BANK_DETAILS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails defaultBankDetails;
    @Widget(title="Bank accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<BankDetails> bankDetailsSet;
    @Widget(title="Printing Settings", help="true")
    @Index(name="BASE_COMPANY_PRINTING_SETTINGS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PrintingSettings printingSettings;
    @Widget(title="Partner Type", selection="company.partner.type.select")
    private Integer defaultPartnerTypeSelect = 1;
    @Widget(title="Purchase config")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseConfig purchaseConfig;
    @Widget(title="CRM config")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CrmConfig crmConfig;
    @Widget(title="Sale config")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleConfig saleConfig;
    @Widget(multiline=true)
    private String orderBloquedMessage;
    @Widget(title="Stock config")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockConfig stockConfig;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_COMPANY_SEQ")
    @SequenceGenerator(name="BASE_COMPANY_SEQ", sequenceName="BASE_COMPANY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Accounting configuration")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountConfig accountConfig;

    public Company() {
    }

    public Company(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getParent() {
        return this.parent;
    }

    public void setParent(Company parent) {
        this.parent = parent;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public MetaFile getLogo() {
        return this.logo;
    }

    public void setLogo(MetaFile logo) {
        this.logo = logo;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BankDetails getDefaultBankDetails() {
        return this.defaultBankDetails;
    }

    public void setDefaultBankDetails(BankDetails defaultBankDetails) {
        this.defaultBankDetails = defaultBankDetails;
    }

    public Set<BankDetails> getBankDetailsSet() {
        return this.bankDetailsSet;
    }

    public void setBankDetailsSet(Set<BankDetails> bankDetailsSet) {
        this.bankDetailsSet = bankDetailsSet;
    }

    public void addBankDetailsSetItem(BankDetails item) {
        if (this.bankDetailsSet == null) {
            this.bankDetailsSet = new HashSet<BankDetails>();
        }
        this.bankDetailsSet.add(item);
    }

    public void removeBankDetailsSetItem(BankDetails item) {
        if (this.bankDetailsSet == null) {
            return;
        }
        this.bankDetailsSet.remove(item);
    }

    public void clearBankDetailsSet() {
        if (this.bankDetailsSet != null) {
            this.bankDetailsSet.clear();
        }
    }

    public PrintingSettings getPrintingSettings() {
        return this.printingSettings;
    }

    public void setPrintingSettings(PrintingSettings printingSettings) {
        this.printingSettings = printingSettings;
    }

    public Integer getDefaultPartnerTypeSelect() {
        return this.defaultPartnerTypeSelect == null ? 0 : this.defaultPartnerTypeSelect;
    }

    public void setDefaultPartnerTypeSelect(Integer defaultPartnerTypeSelect) {
        this.defaultPartnerTypeSelect = defaultPartnerTypeSelect;
    }

    public PurchaseConfig getPurchaseConfig() {
        return this.purchaseConfig;
    }

    public void setPurchaseConfig(PurchaseConfig purchaseConfig) {
        this.purchaseConfig = purchaseConfig;
    }

    public CrmConfig getCrmConfig() {
        return this.crmConfig;
    }

    public void setCrmConfig(CrmConfig crmConfig) {
        this.crmConfig = crmConfig;
    }

    public SaleConfig getSaleConfig() {
        return this.saleConfig;
    }

    public void setSaleConfig(SaleConfig saleConfig) {
        this.saleConfig = saleConfig;
    }

    public String getOrderBloquedMessage() {
        return this.orderBloquedMessage;
    }

    public void setOrderBloquedMessage(String orderBloquedMessage) {
        this.orderBloquedMessage = orderBloquedMessage;
    }

    public StockConfig getStockConfig() {
        return this.stockConfig;
    }

    public void setStockConfig(StockConfig stockConfig) {
        this.stockConfig = stockConfig;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    public void setAccountConfig(AccountConfig accountConfig) {
        this.accountConfig = accountConfig;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Company)) {
            return false;
        }
        Company other = (Company)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-1679829923, this.getName(), this.getCode());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("code", (Object)this.getCode());
        tsh.add("defaultPartnerTypeSelect", (Object)this.getDefaultPartnerTypeSelect());
        tsh.add("orderBloquedMessage", (Object)this.getOrderBloquedMessage());
        return tsh.omitNullValues().toString();
    }
}

