/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.InterbankCode;
import com.axelor.apps.account.db.PayerQualityConfigLine;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.db.Unit;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import org.hibernate.annotations.Index;
import org.joda.time.DateTime;

@Entity
@Cacheable
@Table(name="BASE_GENERAL")
public class General
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Today date", help="true")
    private DateTime today;
    @Widget(title="Default Project unit", help="true")
    @Index(name="BASE_GENERAL_DEFAULT_PROJECT_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit defaultProjectUnit;
    @Widget(title="Default Partner language", help="true", selection="select.language")
    private String defaultPartnerLanguage;
    @Widget(title="Manage mail account by user ?")
    private Boolean mailAccountByUser = Boolean.FALSE;
    @Widget(title="URL to QAS WSDL", help="true")
    private String qasWsdlUrl;
    @Widget(title="Mapping service provider", selection="base.general.map.api.select")
    private Integer mapApiSelect = 1;
    @Widget(title="Currency Ws URL", help="true")
    private String currencyWsURL;
    @Widget(title="Currency conversion table", help="true")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="general", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CurrencyConversionLine> currencyConversionLineList;
    @Widget(title="Use QAS Validation ?", help="true")
    private Boolean hasQasValidation = Boolean.FALSE;
    @Widget(title="Products ATI/WT", selection="base.in.ati.select")
    private Integer productInAtiSelect = 1;
    @Widget(title="Nb of digits for unit prices")
    @Max(value=10L)
    private Integer nbDecimalDigitForUnitPrice = 2;
    @Widget(title="Compute Method for Discounts", selection="base.compute.method.discount.select")
    private Integer computeMethodDiscountSelect = 1;
    @Widget(title="Time logging preference", selection="hr.time.logging.preference.select")
    private String timeLoggingPreferenceSelect = "days";
    @Widget(title="Daily Work Hours")
    private BigDecimal dailyWorkHours = BigDecimal.ZERO;
    @Widget(title="Days Unit")
    @Index(name="BASE_GENERAL_UNIT_DAYS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitDays;
    @Widget(title="Hours Unit")
    @Index(name="BASE_GENERAL_UNIT_HOURS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitHours;
    @Widget(title="Minutes Unit")
    @Index(name="BASE_GENERAL_UNIT_MINUTES_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unitMinutes;
    @Widget(title="Team Management")
    private Boolean teamManagement = Boolean.TRUE;
    @Widget(title="Activate sending email")
    private Boolean activateSendingEmail = Boolean.TRUE;
    @Widget(title="purchase order management")
    private Boolean purchaseOrderManagement = Boolean.FALSE;
    @Widget(title="Manage purchase order versions")
    private Boolean managePurchaseOrderVersion = Boolean.FALSE;
    @Widget(title="Generate purchase orders automatically")
    private Boolean purchaseOrderGenerationAuto = Boolean.FALSE;
    @Widget(title="Manage purchases unit on products")
    private Boolean managePurchasesUnits = Boolean.FALSE;
    @Widget(title="Manage sale order versions")
    private Boolean manageSaleOrderVersion = Boolean.FALSE;
    @Widget(title="Generate invoice from sale order")
    private Boolean generateInvoiceFromSaleOrder = Boolean.FALSE;
    @Widget(title="Allow timetable invoicing")
    private Boolean allowTimetableInvoicing = Boolean.FALSE;
    @Widget(title="Manage sales unit on products")
    private Boolean manageSalesUnits = Boolean.FALSE;
    @Widget(title="Consolidate invoice movelines ?")
    private Boolean isInvoiceMoveConsolidated = Boolean.TRUE;
    @Widget(title="Code list for rejects/return of Direct debit, Wire Transfers and IPO")
    @Index(name="BASE_GENERAL_TRANSFER_AND_DIRECT_DEBIT_INTERBANK_CODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCode transferAndDirectDebitInterbankCode;
    @Widget(title="Code list for rejects/return of Cheques")
    @Index(name="BASE_GENERAL_CHEQUE_INTERBANK_CODE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCode chequeInterbankCode;
    @Widget(title="Weight table (Payer quality)")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<PayerQualityConfigLine> payerQualityConfigLineList;
    @Widget(title="Tax 0%")
    @Index(name="BASE_GENERAL_DEFAULT_EXEMPTION_TAX_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax defaultExemptionTax;
    @Widget(title="Manage customerCredit")
    private Boolean manageCustomerCredit = Boolean.FALSE;
    @Widget(title="Manage analytic accounting")
    private Boolean manageAnalyticAccounting = Boolean.FALSE;
    @Widget(title="Analytic distribution type", selection="account.general.analytic.distribution.type.select")
    private Integer analyticDistributionTypeSelect = 1;
    @Widget(title="Manage budgets")
    private Boolean manageBudget = Boolean.FALSE;
    @Widget(title="Manage multi budgets on lines")
    private Boolean manageMultiBudget = Boolean.FALSE;
    @Widget(title="Status considered to calculate the engaged amount", selection="purchase.purchase.order.status.select")
    private String budgetStatusSelect = "4";
    @Widget(title="Manage direct debit payment")
    private Boolean manageDirectDebitPayment = Boolean.FALSE;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_GENERAL_SEQ")
    @SequenceGenerator(name="BASE_GENERAL_SEQ", sequenceName="BASE_GENERAL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Manage the invoiced amount by line")
    private Boolean manageInvoicedAmountByLine = Boolean.FALSE;
    @Widget(title="Customer deliveries management")
    private Boolean customerStockMoveManagement = Boolean.FALSE;
    @Widget(title="Generate customer deliveries automatically")
    private Boolean customerStockMoveGenerationAuto = Boolean.FALSE;
    @Widget(title="Supplier arrivals management")
    private Boolean supplierStockMoveManagement = Boolean.FALSE;
    @Widget(title="Generate supplier arrivals automatically")
    private Boolean supplierStockMoveGenerationAuto = Boolean.FALSE;
    @Widget(title="Allow Subscriptions for Sale Orders")
    private Boolean allowSusbcriptionSaleOrder = Boolean.FALSE;
    @Widget(title="Generate invoice from stock move")
    private Boolean generateInvoiceFromStockMove = Boolean.FALSE;
    @Widget(title="Terminate sale order on delivery", help="Automatically finish a sale order when all of the stock moves bound to it are realised")
    private Boolean terminateSaleOrderOnDelivery = Boolean.FALSE;
    @Widget(title="Terminate purchase order on Receipt", help="Automatically finish a purchase order when all of the stock moves bound to it are realised")
    private Boolean terminatePurchaseOrderOnReceipt = Boolean.FALSE;

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public DateTime getToday() {
        return this.today;
    }

    public void setToday(DateTime today) {
        this.today = today;
    }

    public Unit getDefaultProjectUnit() {
        return this.defaultProjectUnit;
    }

    public void setDefaultProjectUnit(Unit defaultProjectUnit) {
        this.defaultProjectUnit = defaultProjectUnit;
    }

    public String getDefaultPartnerLanguage() {
        return this.defaultPartnerLanguage;
    }

    public void setDefaultPartnerLanguage(String defaultPartnerLanguage) {
        this.defaultPartnerLanguage = defaultPartnerLanguage;
    }

    public Boolean getMailAccountByUser() {
        return this.mailAccountByUser == null ? Boolean.FALSE : this.mailAccountByUser;
    }

    public void setMailAccountByUser(Boolean mailAccountByUser) {
        this.mailAccountByUser = mailAccountByUser;
    }

    public String getQasWsdlUrl() {
        return this.qasWsdlUrl;
    }

    public void setQasWsdlUrl(String qasWsdlUrl) {
        this.qasWsdlUrl = qasWsdlUrl;
    }

    public Integer getMapApiSelect() {
        return this.mapApiSelect == null ? 0 : this.mapApiSelect;
    }

    public void setMapApiSelect(Integer mapApiSelect) {
        this.mapApiSelect = mapApiSelect;
    }

    public String getCurrencyWsURL() {
        return this.currencyWsURL;
    }

    public void setCurrencyWsURL(String currencyWsURL) {
        this.currencyWsURL = currencyWsURL;
    }

    public List<CurrencyConversionLine> getCurrencyConversionLineList() {
        return this.currencyConversionLineList;
    }

    public void setCurrencyConversionLineList(List<CurrencyConversionLine> currencyConversionLineList) {
        this.currencyConversionLineList = currencyConversionLineList;
    }

    public void addCurrencyConversionLineListItem(CurrencyConversionLine item) {
        if (this.currencyConversionLineList == null) {
            this.currencyConversionLineList = new ArrayList<CurrencyConversionLine>();
        }
        this.currencyConversionLineList.add(item);
        item.setGeneral(this);
    }

    public void removeCurrencyConversionLineListItem(CurrencyConversionLine item) {
        if (this.currencyConversionLineList == null) {
            return;
        }
        this.currencyConversionLineList.remove(item);
    }

    public void clearCurrencyConversionLineList() {
        if (this.currencyConversionLineList != null) {
            this.currencyConversionLineList.clear();
        }
    }

    public Boolean getHasQasValidation() {
        return this.hasQasValidation == null ? Boolean.FALSE : this.hasQasValidation;
    }

    public void setHasQasValidation(Boolean hasQasValidation) {
        this.hasQasValidation = hasQasValidation;
    }

    public Integer getProductInAtiSelect() {
        return this.productInAtiSelect == null ? 0 : this.productInAtiSelect;
    }

    public void setProductInAtiSelect(Integer productInAtiSelect) {
        this.productInAtiSelect = productInAtiSelect;
    }

    public Integer getNbDecimalDigitForUnitPrice() {
        return this.nbDecimalDigitForUnitPrice == null ? 0 : this.nbDecimalDigitForUnitPrice;
    }

    public void setNbDecimalDigitForUnitPrice(Integer nbDecimalDigitForUnitPrice) {
        this.nbDecimalDigitForUnitPrice = nbDecimalDigitForUnitPrice;
    }

    public Integer getComputeMethodDiscountSelect() {
        return this.computeMethodDiscountSelect == null ? 0 : this.computeMethodDiscountSelect;
    }

    public void setComputeMethodDiscountSelect(Integer computeMethodDiscountSelect) {
        this.computeMethodDiscountSelect = computeMethodDiscountSelect;
    }

    public String getTimeLoggingPreferenceSelect() {
        return this.timeLoggingPreferenceSelect;
    }

    public void setTimeLoggingPreferenceSelect(String timeLoggingPreferenceSelect) {
        this.timeLoggingPreferenceSelect = timeLoggingPreferenceSelect;
    }

    public BigDecimal getDailyWorkHours() {
        return this.dailyWorkHours == null ? BigDecimal.ZERO : this.dailyWorkHours;
    }

    public void setDailyWorkHours(BigDecimal dailyWorkHours) {
        this.dailyWorkHours = dailyWorkHours;
    }

    public Unit getUnitDays() {
        return this.unitDays;
    }

    public void setUnitDays(Unit unitDays) {
        this.unitDays = unitDays;
    }

    public Unit getUnitHours() {
        return this.unitHours;
    }

    public void setUnitHours(Unit unitHours) {
        this.unitHours = unitHours;
    }

    public Unit getUnitMinutes() {
        return this.unitMinutes;
    }

    public void setUnitMinutes(Unit unitMinutes) {
        this.unitMinutes = unitMinutes;
    }

    public Boolean getTeamManagement() {
        return this.teamManagement == null ? Boolean.FALSE : this.teamManagement;
    }

    public void setTeamManagement(Boolean teamManagement) {
        this.teamManagement = teamManagement;
    }

    public Boolean getActivateSendingEmail() {
        return this.activateSendingEmail == null ? Boolean.FALSE : this.activateSendingEmail;
    }

    public void setActivateSendingEmail(Boolean activateSendingEmail) {
        this.activateSendingEmail = activateSendingEmail;
    }

    public Boolean getPurchaseOrderManagement() {
        return this.purchaseOrderManagement == null ? Boolean.FALSE : this.purchaseOrderManagement;
    }

    public void setPurchaseOrderManagement(Boolean purchaseOrderManagement) {
        this.purchaseOrderManagement = purchaseOrderManagement;
    }

    public Boolean getManagePurchaseOrderVersion() {
        return this.managePurchaseOrderVersion == null ? Boolean.FALSE : this.managePurchaseOrderVersion;
    }

    public void setManagePurchaseOrderVersion(Boolean managePurchaseOrderVersion) {
        this.managePurchaseOrderVersion = managePurchaseOrderVersion;
    }

    public Boolean getPurchaseOrderGenerationAuto() {
        return this.purchaseOrderGenerationAuto == null ? Boolean.FALSE : this.purchaseOrderGenerationAuto;
    }

    public void setPurchaseOrderGenerationAuto(Boolean purchaseOrderGenerationAuto) {
        this.purchaseOrderGenerationAuto = purchaseOrderGenerationAuto;
    }

    public Boolean getManagePurchasesUnits() {
        return this.managePurchasesUnits == null ? Boolean.FALSE : this.managePurchasesUnits;
    }

    public void setManagePurchasesUnits(Boolean managePurchasesUnits) {
        this.managePurchasesUnits = managePurchasesUnits;
    }

    public Boolean getManageSaleOrderVersion() {
        return this.manageSaleOrderVersion == null ? Boolean.FALSE : this.manageSaleOrderVersion;
    }

    public void setManageSaleOrderVersion(Boolean manageSaleOrderVersion) {
        this.manageSaleOrderVersion = manageSaleOrderVersion;
    }

    public Boolean getGenerateInvoiceFromSaleOrder() {
        return this.generateInvoiceFromSaleOrder == null ? Boolean.FALSE : this.generateInvoiceFromSaleOrder;
    }

    public void setGenerateInvoiceFromSaleOrder(Boolean generateInvoiceFromSaleOrder) {
        this.generateInvoiceFromSaleOrder = generateInvoiceFromSaleOrder;
    }

    public Boolean getAllowTimetableInvoicing() {
        return this.allowTimetableInvoicing == null ? Boolean.FALSE : this.allowTimetableInvoicing;
    }

    public void setAllowTimetableInvoicing(Boolean allowTimetableInvoicing) {
        this.allowTimetableInvoicing = allowTimetableInvoicing;
    }

    public Boolean getManageSalesUnits() {
        return this.manageSalesUnits == null ? Boolean.FALSE : this.manageSalesUnits;
    }

    public void setManageSalesUnits(Boolean manageSalesUnits) {
        this.manageSalesUnits = manageSalesUnits;
    }

    public Boolean getIsInvoiceMoveConsolidated() {
        return this.isInvoiceMoveConsolidated == null ? Boolean.FALSE : this.isInvoiceMoveConsolidated;
    }

    public void setIsInvoiceMoveConsolidated(Boolean isInvoiceMoveConsolidated) {
        this.isInvoiceMoveConsolidated = isInvoiceMoveConsolidated;
    }

    public InterbankCode getTransferAndDirectDebitInterbankCode() {
        return this.transferAndDirectDebitInterbankCode;
    }

    public void setTransferAndDirectDebitInterbankCode(InterbankCode transferAndDirectDebitInterbankCode) {
        this.transferAndDirectDebitInterbankCode = transferAndDirectDebitInterbankCode;
    }

    public InterbankCode getChequeInterbankCode() {
        return this.chequeInterbankCode;
    }

    public void setChequeInterbankCode(InterbankCode chequeInterbankCode) {
        this.chequeInterbankCode = chequeInterbankCode;
    }

    public List<PayerQualityConfigLine> getPayerQualityConfigLineList() {
        return this.payerQualityConfigLineList;
    }

    public void setPayerQualityConfigLineList(List<PayerQualityConfigLine> payerQualityConfigLineList) {
        this.payerQualityConfigLineList = payerQualityConfigLineList;
    }

    public void addPayerQualityConfigLineListItem(PayerQualityConfigLine item) {
        if (this.payerQualityConfigLineList == null) {
            this.payerQualityConfigLineList = new ArrayList<PayerQualityConfigLine>();
        }
        this.payerQualityConfigLineList.add(item);
    }

    public void removePayerQualityConfigLineListItem(PayerQualityConfigLine item) {
        if (this.payerQualityConfigLineList == null) {
            return;
        }
        this.payerQualityConfigLineList.remove(item);
    }

    public void clearPayerQualityConfigLineList() {
        if (this.payerQualityConfigLineList != null) {
            this.payerQualityConfigLineList.clear();
        }
    }

    public Tax getDefaultExemptionTax() {
        return this.defaultExemptionTax;
    }

    public void setDefaultExemptionTax(Tax defaultExemptionTax) {
        this.defaultExemptionTax = defaultExemptionTax;
    }

    public Boolean getManageCustomerCredit() {
        return this.manageCustomerCredit == null ? Boolean.FALSE : this.manageCustomerCredit;
    }

    public void setManageCustomerCredit(Boolean manageCustomerCredit) {
        this.manageCustomerCredit = manageCustomerCredit;
    }

    public Boolean getManageAnalyticAccounting() {
        return this.manageAnalyticAccounting == null ? Boolean.FALSE : this.manageAnalyticAccounting;
    }

    public void setManageAnalyticAccounting(Boolean manageAnalyticAccounting) {
        this.manageAnalyticAccounting = manageAnalyticAccounting;
    }

    public Integer getAnalyticDistributionTypeSelect() {
        return this.analyticDistributionTypeSelect == null ? 0 : this.analyticDistributionTypeSelect;
    }

    public void setAnalyticDistributionTypeSelect(Integer analyticDistributionTypeSelect) {
        this.analyticDistributionTypeSelect = analyticDistributionTypeSelect;
    }

    public Boolean getManageBudget() {
        return this.manageBudget == null ? Boolean.FALSE : this.manageBudget;
    }

    public void setManageBudget(Boolean manageBudget) {
        this.manageBudget = manageBudget;
    }

    public Boolean getManageMultiBudget() {
        return this.manageMultiBudget == null ? Boolean.FALSE : this.manageMultiBudget;
    }

    public void setManageMultiBudget(Boolean manageMultiBudget) {
        this.manageMultiBudget = manageMultiBudget;
    }

    public String getBudgetStatusSelect() {
        return this.budgetStatusSelect;
    }

    public void setBudgetStatusSelect(String budgetStatusSelect) {
        this.budgetStatusSelect = budgetStatusSelect;
    }

    public Boolean getManageDirectDebitPayment() {
        return this.manageDirectDebitPayment == null ? Boolean.FALSE : this.manageDirectDebitPayment;
    }

    public void setManageDirectDebitPayment(Boolean manageDirectDebitPayment) {
        this.manageDirectDebitPayment = manageDirectDebitPayment;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getManageInvoicedAmountByLine() {
        return this.manageInvoicedAmountByLine == null ? Boolean.FALSE : this.manageInvoicedAmountByLine;
    }

    public void setManageInvoicedAmountByLine(Boolean manageInvoicedAmountByLine) {
        this.manageInvoicedAmountByLine = manageInvoicedAmountByLine;
    }

    public Boolean getCustomerStockMoveManagement() {
        return this.customerStockMoveManagement == null ? Boolean.FALSE : this.customerStockMoveManagement;
    }

    public void setCustomerStockMoveManagement(Boolean customerStockMoveManagement) {
        this.customerStockMoveManagement = customerStockMoveManagement;
    }

    public Boolean getCustomerStockMoveGenerationAuto() {
        return this.customerStockMoveGenerationAuto == null ? Boolean.FALSE : this.customerStockMoveGenerationAuto;
    }

    public void setCustomerStockMoveGenerationAuto(Boolean customerStockMoveGenerationAuto) {
        this.customerStockMoveGenerationAuto = customerStockMoveGenerationAuto;
    }

    public Boolean getSupplierStockMoveManagement() {
        return this.supplierStockMoveManagement == null ? Boolean.FALSE : this.supplierStockMoveManagement;
    }

    public void setSupplierStockMoveManagement(Boolean supplierStockMoveManagement) {
        this.supplierStockMoveManagement = supplierStockMoveManagement;
    }

    public Boolean getSupplierStockMoveGenerationAuto() {
        return this.supplierStockMoveGenerationAuto == null ? Boolean.FALSE : this.supplierStockMoveGenerationAuto;
    }

    public void setSupplierStockMoveGenerationAuto(Boolean supplierStockMoveGenerationAuto) {
        this.supplierStockMoveGenerationAuto = supplierStockMoveGenerationAuto;
    }

    public Boolean getAllowSusbcriptionSaleOrder() {
        return this.allowSusbcriptionSaleOrder == null ? Boolean.FALSE : this.allowSusbcriptionSaleOrder;
    }

    public void setAllowSusbcriptionSaleOrder(Boolean allowSusbcriptionSaleOrder) {
        this.allowSusbcriptionSaleOrder = allowSusbcriptionSaleOrder;
    }

    public Boolean getGenerateInvoiceFromStockMove() {
        return this.generateInvoiceFromStockMove == null ? Boolean.FALSE : this.generateInvoiceFromStockMove;
    }

    public void setGenerateInvoiceFromStockMove(Boolean generateInvoiceFromStockMove) {
        this.generateInvoiceFromStockMove = generateInvoiceFromStockMove;
    }

    public Boolean getTerminateSaleOrderOnDelivery() {
        return this.terminateSaleOrderOnDelivery == null ? Boolean.FALSE : this.terminateSaleOrderOnDelivery;
    }

    public void setTerminateSaleOrderOnDelivery(Boolean terminateSaleOrderOnDelivery) {
        this.terminateSaleOrderOnDelivery = terminateSaleOrderOnDelivery;
    }

    public Boolean getTerminatePurchaseOrderOnReceipt() {
        return this.terminatePurchaseOrderOnReceipt == null ? Boolean.FALSE : this.terminatePurchaseOrderOnReceipt;
    }

    public void setTerminatePurchaseOrderOnReceipt(Boolean terminatePurchaseOrderOnReceipt) {
        this.terminatePurchaseOrderOnReceipt = terminatePurchaseOrderOnReceipt;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof General)) {
            return false;
        }
        General other = (General)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("today", (Object)this.getToday());
        tsh.add("defaultPartnerLanguage", (Object)this.getDefaultPartnerLanguage());
        tsh.add("mailAccountByUser", (Object)this.getMailAccountByUser());
        tsh.add("qasWsdlUrl", (Object)this.getQasWsdlUrl());
        tsh.add("mapApiSelect", (Object)this.getMapApiSelect());
        tsh.add("currencyWsURL", (Object)this.getCurrencyWsURL());
        tsh.add("hasQasValidation", (Object)this.getHasQasValidation());
        tsh.add("productInAtiSelect", (Object)this.getProductInAtiSelect());
        tsh.add("nbDecimalDigitForUnitPrice", (Object)this.getNbDecimalDigitForUnitPrice());
        tsh.add("computeMethodDiscountSelect", (Object)this.getComputeMethodDiscountSelect());
        return tsh.omitNullValues().toString();
    }
}

