/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@Entity
@Cacheable
@Table(name="BASE_YEAR")
public class Year
extends AuditableModel {
    private Integer importId = 0;
    @Widget(title="Name")
    @NotNull
    @Index(name="BASE_YEAR_NAME_IDX")
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="From")
    @NotNull
    private LocalDate fromDate;
    @Widget(title="To")
    @NotNull
    private LocalDate toDate;
    @Widget(title="Periods list", help="true")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="year", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Period> periodList;
    @Widget(title="Company")
    @Index(name="BASE_YEAR_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Status", help="true", readonly=true, selection="base.year.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Period duration", selection="account.year.period.duration.select")
    private Integer periodDurationSelect = 0;
    @Widget(title="Type", help="true", selection="account.year.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_YEAR_SEQ")
    @SequenceGenerator(name="BASE_YEAR_SEQ", sequenceName="BASE_YEAR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reported balance Date")
    private LocalDate reportedBalanceDate;
    @Widget(title="Closure date")
    private LocalDateTime closureDateTime;

    public Year() {
    }

    public Year(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    public void addPeriodListItem(Period item) {
        if (this.periodList == null) {
            this.periodList = new ArrayList<Period>();
        }
        this.periodList.add(item);
        item.setYear(this);
    }

    public void removePeriodListItem(Period item) {
        if (this.periodList == null) {
            return;
        }
        this.periodList.remove(item);
    }

    public void clearPeriodList() {
        if (this.periodList != null) {
            this.periodList.clear();
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getPeriodDurationSelect() {
        return this.periodDurationSelect == null ? 0 : this.periodDurationSelect;
    }

    public void setPeriodDurationSelect(Integer periodDurationSelect) {
        this.periodDurationSelect = periodDurationSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getReportedBalanceDate() {
        return this.reportedBalanceDate;
    }

    public void setReportedBalanceDate(LocalDate reportedBalanceDate) {
        this.reportedBalanceDate = reportedBalanceDate;
    }

    public LocalDateTime getClosureDateTime() {
        return this.closureDateTime;
    }

    public void setClosureDateTime(LocalDateTime closureDateTime) {
        this.closureDateTime = closureDateTime;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Year)) {
            return false;
        }
        Year other = (Year)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(2751581, this.getCode());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("name", (Object)this.getName());
        tsh.add("code", (Object)this.getCode());
        tsh.add("fromDate", (Object)this.getFromDate());
        tsh.add("toDate", (Object)this.getToDate());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        tsh.add("periodDurationSelect", (Object)this.getPeriodDurationSelect());
        tsh.add("typeSelect", (Object)this.getTypeSelect());
        tsh.add("reportedBalanceDate", (Object)this.getReportedBalanceDate());
        tsh.add("closureDateTime", (Object)this.getClosureDateTime());
        return tsh.omitNullValues().toString();
    }
}

