/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Table(name="MESSAGE_MAIL_ACCOUNT")
public class MailAccount
extends AuditableModel {
    @Widget(title="Name")
    @NameColumn
    @NotNull
    @Index(name="MESSAGE_MAIL_ACCOUNT_NAME_IDX")
    private String name;
    @Widget(title="Server Type", help="true", selection="mail.account.server.type.select")
    @NotNull
    private Integer serverTypeSelect = 1;
    @Widget(title="Login", help="true")
    private String login;
    @Widget(title="Password")
    private String password;
    @Widget(title="Host", help="true")
    @NotNull
    private String host;
    @Widget(title="Port")
    @Min(value=1L)
    private Integer port;
    @Widget(title="SSL/STARTTLS", help="true", selection="mail.account.security.select")
    private Integer securitySelect = 0;
    @Widget(title="Default account ?", help="true")
    private Boolean isDefault = Boolean.FALSE;
    @Widget(title="Valid ?", help="true")
    private Boolean isValid = Boolean.FALSE;
    @Widget(title="Signature")
    private String signature;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_MAIL_ACCOUNT_SEQ")
    @SequenceGenerator(name="MESSAGE_MAIL_ACCOUNT_SEQ", sequenceName="MESSAGE_MAIL_ACCOUNT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User")
    @Index(name="MESSAGE_MAIL_ACCOUNT_USER_ID_IDX")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;

    public MailAccount() {
    }

    public MailAccount(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getServerTypeSelect() {
        return this.serverTypeSelect == null ? 0 : this.serverTypeSelect;
    }

    public void setServerTypeSelect(Integer serverTypeSelect) {
        this.serverTypeSelect = serverTypeSelect;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getSecuritySelect() {
        return this.securitySelect == null ? 0 : this.securitySelect;
    }

    public void setSecuritySelect(Integer securitySelect) {
        this.securitySelect = securitySelect;
    }

    public Boolean getIsDefault() {
        return this.isDefault == null ? Boolean.FALSE : this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsValid() {
        return this.isValid == null ? Boolean.FALSE : this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailAccount)) {
            return false;
        }
        MailAccount other = (MailAccount)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("serverTypeSelect", (Object)this.getServerTypeSelect());
        tsh.add("login", (Object)this.getLogin());
        tsh.add("password", (Object)this.getPassword());
        tsh.add("host", (Object)this.getHost());
        tsh.add("port", (Object)this.getPort());
        tsh.add("securitySelect", (Object)this.getSecuritySelect());
        tsh.add("isDefault", (Object)this.getIsDefault());
        tsh.add("isValid", (Object)this.getIsValid());
        tsh.add("signature", (Object)this.getSignature());
        return tsh.omitNullValues().toString();
    }
}

