/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.purchase.db;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="PURCHASE_PURCHASE_ORDER_LINE")
public class PurchaseOrderLine
extends AuditableModel {
    private Integer importId = 0;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_FULL_NAME_IDX")
    private String fullName;
    @Widget(title="Purchase order")
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_PURCHASE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrder purchaseOrder;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Product")
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = new BigDecimal("1");
    @Widget(title="Displayed Product name")
    @NotNull
    private String productName;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Tax")
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_TAX_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Subtotal W.T.")
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Unit")
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Discount Type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 3;
    @Widget(title="Ordered ?")
    private Boolean isOrdered = Boolean.FALSE;
    @Widget(title="Min sale price")
    @Digits(integer=10, fraction=10)
    private BigDecimal saleMinPrice = BigDecimal.ZERO;
    @Widget(title="Estim. delivery date", help="true")
    private LocalDate estimatedDelivDate;
    @Widget(title="Desired delivery date")
    private LocalDate desiredDelivDate;
    @Widget(title="Total W.T. in company currency", hidden=true)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I. in company currency", hidden=true)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Digits(integer=10, fraction=10)
    private BigDecimal salePrice = BigDecimal.ZERO;
    @Widget(title="Title Line")
    private Boolean isTitleLine = Boolean.FALSE;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PURCHASE_PURCHASE_ORDER_LINE_SEQ")
    @SequenceGenerator(name="PURCHASE_PURCHASE_ORDER_LINE_SEQ", sequenceName="PURCHASE_PURCHASE_ORDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Amount invoiced W.T.", readonly=true)
    private BigDecimal amountInvoiced = BigDecimal.ZERO;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseOrderLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticDistributionLine> analyticDistributionLineList;
    @Widget(title="Analytic distribution template")
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_ANALYTIC_DISTRIBUTION_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    private Boolean toInvoice = Boolean.FALSE;
    @Widget(readonly=true)
    private Boolean invoiced = Boolean.FALSE;
    @Widget(title="Budget")
    @Index(name="PURCHASE_PURCHASE_ORDER_LINE_BUDGET_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Budget budget;
    @Widget(title="Budget Distribution")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="purchaseOrderLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BudgetDistribution> budgetDistributionList;

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.purchaseOrder != null && this.purchaseOrder.getPurchaseOrderSeq() != null) {
            fullName = fullName + this.purchaseOrder.getPurchaseOrderSeq();
        }
        if (this.productName != null) {
            fullName = fullName + "-";
            fullName = this.productName.length() > 100 ? fullName + this.productName.substring(1, 100) : fullName + this.productName;
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public PurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public Boolean getIsOrdered() {
        return this.isOrdered == null ? Boolean.FALSE : this.isOrdered;
    }

    public void setIsOrdered(Boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public BigDecimal getSaleMinPrice() {
        return this.saleMinPrice == null ? BigDecimal.ZERO : this.saleMinPrice;
    }

    public void setSaleMinPrice(BigDecimal saleMinPrice) {
        this.saleMinPrice = saleMinPrice;
    }

    public LocalDate getEstimatedDelivDate() {
        return this.estimatedDelivDate;
    }

    public void setEstimatedDelivDate(LocalDate estimatedDelivDate) {
        this.estimatedDelivDate = estimatedDelivDate;
    }

    public LocalDate getDesiredDelivDate() {
        return this.desiredDelivDate;
    }

    public void setDesiredDelivDate(LocalDate desiredDelivDate) {
        this.desiredDelivDate = desiredDelivDate;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice == null ? BigDecimal.ZERO : this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Boolean getIsTitleLine() {
        return this.isTitleLine == null ? Boolean.FALSE : this.isTitleLine;
    }

    public void setIsTitleLine(Boolean isTitleLine) {
        this.isTitleLine = isTitleLine;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmountInvoiced() {
        return this.amountInvoiced == null ? BigDecimal.ZERO : this.amountInvoiced;
    }

    public void setAmountInvoiced(BigDecimal amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
    }

    public List<AnalyticDistributionLine> getAnalyticDistributionLineList() {
        return this.analyticDistributionLineList;
    }

    public void setAnalyticDistributionLineList(List<AnalyticDistributionLine> analyticDistributionLineList) {
        this.analyticDistributionLineList = analyticDistributionLineList;
    }

    public void addAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.analyticDistributionLineList == null) {
            this.analyticDistributionLineList = new ArrayList<AnalyticDistributionLine>();
        }
        this.analyticDistributionLineList.add(item);
        item.setPurchaseOrderLine(this);
    }

    public void removeAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.analyticDistributionLineList == null) {
            return;
        }
        this.analyticDistributionLineList.remove((Object)item);
    }

    public void clearAnalyticDistributionLineList() {
        if (this.analyticDistributionLineList != null) {
            this.analyticDistributionLineList.clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public Boolean getToInvoice() {
        return this.toInvoice == null ? Boolean.FALSE : this.toInvoice;
    }

    public void setToInvoice(Boolean toInvoice) {
        this.toInvoice = toInvoice;
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public List<BudgetDistribution> getBudgetDistributionList() {
        return this.budgetDistributionList;
    }

    public void setBudgetDistributionList(List<BudgetDistribution> budgetDistributionList) {
        this.budgetDistributionList = budgetDistributionList;
    }

    public void addBudgetDistributionListItem(BudgetDistribution item) {
        if (this.budgetDistributionList == null) {
            this.budgetDistributionList = new ArrayList<BudgetDistribution>();
        }
        this.budgetDistributionList.add(item);
        item.setPurchaseOrderLine(this);
    }

    public void removeBudgetDistributionListItem(BudgetDistribution item) {
        if (this.budgetDistributionList == null) {
            return;
        }
        this.budgetDistributionList.remove((Object)item);
    }

    public void clearBudgetDistributionList() {
        if (this.budgetDistributionList != null) {
            this.budgetDistributionList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseOrderLine)) {
            return false;
        }
        PurchaseOrderLine other = (PurchaseOrderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("sequence", (Object)this.getSequence());
        tsh.add("qty", (Object)this.getQty());
        tsh.add("productName", (Object)this.getProductName());
        tsh.add("price", (Object)this.getPrice());
        tsh.add("priceDiscounted", (Object)this.getPriceDiscounted());
        tsh.add("exTaxTotal", (Object)this.getExTaxTotal());
        tsh.add("inTaxTotal", (Object)this.getInTaxTotal());
        tsh.add("discountAmount", (Object)this.getDiscountAmount());
        tsh.add("discountTypeSelect", (Object)this.getDiscountTypeSelect());
        tsh.add("isOrdered", (Object)this.getIsOrdered());
        return tsh.omitNullValues().toString();
    }
}

