/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.db.Subscription;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="SALE_SALE_ORDER_LINE")
public class SaleOrderLine
extends AuditableModel {
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @Index(name="SALE_SALE_ORDER_LINE_FULL_NAME_IDX")
    private String fullName;
    @Widget(title="Sale order")
    @Index(name="SALE_SALE_ORDER_LINE_SALE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    private Integer importId = 0;
    @Widget(title="Product")
    @Index(name="SALE_SALE_ORDER_LINE_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = new BigDecimal("1");
    @Widget(title="Print subtotal / line")
    private Boolean isToPrintLineSubTotal = Boolean.FALSE;
    @Widget(title="Displayed Product name")
    @NotNull
    private String productName;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Tax")
    @Index(name="SALE_SALE_ORDER_LINE_TAX_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Total W.T.")
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Unit")
    @Index(name="SALE_SALE_ORDER_LINE_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Supplier")
    @Index(name="SALE_SALE_ORDER_LINE_SUPPLIER_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierPartner;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Discount Type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 3;
    @Widget(title="Estimated delivery date")
    private LocalDate estimatedDelivDate;
    @Widget(title="Delivery date")
    private LocalDate deliveryDate;
    @Widget(title="Total W.T. in company currency", hidden=true)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Unit cost price in company currency", hidden=true)
    private BigDecimal companyCostPrice = BigDecimal.ZERO;
    @Widget(title="Total A.T.I. in company currency", hidden=true)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total cost in company currency", hidden=true)
    private BigDecimal companyCostTotal = BigDecimal.ZERO;
    @Widget(title="Title Line")
    private Boolean isTitleLine = Boolean.FALSE;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_ORDER_LINE_SEQ")
    @SequenceGenerator(name="SALE_SALE_ORDER_LINE_SEQ", sequenceName="SALE_SALE_ORDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Supply method", selection="product.sale.supply.select")
    private Integer saleSupplySelect = 0;
    @Widget(title="Invoicing Date")
    private LocalDate invoicingDate;
    @Widget(title="Amount invoiced W.T.", readonly=true)
    private BigDecimal amountInvoiced = BigDecimal.ZERO;
    @Widget(title="Invoice controlled")
    private Boolean isInvoiceControlled = Boolean.FALSE;
    @Widget(selection="product.periodicity.subscription.select")
    private Integer periodicity = 0;
    @Widget(title="Date From")
    private LocalDate fromSubDate;
    @Widget(title="Number of Periods")
    private Integer periodNumber = 0;
    @Widget(title="Date To")
    private LocalDate toSubDate;
    @Widget(title="Invoicing Type", selection="supplychain.subscription.invoicing.type.select")
    private Integer subscripInvTypeSelect = 0;
    @Widget(title="Subscription List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrderLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Subscription> subscriptionList;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="saleOrderLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticDistributionLine> analyticDistributionLineList;
    @Widget(title="Analytic distribution template")
    @Index(name="SALE_SALE_ORDER_LINE_ANALYTIC_DISTRIBUTION_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    private Boolean toInvoice = Boolean.FALSE;
    @Widget(readonly=true)
    private Boolean invoiced = Boolean.FALSE;

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.saleOrder != null && this.saleOrder.getSaleOrderSeq() != null) {
            fullName = fullName + this.saleOrder.getSaleOrderSeq();
        }
        if (this.productName != null) {
            fullName = fullName + "-";
            fullName = this.productName.length() > 100 ? fullName + this.productName.substring(1, 100) : fullName + this.productName;
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Boolean getIsToPrintLineSubTotal() {
        return this.isToPrintLineSubTotal == null ? Boolean.FALSE : this.isToPrintLineSubTotal;
    }

    public void setIsToPrintLineSubTotal(Boolean isToPrintLineSubTotal) {
        this.isToPrintLineSubTotal = isToPrintLineSubTotal;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Partner getSupplierPartner() {
        return this.supplierPartner;
    }

    public void setSupplierPartner(Partner supplierPartner) {
        this.supplierPartner = supplierPartner;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public LocalDate getEstimatedDelivDate() {
        return this.estimatedDelivDate;
    }

    public void setEstimatedDelivDate(LocalDate estimatedDelivDate) {
        this.estimatedDelivDate = estimatedDelivDate;
    }

    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyCostPrice() {
        return this.companyCostPrice == null ? BigDecimal.ZERO : this.companyCostPrice;
    }

    public void setCompanyCostPrice(BigDecimal companyCostPrice) {
        this.companyCostPrice = companyCostPrice;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public BigDecimal getCompanyCostTotal() {
        return this.companyCostTotal == null ? BigDecimal.ZERO : this.companyCostTotal;
    }

    public void setCompanyCostTotal(BigDecimal companyCostTotal) {
        this.companyCostTotal = companyCostTotal;
    }

    public Boolean getIsTitleLine() {
        return this.isTitleLine == null ? Boolean.FALSE : this.isTitleLine;
    }

    public void setIsTitleLine(Boolean isTitleLine) {
        this.isTitleLine = isTitleLine;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSaleSupplySelect() {
        return this.saleSupplySelect == null ? 0 : this.saleSupplySelect;
    }

    public void setSaleSupplySelect(Integer saleSupplySelect) {
        this.saleSupplySelect = saleSupplySelect;
    }

    public LocalDate getInvoicingDate() {
        return this.invoicingDate;
    }

    public void setInvoicingDate(LocalDate invoicingDate) {
        this.invoicingDate = invoicingDate;
    }

    public BigDecimal getAmountInvoiced() {
        return this.amountInvoiced == null ? BigDecimal.ZERO : this.amountInvoiced;
    }

    public void setAmountInvoiced(BigDecimal amountInvoiced) {
        this.amountInvoiced = amountInvoiced;
    }

    public Boolean getIsInvoiceControlled() {
        return this.isInvoiceControlled == null ? Boolean.FALSE : this.isInvoiceControlled;
    }

    public void setIsInvoiceControlled(Boolean isInvoiceControlled) {
        this.isInvoiceControlled = isInvoiceControlled;
    }

    public Integer getPeriodicity() {
        return this.periodicity == null ? 0 : this.periodicity;
    }

    public void setPeriodicity(Integer periodicity) {
        this.periodicity = periodicity;
    }

    public LocalDate getFromSubDate() {
        return this.fromSubDate;
    }

    public void setFromSubDate(LocalDate fromSubDate) {
        this.fromSubDate = fromSubDate;
    }

    public Integer getPeriodNumber() {
        return this.periodNumber == null ? 0 : this.periodNumber;
    }

    public void setPeriodNumber(Integer periodNumber) {
        this.periodNumber = periodNumber;
    }

    public LocalDate getToSubDate() {
        return this.toSubDate;
    }

    public void setToSubDate(LocalDate toSubDate) {
        this.toSubDate = toSubDate;
    }

    public Integer getSubscripInvTypeSelect() {
        return this.subscripInvTypeSelect == null ? 0 : this.subscripInvTypeSelect;
    }

    public void setSubscripInvTypeSelect(Integer subscripInvTypeSelect) {
        this.subscripInvTypeSelect = subscripInvTypeSelect;
    }

    public List<Subscription> getSubscriptionList() {
        return this.subscriptionList;
    }

    public void setSubscriptionList(List<Subscription> subscriptionList) {
        this.subscriptionList = subscriptionList;
    }

    public void addSubscriptionListItem(Subscription item) {
        if (this.subscriptionList == null) {
            this.subscriptionList = new ArrayList<Subscription>();
        }
        this.subscriptionList.add(item);
        item.setSaleOrderLine(this);
    }

    public void removeSubscriptionListItem(Subscription item) {
        if (this.subscriptionList == null) {
            return;
        }
        this.subscriptionList.remove((Object)item);
    }

    public void clearSubscriptionList() {
        if (this.subscriptionList != null) {
            this.subscriptionList.clear();
        }
    }

    public List<AnalyticDistributionLine> getAnalyticDistributionLineList() {
        return this.analyticDistributionLineList;
    }

    public void setAnalyticDistributionLineList(List<AnalyticDistributionLine> analyticDistributionLineList) {
        this.analyticDistributionLineList = analyticDistributionLineList;
    }

    public void addAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.analyticDistributionLineList == null) {
            this.analyticDistributionLineList = new ArrayList<AnalyticDistributionLine>();
        }
        this.analyticDistributionLineList.add(item);
        item.setSaleOrderLine(this);
    }

    public void removeAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.analyticDistributionLineList == null) {
            return;
        }
        this.analyticDistributionLineList.remove((Object)item);
    }

    public void clearAnalyticDistributionLineList() {
        if (this.analyticDistributionLineList != null) {
            this.analyticDistributionLineList.clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public Boolean getToInvoice() {
        return this.toInvoice == null ? Boolean.FALSE : this.toInvoice;
    }

    public void setToInvoice(Boolean toInvoice) {
        this.toInvoice = toInvoice;
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleOrderLine)) {
            return false;
        }
        SaleOrderLine other = (SaleOrderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("sequence", (Object)this.getSequence());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("qty", (Object)this.getQty());
        tsh.add("isToPrintLineSubTotal", (Object)this.getIsToPrintLineSubTotal());
        tsh.add("productName", (Object)this.getProductName());
        tsh.add("price", (Object)this.getPrice());
        tsh.add("priceDiscounted", (Object)this.getPriceDiscounted());
        tsh.add("exTaxTotal", (Object)this.getExTaxTotal());
        tsh.add("inTaxTotal", (Object)this.getInTaxTotal());
        tsh.add("discountAmount", (Object)this.getDiscountAmount());
        tsh.add("discountTypeSelect", (Object)this.getDiscountTypeSelect());
        return tsh.omitNullValues().toString();
    }
}

