/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Index;

@Entity
@Table(name="SALE_SALE_ORDER_SCHEDULE_LINE")
public class SaleOrderScheduleLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_ORDER_SCHEDULE_LINE_SEQ")
    @SequenceGenerator(name="SALE_SALE_ORDER_SCHEDULE_LINE_SEQ", sequenceName="SALE_SALE_ORDER_SCHEDULE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sale order")
    @Index(name="SALE_SALE_ORDER_SCHEDULE_LINE_SALE_ORDER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Seq.")
    private String sequence;
    @Widget(title="Amount to invoice")
    private BigDecimal amountToBeInvoiced = BigDecimal.ZERO;
    @Widget(title="%")
    private BigDecimal invoicingPercentage = BigDecimal.ZERO;
    @Widget(title="Task", help="true")
    @Index(name="SALE_SALE_ORDER_SCHEDULE_LINE_SALE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Widget(title="Cumulated invoiced %")
    private BigDecimal accumulatedInvoicingPercentage = BigDecimal.ZERO;
    @Widget(title="Nbr of days", help="true")
    private Integer nbOfDay = 0;
    @Widget(title="Invoice")
    @Index(name="SALE_SALE_ORDER_SCHEDULE_LINE_INVOICE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public BigDecimal getAmountToBeInvoiced() {
        return this.amountToBeInvoiced == null ? BigDecimal.ZERO : this.amountToBeInvoiced;
    }

    public void setAmountToBeInvoiced(BigDecimal amountToBeInvoiced) {
        this.amountToBeInvoiced = amountToBeInvoiced;
    }

    public BigDecimal getInvoicingPercentage() {
        return this.invoicingPercentage == null ? BigDecimal.ZERO : this.invoicingPercentage;
    }

    public void setInvoicingPercentage(BigDecimal invoicingPercentage) {
        this.invoicingPercentage = invoicingPercentage;
    }

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public BigDecimal getAccumulatedInvoicingPercentage() {
        return this.accumulatedInvoicingPercentage == null ? BigDecimal.ZERO : this.accumulatedInvoicingPercentage;
    }

    public void setAccumulatedInvoicingPercentage(BigDecimal accumulatedInvoicingPercentage) {
        this.accumulatedInvoicingPercentage = accumulatedInvoicingPercentage;
    }

    public Integer getNbOfDay() {
        return this.nbOfDay == null ? 0 : this.nbOfDay;
    }

    public void setNbOfDay(Integer nbOfDay) {
        this.nbOfDay = nbOfDay;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleOrderScheduleLine)) {
            return false;
        }
        SaleOrderScheduleLine other = (SaleOrderScheduleLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("sequence", (Object)this.getSequence());
        tsh.add("amountToBeInvoiced", (Object)this.getAmountToBeInvoiced());
        tsh.add("invoicingPercentage", (Object)this.getInvoicingPercentage());
        tsh.add("accumulatedInvoicingPercentage", (Object)this.getAccumulatedInvoicingPercentage());
        tsh.add("nbOfDay", (Object)this.getNbOfDay());
        return tsh.omitNullValues().toString();
    }
}

