/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.TrackingNumber;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;

@Entity
@Table(name="STOCK_STOCK_MOVE_LINE")
public class StockMoveLine
extends AuditableModel {
    @Widget(title="Stock move")
    @Index(name="STOCK_STOCK_MOVE_LINE_STOCK_MOVE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove stockMove;
    private Integer importId = 0;
    @Widget(title="Product")
    @Index(name="STOCK_STOCK_MOVE_LINE_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Expected Qty")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Real Qty")
    private BigDecimal realQty = BigDecimal.ZERO;
    @Widget(title="Unit")
    @Index(name="STOCK_STOCK_MOVE_LINE_UNIT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Tracking Nbr.")
    @Index(name="STOCK_STOCK_MOVE_LINE_TRACKING_NUMBER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrackingNumber trackingNumber;
    @Widget(title="Accordance", selection="stock.move.line.accordance.select")
    private Integer accordanceSelect = 0;
    @Widget(title="Shipped qty")
    private BigDecimal shippedQty = BigDecimal.ZERO;
    @Widget(title="Shipped date")
    private LocalDate shippedDate;
    @Widget(title="Product model")
    @Index(name="STOCK_STOCK_MOVE_LINE_PRODUCT_MODEL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product productModel;
    @Widget(title="Title")
    @NotNull
    private String productName;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal unitPriceUntaxed = BigDecimal.ZERO;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal unitPriceTaxed = BigDecimal.ZERO;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_MOVE_LINE_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_MOVE_LINE_SEQ", sequenceName="STOCK_STOCK_MOVE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sales order line")
    @Index(name="STOCK_STOCK_MOVE_LINE_SALE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Widget(title="Purchase order line")
    @Index(name="STOCK_STOCK_MOVE_LINE_PURCHASE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrderLine purchaseOrderLine;

    public StockMove getStockMove() {
        return this.stockMove;
    }

    public void setStockMove(StockMove stockMove) {
        this.stockMove = stockMove;
    }

    public Integer getImportId() {
        return this.importId == null ? 0 : this.importId;
    }

    public void setImportId(Integer importId) {
        this.importId = importId;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getRealQty() {
        return this.realQty == null ? BigDecimal.ZERO : this.realQty;
    }

    public void setRealQty(BigDecimal realQty) {
        this.realQty = realQty;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public TrackingNumber getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(TrackingNumber trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Integer getAccordanceSelect() {
        return this.accordanceSelect == null ? 0 : this.accordanceSelect;
    }

    public void setAccordanceSelect(Integer accordanceSelect) {
        this.accordanceSelect = accordanceSelect;
    }

    public BigDecimal getShippedQty() {
        return this.shippedQty == null ? BigDecimal.ZERO : this.shippedQty;
    }

    public void setShippedQty(BigDecimal shippedQty) {
        this.shippedQty = shippedQty;
    }

    public LocalDate getShippedDate() {
        return this.shippedDate;
    }

    public void setShippedDate(LocalDate shippedDate) {
        this.shippedDate = shippedDate;
    }

    public Product getProductModel() {
        return this.productModel;
    }

    public void setProductModel(Product productModel) {
        this.productModel = productModel;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getUnitPriceUntaxed() {
        return this.unitPriceUntaxed == null ? BigDecimal.ZERO : this.unitPriceUntaxed;
    }

    public void setUnitPriceUntaxed(BigDecimal unitPriceUntaxed) {
        this.unitPriceUntaxed = unitPriceUntaxed;
    }

    public BigDecimal getUnitPriceTaxed() {
        return this.unitPriceTaxed == null ? BigDecimal.ZERO : this.unitPriceTaxed;
    }

    public void setUnitPriceTaxed(BigDecimal unitPriceTaxed) {
        this.unitPriceTaxed = unitPriceTaxed;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public PurchaseOrderLine getPurchaseOrderLine() {
        return this.purchaseOrderLine;
    }

    public void setPurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        this.purchaseOrderLine = purchaseOrderLine;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockMoveLine)) {
            return false;
        }
        StockMoveLine other = (StockMoveLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("importId", (Object)this.getImportId());
        tsh.add("qty", (Object)this.getQty());
        tsh.add("realQty", (Object)this.getRealQty());
        tsh.add("accordanceSelect", (Object)this.getAccordanceSelect());
        tsh.add("shippedQty", (Object)this.getShippedQty());
        tsh.add("shippedDate", (Object)this.getShippedDate());
        tsh.add("productName", (Object)this.getProductName());
        tsh.add("unitPriceUntaxed", (Object)this.getUnitPriceUntaxed());
        tsh.add("unitPriceTaxed", (Object)this.getUnitPriceTaxed());
        return tsh.omitNullValues().toString();
    }
}

