/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Table(name="SUPPLYCHAIN_CUSTOMER_CREDIT_LINE")
public class CustomerCreditLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_CUSTOMER_CREDIT_LINE_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_CUSTOMER_CREDIT_LINE_SEQ", sequenceName="SUPPLYCHAIN_CUSTOMER_CREDIT_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @NotNull
    @Index(name="SUPPLYCHAIN_CUSTOMER_CREDIT_LINE_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Accepted Credit")
    @NotNull
    @Digits(integer=18, fraction=2)
    private BigDecimal acceptedCredit = BigDecimal.ZERO;
    @Widget(title="Encours utilis\u00e9", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal usedCredit = BigDecimal.ZERO;
    @Index(name="SUPPLYCHAIN_CUSTOMER_CREDIT_LINE_PARTNER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BigDecimal getAcceptedCredit() {
        return this.acceptedCredit == null ? BigDecimal.ZERO : this.acceptedCredit;
    }

    public void setAcceptedCredit(BigDecimal acceptedCredit) {
        this.acceptedCredit = acceptedCredit;
    }

    public BigDecimal getUsedCredit() {
        return this.usedCredit == null ? BigDecimal.ZERO : this.usedCredit;
    }

    public void setUsedCredit(BigDecimal usedCredit) {
        this.usedCredit = usedCredit;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomerCreditLine)) {
            return false;
        }
        CustomerCreditLine other = (CustomerCreditLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("acceptedCredit", (Object)this.getAcceptedCredit());
        tsh.add("usedCredit", (Object)this.getUsedCredit());
        return tsh.omitNullValues().toString();
    }
}

