/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.supplychain.db.MrpForecast;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;

@Entity
@Table(name="SUPPLYCHAIN_MRP")
public class Mrp
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_MRP_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_MRP_SEQ", sequenceName="SUPPLYCHAIN_MRP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Location")
    @NotNull
    @Index(name="SUPPLYCHAIN_MRP_LOCATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Location location;
    @Widget(title="Products")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Product categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductCategory> productCategorySet;
    @Widget(title="Product families")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductFamily> productFamilySet;
    @Widget(title="Sale orders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<SaleOrderLine> saleOrderLineSet;
    @Widget(title="Forecasts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MrpForecast> mrpForecastSet;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Status", selection="supplychain.mrp.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Results")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="mrp", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MrpLine> mrpLineList;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.productSet == null) {
            this.productSet = new HashSet<Product>();
        }
        this.productSet.add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.productSet == null) {
            return;
        }
        this.productSet.remove((Object)item);
    }

    public void clearProductSet() {
        if (this.productSet != null) {
            this.productSet.clear();
        }
    }

    public Set<ProductCategory> getProductCategorySet() {
        return this.productCategorySet;
    }

    public void setProductCategorySet(Set<ProductCategory> productCategorySet) {
        this.productCategorySet = productCategorySet;
    }

    public void addProductCategorySetItem(ProductCategory item) {
        if (this.productCategorySet == null) {
            this.productCategorySet = new HashSet<ProductCategory>();
        }
        this.productCategorySet.add(item);
    }

    public void removeProductCategorySetItem(ProductCategory item) {
        if (this.productCategorySet == null) {
            return;
        }
        this.productCategorySet.remove(item);
    }

    public void clearProductCategorySet() {
        if (this.productCategorySet != null) {
            this.productCategorySet.clear();
        }
    }

    public Set<ProductFamily> getProductFamilySet() {
        return this.productFamilySet;
    }

    public void setProductFamilySet(Set<ProductFamily> productFamilySet) {
        this.productFamilySet = productFamilySet;
    }

    public void addProductFamilySetItem(ProductFamily item) {
        if (this.productFamilySet == null) {
            this.productFamilySet = new HashSet<ProductFamily>();
        }
        this.productFamilySet.add(item);
    }

    public void removeProductFamilySetItem(ProductFamily item) {
        if (this.productFamilySet == null) {
            return;
        }
        this.productFamilySet.remove(item);
    }

    public void clearProductFamilySet() {
        if (this.productFamilySet != null) {
            this.productFamilySet.clear();
        }
    }

    public Set<SaleOrderLine> getSaleOrderLineSet() {
        return this.saleOrderLineSet;
    }

    public void setSaleOrderLineSet(Set<SaleOrderLine> saleOrderLineSet) {
        this.saleOrderLineSet = saleOrderLineSet;
    }

    public void addSaleOrderLineSetItem(SaleOrderLine item) {
        if (this.saleOrderLineSet == null) {
            this.saleOrderLineSet = new HashSet<SaleOrderLine>();
        }
        this.saleOrderLineSet.add(item);
    }

    public void removeSaleOrderLineSetItem(SaleOrderLine item) {
        if (this.saleOrderLineSet == null) {
            return;
        }
        this.saleOrderLineSet.remove((Object)item);
    }

    public void clearSaleOrderLineSet() {
        if (this.saleOrderLineSet != null) {
            this.saleOrderLineSet.clear();
        }
    }

    public Set<MrpForecast> getMrpForecastSet() {
        return this.mrpForecastSet;
    }

    public void setMrpForecastSet(Set<MrpForecast> mrpForecastSet) {
        this.mrpForecastSet = mrpForecastSet;
    }

    public void addMrpForecastSetItem(MrpForecast item) {
        if (this.mrpForecastSet == null) {
            this.mrpForecastSet = new HashSet<MrpForecast>();
        }
        this.mrpForecastSet.add(item);
    }

    public void removeMrpForecastSetItem(MrpForecast item) {
        if (this.mrpForecastSet == null) {
            return;
        }
        this.mrpForecastSet.remove((Object)item);
    }

    public void clearMrpForecastSet() {
        if (this.mrpForecastSet != null) {
            this.mrpForecastSet.clear();
        }
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public List<MrpLine> getMrpLineList() {
        return this.mrpLineList;
    }

    public void setMrpLineList(List<MrpLine> mrpLineList) {
        this.mrpLineList = mrpLineList;
    }

    public void addMrpLineListItem(MrpLine item) {
        if (this.mrpLineList == null) {
            this.mrpLineList = new ArrayList<MrpLine>();
        }
        this.mrpLineList.add(item);
        item.setMrp(this);
    }

    public void removeMrpLineListItem(MrpLine item) {
        if (this.mrpLineList == null) {
            return;
        }
        this.mrpLineList.remove((Object)item);
    }

    public void clearMrpLineList() {
        if (this.mrpLineList != null) {
            this.mrpLineList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mrp)) {
            return false;
        }
        Mrp other = (Mrp)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("endDate", (Object)this.getEndDate());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        return tsh.omitNullValues().toString();
    }
}

