/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpLineOrigin;
import com.axelor.apps.supplychain.db.MrpLineType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;

@Entity
@Table(name="SUPPLYCHAIN_MRP_LINE")
public class MrpLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_MRP_LINE_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_MRP_LINE_SEQ", sequenceName="SUPPLYCHAIN_MRP_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Mrp")
    @Index(name="SUPPLYCHAIN_MRP_LINE_MRP_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Mrp mrp;
    @Widget(title="Location")
    @Index(name="SUPPLYCHAIN_MRP_LINE_LOCATION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Location location;
    @Widget(title="Product")
    @Index(name="SUPPLYCHAIN_MRP_LINE_PRODUCT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Cumulative qty")
    private BigDecimal cumulativeQty = BigDecimal.ZERO;
    @Widget(title="Type")
    @Index(name="SUPPLYCHAIN_MRP_LINE_MRP_LINE_TYPE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MrpLineType mrpLineType;
    @Widget(title="Maturity")
    private LocalDate maturityDate;
    @Widget(title="Maximum level")
    private Integer maxLevel = 0;
    @Widget(title="Min qty")
    private BigDecimal minQty = BigDecimal.ZERO;
    @Widget(title="Related to")
    private String relatedToSelectName;
    @Widget(title="Origins")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="mrpLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MrpLineOrigin> mrpLineOriginList;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Mrp getMrp() {
        return this.mrp;
    }

    public void setMrp(Mrp mrp) {
        this.mrp = mrp;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getCumulativeQty() {
        return this.cumulativeQty == null ? BigDecimal.ZERO : this.cumulativeQty;
    }

    public void setCumulativeQty(BigDecimal cumulativeQty) {
        this.cumulativeQty = cumulativeQty;
    }

    public MrpLineType getMrpLineType() {
        return this.mrpLineType;
    }

    public void setMrpLineType(MrpLineType mrpLineType) {
        this.mrpLineType = mrpLineType;
    }

    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(LocalDate maturityDate) {
        this.maturityDate = maturityDate;
    }

    public Integer getMaxLevel() {
        return this.maxLevel == null ? 0 : this.maxLevel;
    }

    public void setMaxLevel(Integer maxLevel) {
        this.maxLevel = maxLevel;
    }

    public BigDecimal getMinQty() {
        return this.minQty == null ? BigDecimal.ZERO : this.minQty;
    }

    public void setMinQty(BigDecimal minQty) {
        this.minQty = minQty;
    }

    public String getRelatedToSelectName() {
        return this.relatedToSelectName;
    }

    public void setRelatedToSelectName(String relatedToSelectName) {
        this.relatedToSelectName = relatedToSelectName;
    }

    public List<MrpLineOrigin> getMrpLineOriginList() {
        return this.mrpLineOriginList;
    }

    public void setMrpLineOriginList(List<MrpLineOrigin> mrpLineOriginList) {
        this.mrpLineOriginList = mrpLineOriginList;
    }

    public void addMrpLineOriginListItem(MrpLineOrigin item) {
        if (this.mrpLineOriginList == null) {
            this.mrpLineOriginList = new ArrayList<MrpLineOrigin>();
        }
        this.mrpLineOriginList.add(item);
        item.setMrpLine(this);
    }

    public void removeMrpLineOriginListItem(MrpLineOrigin item) {
        if (this.mrpLineOriginList == null) {
            return;
        }
        this.mrpLineOriginList.remove((Object)item);
    }

    public void clearMrpLineOriginList() {
        if (this.mrpLineOriginList != null) {
            this.mrpLineOriginList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MrpLine)) {
            return false;
        }
        MrpLine other = (MrpLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("qty", (Object)this.getQty());
        tsh.add("cumulativeQty", (Object)this.getCumulativeQty());
        tsh.add("maturityDate", (Object)this.getMaturityDate());
        tsh.add("maxLevel", (Object)this.getMaxLevel());
        tsh.add("minQty", (Object)this.getMinQty());
        tsh.add("relatedToSelectName", (Object)this.getRelatedToSelectName());
        return tsh.omitNullValues().toString();
    }
}

