/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.joda.time.LocalDate;

@Entity
@Table(name="SUPPLYCHAIN_SUBSCRIPTION")
public class Subscription
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_SUBSCRIPTION_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_SUBSCRIPTION_SEQ", sequenceName="SUPPLYCHAIN_SUBSCRIPTION_SEQ", allocationSize=1)
    private Long id;
    @Index(name="SUPPLYCHAIN_SUBSCRIPTION_SALE_ORDER_LINE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Widget(title="Invoicing Date")
    private LocalDate invoicingDate;
    @Widget(title="Date From")
    private LocalDate fromPeriodDate;
    @Widget(title="Date To")
    private LocalDate toPeriodDate;
    @Widget(title="Invoiced ?")
    private Boolean invoiced = Boolean.FALSE;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public LocalDate getInvoicingDate() {
        return this.invoicingDate;
    }

    public void setInvoicingDate(LocalDate invoicingDate) {
        this.invoicingDate = invoicingDate;
    }

    public LocalDate getFromPeriodDate() {
        return this.fromPeriodDate;
    }

    public void setFromPeriodDate(LocalDate fromPeriodDate) {
        this.fromPeriodDate = fromPeriodDate;
    }

    public LocalDate getToPeriodDate() {
        return this.toPeriodDate;
    }

    public void setToPeriodDate(LocalDate toPeriodDate) {
        this.toPeriodDate = toPeriodDate;
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("invoicingDate", (Object)this.getInvoicingDate());
        tsh.add("fromPeriodDate", (Object)this.getFromPeriodDate());
        tsh.add("toPeriodDate", (Object)this.getToPeriodDate());
        tsh.add("invoiced", (Object)this.getInvoiced());
        return tsh.omitNullValues().toString();
    }
}

