/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_SUPPLYCHAIN_BATCH")
public class SupplychainBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_SEQ", sequenceName="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    @NameColumn
    @Index(name="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_CODE_IDX")
    private String code;
    @Widget(title="Action", selection="supplychain.batch.action.select")
    @NotNull
    private Integer actionSelect = 1;
    @Widget(title="Company")
    @NotNull
    @Index(name="SUPPLYCHAIN_SUPPLYCHAIN_BATCH_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Widget(title="Batchs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="supplychainBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;

    public SupplychainBatch() {
    }

    public SupplychainBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.batchList == null) {
            this.batchList = new ArrayList<Batch>();
        }
        this.batchList.add(item);
        item.setSupplychainBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.batchList == null) {
            return;
        }
        this.batchList.remove((Object)item);
    }

    public void clearBatchList() {
        if (this.batchList != null) {
            this.batchList.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SupplychainBatch)) {
            return false;
        }
        SupplychainBatch other = (SupplychainBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("code", (Object)this.getCode());
        tsh.add("actionSelect", (Object)this.getActionSelect());
        return tsh.omitNullValues().toString();
    }
}

