/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.AddressServiceImpl;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.inject.Beans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressServiceSupplychainImpl
extends AddressServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AddressServiceSupplychainImpl.class);

    public boolean checkAddressUsed(Long addressId) {
        LOG.debug("Address Id to be checked = {}", (Object)addressId);
        if (addressId != null) {
            if (((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).all().filter("self.mainInvoicingAddress.id = ?1 OR self.deliveryAddress.id = ?1", new Object[]{addressId}).fetchOne() != null) {
                return true;
            }
            if (((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.mainInvoicingAddress.id = ?1 OR self.deliveryAddress.id = ?1", new Object[]{addressId}).fetchOne() != null) {
                return true;
            }
            if (((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.fromAddress.id = ?1 OR self.toAddress.id = ?1", new Object[]{addressId}).fetchOne() != null) {
                return true;
            }
        }
        return false;
    }
}

