/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveCancelService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.sale.db.AdvancePayment;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.AdvancePaymentRepository;
import com.axelor.apps.sale.service.AdvancePaymentServiceImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancePaymentServiceSupplychainImpl
extends AdvancePaymentServiceImpl {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    protected PaymentModeService paymentModeService;
    @Inject
    protected MoveService moveService;
    @Inject
    protected MoveLineService moveLineService;
    @Inject
    protected CurrencyService currencyService;
    @Inject
    protected AccountConfigService accountConfigService;
    @Inject
    protected InvoicePaymentRepository invoicePaymentRepository;
    @Inject
    protected MoveRepository moveRepo;
    @Inject
    protected AdvancePaymentRepository advancePaymentRepository;
    @Inject
    protected MoveCancelService moveCancelService;

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void validate(AdvancePayment advancePayment) throws AxelorException {
        if (advancePayment.getStatusSelect() != AdvancePaymentRepository.STATUS_DRAFT) {
            return;
        }
        advancePayment.setStatusSelect(AdvancePaymentRepository.STATUS_VALIDATED);
        Company company = advancePayment.getSaleOrder().getCompany();
        if (this.accountConfigService.getAccountConfig(company).getGenerateMoveForAdvancePayment().booleanValue()) {
            this.createMoveForAdvancePayment(advancePayment);
        }
        this.advancePaymentRepository.save((Model)advancePayment);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void cancel(AdvancePayment advancePayment) throws AxelorException {
        this.moveCancelService.cancel(advancePayment.getMove());
        advancePayment.setStatusSelect(AdvancePaymentRepository.STATUS_CANCELED);
        this.advancePaymentRepository.save((Model)advancePayment);
    }

    public void createInvoicePayments(Invoice invoice, SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getAdvancePaymentList() == null || saleOrder.getAdvancePaymentList().isEmpty()) {
            return;
        }
        BigDecimal total = saleOrder.getInTaxTotal();
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Move createMoveForAdvancePayment(AdvancePayment advancePayment) throws AxelorException {
        SaleOrder saleOrder = advancePayment.getSaleOrder();
        Company company = saleOrder.getCompany();
        PaymentMode paymentMode = advancePayment.getPaymentMode();
        Partner clientPartner = saleOrder.getClientPartner();
        LocalDate advancePaymentDate = advancePayment.getAdvancePaymentDate();
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        Journal journal = this.paymentModeService.getPaymentModeJournal(paymentMode, company);
        Move move = this.moveService.getMoveCreateService().createMove(journal, company, advancePayment.getCurrency(), clientPartner, advancePaymentDate, paymentMode, 2);
        BigDecimal amountConverted = this.currencyService.getAmountCurrencyConvertedAtDate(advancePayment.getCurrency(), saleOrder.getCurrency(), advancePayment.getAmount(), advancePaymentDate);
        move.addMoveLineListItem(this.moveLineService.createMoveLine(move, clientPartner, this.paymentModeService.getPaymentModeAccount(paymentMode, company), amountConverted, true, advancePaymentDate, null, 1, ""));
        move.addMoveLineListItem(this.moveLineService.createMoveLine(move, clientPartner, this.accountConfigService.getAdvancePaymentAccount(accountConfig), amountConverted, false, advancePaymentDate, null, 2, ""));
        this.moveService.getMoveValidateService().validate(move);
        advancePayment.setMove(move);
        this.advancePaymentRepository.save((Model)advancePayment);
        return move;
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public InvoicePayment createInvoicePayment(AdvancePayment advancePayment, Invoice invoice, BigDecimal amount) throws AxelorException {
        this.log.debug("Creating InvoicePayment from SaleOrder AdvancePayment");
        InvoicePayment invoicePayment = new InvoicePayment();
        invoicePayment.setAmount(amount);
        invoicePayment.setPaymentDate(advancePayment.getAdvancePaymentDate());
        invoicePayment.setCurrency(advancePayment.getCurrency());
        invoicePayment.setInvoice(invoice);
        invoicePayment.setPaymentMode(advancePayment.getPaymentMode());
        invoicePayment.setTypeSelect(Integer.valueOf(1));
        invoicePayment.setMove(advancePayment.getMove());
        this.invoicePaymentRepository.save((Model)invoicePayment);
        invoice.addInvoicePaymentListItem(invoicePayment);
        return invoicePayment;
    }
}

