/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.service.AnalyticDistributionLineServiceImpl;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.rpc.Context;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AnalyticDistributionLineServiceSupplychainImpl
extends AnalyticDistributionLineServiceImpl {
    public BigDecimal computeAmount(AnalyticDistributionLine analyticDistributionLine) {
        BigDecimal amount = BigDecimal.ZERO;
        if (analyticDistributionLine.getPurchaseOrderLine() != null) {
            amount = analyticDistributionLine.getPercentage().multiply(analyticDistributionLine.getPurchaseOrderLine().getExTaxTotal().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        if (analyticDistributionLine.getSaleOrderLine() != null) {
            amount = analyticDistributionLine.getPercentage().multiply(analyticDistributionLine.getSaleOrderLine().getExTaxTotal().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return super.computeAmount(analyticDistributionLine);
        }
        return amount;
    }

    public BigDecimal chooseComputeWay(Context context, AnalyticDistributionLine analyticDistributionLine) {
        if (analyticDistributionLine.getPurchaseOrderLine() == null && analyticDistributionLine.getSaleOrderLine() == null) {
            if (context.getParentContext().getContextClass() == PurchaseOrderLine.class) {
                analyticDistributionLine.setPurchaseOrderLine((PurchaseOrderLine)((Object)context.getParentContext().asType(PurchaseOrderLine.class)));
            } else if (context.getParentContext().getContextClass() == InvoiceLine.class) {
                analyticDistributionLine.setInvoiceLine((InvoiceLine)((Object)context.getParentContext().asType(InvoiceLine.class)));
            } else if (context.getParentContext().getContextClass() == MoveLine.class) {
                analyticDistributionLine.setMoveLine((MoveLine)context.getParentContext().asType(MoveLine.class));
            } else {
                analyticDistributionLine.setSaleOrderLine((SaleOrderLine)((Object)context.getParentContext().asType(SaleOrderLine.class)));
            }
        }
        return this.computeAmount(analyticDistributionLine);
    }
}

