/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.BudgetLine;
import com.axelor.apps.account.db.repo.BudgetDistributionRepository;
import com.axelor.apps.account.service.BudgetService;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class BudgetSupplychainService
extends BudgetService {
    @Inject
    GeneralService generalservice;

    public List<BudgetLine> updateLines(Budget budget) {
        if (budget.getBudgetLineList() != null && !budget.getBudgetLineList().isEmpty()) {
            LocalDate toDate;
            LocalDate fromDate;
            LocalDate orderDate;
            for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                budgetLine.setAmountCommitted(BigDecimal.ZERO);
                budgetLine.setAmountRealized(BigDecimal.ZERO);
            }
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            if (this.generalservice.getGeneral().getManageBudget().booleanValue() && !this.generalservice.getGeneral().getBudgetStatusSelect().isEmpty()) {
                String str = this.generalservice.getGeneral().getBudgetStatusSelect();
                String[] numbers = str.split(", ");
                for (int c = 0; c < numbers.length; ++c) {
                    statusList.add(Integer.parseInt(numbers[c]));
                }
            }
            List budgetDistributionList = null;
            if (!statusList.isEmpty()) {
                budgetDistributionList = ((BudgetDistributionRepository)((Object)Beans.get(BudgetDistributionRepository.class))).all().filter("self.budget.id = ?1 AND (self.purchaseOrderLine.purchaseOrder.statusSelect in (?2) OR ?3 is null)", new Object[]{budget.getId(), statusList, statusList}).fetch();
                block2: for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                    orderDate = budgetDistribution.getPurchaseOrderLine().getPurchaseOrder().getOrderDate();
                    if (orderDate == null) continue;
                    for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                        fromDate = budgetLine.getFromDate();
                        toDate = budgetLine.getToDate();
                        if (!fromDate.isBefore((ReadablePartial)orderDate) && !fromDate.isEqual((ReadablePartial)orderDate) || !toDate.isAfter((ReadablePartial)orderDate) && !toDate.isEqual((ReadablePartial)orderDate)) continue;
                        budgetLine.setAmountCommitted(budgetLine.getAmountCommitted().add(budgetDistribution.getAmount()));
                        continue block2;
                    }
                }
            }
            budgetDistributionList = ((BudgetDistributionRepository)((Object)Beans.get(BudgetDistributionRepository.class))).all().filter("self.budget.id = ?1 AND (self.invoiceLine.invoice.statusSelect = ?2 OR self.invoiceLine.invoice.statusSelect = ?3)", new Object[]{budget.getId(), 2, 3}).fetch();
            block4: for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                orderDate = budgetDistribution.getInvoiceLine().getInvoice().getInvoiceDate();
                if (orderDate == null) continue;
                for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                    fromDate = budgetLine.getFromDate();
                    toDate = budgetLine.getToDate();
                    if (!fromDate.isBefore((ReadablePartial)orderDate) && !fromDate.isEqual((ReadablePartial)orderDate) || !toDate.isAfter((ReadablePartial)orderDate) && !toDate.isEqual((ReadablePartial)orderDate)) continue;
                    budgetLine.setAmountRealized(budgetLine.getAmountRealized().add(budgetDistribution.getAmount()));
                    continue block4;
                }
            }
        }
        return budget.getBudgetLineList();
    }
}

