/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.config.SaleConfigService;
import com.axelor.apps.supplychain.db.CustomerCreditLine;
import com.axelor.apps.supplychain.db.repo.CustomerCreditLineRepository;
import com.axelor.apps.supplychain.service.CustomerCreditLineService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerCreditLineServiceImpl
implements CustomerCreditLineService {
    @Inject
    protected CustomerCreditLineRepository customerCreditLineRepo;
    @Inject
    protected SaleConfigService saleConfigService;
    @Inject
    protected PartnerRepository partnerRepo;

    @Override
    public Partner generateLines(Partner partner) throws AxelorException {
        if (partner.getIsContact().booleanValue() || !partner.getIsCustomer().booleanValue() || !((GeneralService)Beans.get(GeneralService.class)).getGeneral().getManageCustomerCredit().booleanValue() || partner.getCompanySet() == null) {
            return partner;
        }
        ArrayList<Company> companyList = new ArrayList<Company>(partner.getCompanySet());
        ArrayList<Object> customerCreditLineList = new ArrayList();
        if (partner.getCustomerCreditLineList() != null && !partner.getCustomerCreditLineList().isEmpty()) {
            customerCreditLineList = new ArrayList<CustomerCreditLine>(partner.getCustomerCreditLineList());
            for (CustomerCreditLine customerCreditLine : customerCreditLineList) {
                if (!companyList.contains((Object)customerCreditLine.getCompany())) {
                    partner.removeCustomerCreditLineListItem(customerCreditLine);
                    continue;
                }
                companyList.remove((Object)customerCreditLine.getCompany());
            }
        }
        for (Company company : companyList) {
            CustomerCreditLine customerCreditLine = new CustomerCreditLine();
            customerCreditLine.setCompany(company);
            customerCreditLine.setAcceptedCredit(this.saleConfigService.getSaleConfig(company).getAcceptedCredit());
            partner.addCustomerCreditLineListItem(customerCreditLine);
        }
        return partner;
    }

    @Override
    public void updateLines(Partner partner) throws AxelorException {
        if (partner.getCustomerCreditLineList() == null || partner.getCustomerCreditLineList().isEmpty()) {
            partner = this.generateLines(partner);
        }
        List<CustomerCreditLine> customerCreditLineList = partner.getCustomerCreditLineList();
        for (CustomerCreditLine customerCreditLine : customerCreditLineList) {
            customerCreditLine = this.computeUsedCredit(customerCreditLine);
        }
    }

    @Override
    public Map<String, Object> updateLinesFromOrder(Partner partner, SaleOrder saleOrder) throws AxelorException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (partner.getCustomerCreditLineList() == null || partner.getCustomerCreditLineList().isEmpty()) {
            partner = this.generateLines(partner);
        }
        List<CustomerCreditLine> customerCreditLineList = partner.getCustomerCreditLineList();
        for (CustomerCreditLine customerCreditLine : customerCreditLineList) {
            if (!customerCreditLine.getCompany().equals((Object)saleOrder.getCompany())) continue;
            customerCreditLine = this.computeUsedCredit(customerCreditLine);
            customerCreditLine.setUsedCredit(customerCreditLine.getUsedCredit().add(saleOrder.getExTaxTotal().subtract(saleOrder.getAmountInvoiced())));
            boolean test = this.testUsedCredit(customerCreditLine);
            map.put("bloqued", test);
            if (!test) continue;
            if (Strings.isNullOrEmpty((String)customerCreditLine.getCompany().getOrderBloquedMessage())) {
                map.put("message", I18n.get((String)"Client bloqued"));
                continue;
            }
            map.put("message", customerCreditLine.getCompany().getOrderBloquedMessage());
        }
        return map;
    }

    @Override
    public CustomerCreditLine computeUsedCredit(CustomerCreditLine customerCreditLine) {
        Company company = customerCreditLine.getCompany();
        if (customerCreditLine.getPartner().getAccountingSituationList() != null) {
            List<AccountingSituation> accountingSituationList = customerCreditLine.getPartner().getAccountingSituationList();
            for (AccountingSituation accountingSituation : accountingSituationList) {
                if (!accountingSituation.getCompany().equals((Object)company)) continue;
                List saleOrderList = ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter("self.company = ?1 AND self.clientPartner = ?2 AND self.statusSelect > ?3 AND self.statusSelect < ?4", new Object[]{company, customerCreditLine.getPartner(), 1, 5}).fetch();
                BigDecimal sum = BigDecimal.ZERO;
                for (SaleOrder saleOrder : saleOrderList) {
                    sum = sum.add(saleOrder.getExTaxTotal().subtract(saleOrder.getAmountInvoiced()));
                }
                customerCreditLine.setUsedCredit(accountingSituation.getBalanceCustAccount().add(sum));
            }
        }
        return customerCreditLine;
    }

    @Override
    public boolean testUsedCredit(CustomerCreditLine customerCreditLine) {
        return customerCreditLine.getUsedCredit().compareTo(customerCreditLine.getAcceptedCredit()) > 0;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public boolean checkBlockedPartner(Partner partner, Company company) throws AxelorException {
        CustomerCreditLine customerCreditLine = (CustomerCreditLine)this.customerCreditLineRepo.all().filter("self.company = ?1 AND self.partner = ?2", new Object[]{company, partner}).fetchOne();
        if (customerCreditLine == null) {
            partner = this.generateLines(partner);
            for (CustomerCreditLine customerCreditLineIt : partner.getCustomerCreditLineList()) {
                if (customerCreditLineIt.getCompany() != company) continue;
                customerCreditLine = customerCreditLineIt;
            }
            ((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).save((Model)partner);
        } else {
            customerCreditLine = this.computeUsedCredit(customerCreditLine);
            this.customerCreditLineRepo.save((Model)customerCreditLine);
        }
        return this.testUsedCredit(customerCreditLine);
    }
}

