/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.config.PurchaseConfigService;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.LocationLine;
import com.axelor.apps.stock.db.MinStockRules;
import com.axelor.apps.stock.service.MinStockRulesServiceImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class MinStockRulesServiceSupplychainImpl
extends MinStockRulesServiceImpl {
    @Inject
    protected PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    @Inject
    protected PurchaseOrderLineService purchaseOrderLineService;
    @Inject
    protected PurchaseConfigService purchaseConfigService;
    protected User user;
    @Inject
    private PurchaseOrderRepository purchaseOrderRepo;

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generatePurchaseOrder(Product product, BigDecimal qty, LocationLine locationLine, int type) throws AxelorException {
        Partner supplierPartner;
        Location location = locationLine.getLocation();
        if (location == null) {
            return;
        }
        MinStockRules minStockRules = this.getMinStockRules(product, location, type);
        if (minStockRules == null) {
            return;
        }
        if (this.useMinStockRules(locationLine, minStockRules, qty, type) && minStockRules.getOrderAlertSelect() != 1 && minStockRules.getOrderAlertSelect() != 3 && minStockRules.getOrderAlertSelect() == 2 && (supplierPartner = product.getDefaultSupplierPartner()) != null) {
            Company company = location.getCompany();
            PurchaseOrder purchaseOrder = (PurchaseOrder)this.purchaseOrderRepo.save((Model)this.purchaseOrderServiceSupplychainImpl.createPurchaseOrder(this.user, company, null, supplierPartner.getCurrency(), this.today.plusDays(supplierPartner.getDeliveryDelay().intValue()), minStockRules.getName(), null, location, this.today, supplierPartner.getPurchasePriceList(), supplierPartner));
            purchaseOrder.addPurchaseOrderLineListItem(this.purchaseOrderLineService.createPurchaseOrderLine(purchaseOrder, product, null, null, minStockRules.getReOrderQty(), product.getUnit()));
            this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
            this.purchaseOrderRepo.save((Model)purchaseOrder);
        }
    }
}

