/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.SupplierCatalog;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.GeneralService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.Location;
import com.axelor.apps.stock.db.LocationLine;
import com.axelor.apps.stock.db.MinStockRules;
import com.axelor.apps.stock.db.repo.LocationLineRepository;
import com.axelor.apps.stock.db.repo.LocationRepository;
import com.axelor.apps.stock.service.MinStockRulesService;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpFamily;
import com.axelor.apps.supplychain.db.MrpForecast;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.db.MrpLineOrigin;
import com.axelor.apps.supplychain.db.MrpLineType;
import com.axelor.apps.supplychain.db.repo.MrpForecastRepository;
import com.axelor.apps.supplychain.db.repo.MrpLineRepository;
import com.axelor.apps.supplychain.db.repo.MrpLineTypeRepository;
import com.axelor.apps.supplychain.db.repo.MrpRepository;
import com.axelor.apps.supplychain.service.MrpLineService;
import com.axelor.apps.supplychain.service.MrpService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrpServiceImpl
implements MrpService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected MrpRepository mrpRepository;
    protected LocationRepository locationRepository;
    protected ProductRepository productRepository;
    protected LocationLineRepository locationLineRepository;
    protected MrpLineTypeRepository mrpLineTypeRepository;
    protected PurchaseOrderLineRepository purchaseOrderLineRepository;
    protected SaleOrderLineRepository saleOrderLineRepository;
    protected MrpLineRepository mrpLineRepository;
    protected MinStockRulesService minStockRulesService;
    protected MrpLineService mrpLineService;
    protected MrpForecastRepository mrpForecastRepository;
    protected LocalDate today;
    protected List<Location> locationList = Lists.newArrayList();
    protected Map<Product, Integer> productMap = Maps.newHashMap();
    protected Mrp mrp;

    @Inject
    public MrpServiceImpl(GeneralService generalService, MrpRepository mrpRepository, LocationRepository locationRepository, ProductRepository productRepository, LocationLineRepository locationLineRepository, MrpLineTypeRepository mrpLineTypeRepository, PurchaseOrderLineRepository purchaseOrderLineRepository, SaleOrderLineRepository saleOrderLineRepository, MrpLineRepository mrpLineRepository, MinStockRulesService minStockRulesService, MrpLineService mrpLineService, MrpForecastRepository mrpForecastRepository) {
        this.mrpRepository = mrpRepository;
        this.locationRepository = locationRepository;
        this.productRepository = productRepository;
        this.locationLineRepository = locationLineRepository;
        this.mrpLineTypeRepository = mrpLineTypeRepository;
        this.purchaseOrderLineRepository = purchaseOrderLineRepository;
        this.saleOrderLineRepository = saleOrderLineRepository;
        this.mrpLineRepository = mrpLineRepository;
        this.minStockRulesService = minStockRulesService;
        this.mrpLineService = mrpLineService;
        this.mrpForecastRepository = mrpForecastRepository;
        this.today = generalService.getTodayDate();
    }

    @Override
    public void runCalculation(Mrp mrp) throws AxelorException {
        this.startMrp((Mrp)this.mrpRepository.find(mrp.getId()));
        this.completeMrp((Mrp)this.mrpRepository.find(mrp.getId()));
        this.doCalulation((Mrp)this.mrpRepository.find(mrp.getId()));
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    protected void startMrp(Mrp mrp) {
        this.log.debug("Start MRP");
        mrp.setStatusSelect(1);
        mrp.clearMrpLineList();
        this.mrpRepository.save((Model)mrp);
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void reset(Mrp mrp) {
        mrp.setStatusSelect(0);
        mrp.clearMrpLineList();
        this.mrpRepository.save((Model)mrp);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    protected void completeMrp(Mrp mrp) throws AxelorException {
        this.log.debug("Complete MRP");
        this.mrp = mrp;
        this.locationList = this.getAllLocationAndSubLocation(mrp.getLocation());
        this.assignProductAndLevel(this.getProductList());
        this.createAvailableStockMrpLines();
        this.createPurchaseMrpLines();
        this.createSaleOrderMrpLines();
        this.createSaleForecastMrpLines();
        this.mrpRepository.save((Model)mrp);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    protected void doCalulation(Mrp mrp) throws AxelorException {
        this.log.debug("Do calculation");
        this.mrpRepository.save((Model)mrp);
        this.checkInsufficientCumulativeQty();
        mrp.setStatusSelect(2);
    }

    protected void checkInsufficientCumulativeQty() throws AxelorException {
        for (int level = 0; level <= this.getMaxLevel(); ++level) {
            for (Product product : this.getProductList(level)) {
                this.checkInsufficientCumulativeQty(product);
            }
        }
    }

    protected List<Product> getProductList(int level) {
        ArrayList productList = Lists.newArrayList();
        for (Product product : this.productMap.keySet()) {
            if (this.productMap.get((Object)product) != level) continue;
            productList.add(product);
        }
        return productList;
    }

    protected int getMaxLevel() {
        int maxLevel = 0;
        for (int level : this.productMap.values()) {
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }

    protected void checkInsufficientCumulativeQty(Product product) throws AxelorException {
        boolean doASecondPass = false;
        this.computeCumulativeQty(product);
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp = ?1 AND self.product = ?2", new Object[]{this.mrp, product}).order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        for (MrpLine mrpLine : mrpLineList) {
            BigDecimal cumulativeQty = mrpLine.getCumulativeQty();
            MrpLineType mrpLineType = mrpLine.getMrpLineType();
            boolean isProposalElement = this.isProposalElement(mrpLineType);
            BigDecimal minQty = mrpLine.getMinQty();
            if (mrpLine.getMrpLineType().getElementSelect() == 1 || isProposalElement && mrpLineType.getTypeSelect() != 2 || cumulativeQty.compareTo(mrpLine.getMinQty()) != -1) continue;
            this.log.debug("Cumulative qty ({} < {}) is insufficient for product ({}) at the maturity date ({})", new Object[]{cumulativeQty, minQty, product.getFullName(), mrpLine.getMaturityDate()});
            BigDecimal reorderQty = minQty.subtract(cumulativeQty);
            MinStockRules minStockRules = this.minStockRulesService.getMinStockRules(product, mrpLine.getLocation(), 2);
            if (minStockRules != null) {
                reorderQty = reorderQty.max(minStockRules.getReOrderQty());
            }
            MrpLineType mrpLineTypeProposal = this.getMrpLineTypeForProposal(minStockRules);
            this.createProposalMrpLine(product, mrpLineTypeProposal, reorderQty, mrpLine.getLocation(), mrpLine.getMaturityDate(), mrpLine.getMrpLineOriginList(), mrpLine.getRelatedToSelectName());
            doASecondPass = true;
            break;
        }
        if (doASecondPass) {
            this.mrpRepository.save((Model)this.mrp);
            this.checkInsufficientCumulativeQty(product);
        }
    }

    public MrpLine getPreviousProposalMrpLine(Product product, MrpLineType mrpLineType, Location location, LocalDate maturityDate) {
        LocalDate startPeriodDate = maturityDate;
        MrpFamily mrpFamily = product.getMrpFamily();
        if (mrpFamily != null) {
            if (mrpFamily.getDayNb() == 0) {
                return null;
            }
            startPeriodDate = maturityDate.minusDays(mrpFamily.getDayNb().intValue());
        }
        return (MrpLine)this.mrpLineRepository.all().filter("self.mrp = ?1 AND self.product = ?2 AND self.mrpLineType = ?3 AND self.location = ?4 AND self.maturityDate > ?5 AND self.maturityDate <= ?6", new Object[]{this.mrp, product, mrpLineType, location, startPeriodDate, maturityDate}).fetchOne();
    }

    protected void createProposalMrpLine(Product product, MrpLineType mrpLineType, BigDecimal reorderQty, Location location, LocalDate maturityDate, List<MrpLineOrigin> mrpLineOriginList, String relatedToSelectName) throws AxelorException {
        MrpLine mrpLine;
        if (mrpLineType.getElementSelect() == 5) {
            maturityDate = maturityDate.minusDays(product.getSupplierDeliveryTime().intValue());
            reorderQty = reorderQty.max(this.getSupplierCatalogMinQty(product));
        }
        if ((mrpLine = this.getPreviousProposalMrpLine(product, mrpLineType, location, maturityDate)) != null) {
            mrpLine.setQty(mrpLine.getQty().add(reorderQty));
            mrpLine.setRelatedToSelectName(null);
        } else {
            mrpLine = (MrpLine)this.mrpLineRepository.save((Model)this.createMrpLine(product, mrpLineType, reorderQty, maturityDate, BigDecimal.ZERO, location, new Model[0]));
            this.mrp.addMrpLineListItem(mrpLine);
            mrpLine.setRelatedToSelectName(relatedToSelectName);
        }
        this.copyMrpLineOrigins(mrpLine, mrpLineOriginList);
    }

    protected BigDecimal getSupplierCatalogMinQty(Product product) {
        Partner supplierPartner = product.getDefaultSupplierPartner();
        if (supplierPartner != null) {
            for (SupplierCatalog supplierCatalog : product.getSupplierCatalogList()) {
                if (!supplierCatalog.getSupplierPartner().equals((Object)supplierPartner)) continue;
                return supplierCatalog.getMinQty();
            }
        }
        return BigDecimal.ZERO;
    }

    protected MrpLineType getMrpLineTypeForProposal(MinStockRules minStockRules) throws AxelorException {
        return this.getMrpLineType(5);
    }

    protected void consolidateMrp() {
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp = ?1", new Object[]{this.mrp}).order("self.product.code").order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        HashMap map = Maps.newHashMap();
        MrpLine consolidateMrpLine = null;
        ArrayList<Object> keys = new ArrayList<Object>();
        for (MrpLine mrpLine : mrpLineList) {
            MrpLineType mrpLineType = mrpLine.getMrpLineType();
            keys.clear();
            keys.add((Object)mrpLineType);
            keys.add((Object)mrpLine.getProduct());
            keys.add(mrpLine.getMaturityDate());
            keys.add(mrpLine.getLocation());
            if (map.containsKey(keys)) {
                consolidateMrpLine = (MrpLine)((Object)map.get(keys));
                consolidateMrpLine.setQty(consolidateMrpLine.getQty().add(mrpLine.getQty()));
                consolidateMrpLine.setCumulativeQty(consolidateMrpLine.getCumulativeQty().add(mrpLine.getCumulativeQty()));
                continue;
            }
            map.put(keys, mrpLine);
        }
        this.mrp.getMrpLineList().clear();
        this.mrp.getMrpLineList().addAll(map.values());
    }

    protected boolean isProposalElement(MrpLineType mrpLineType) {
        return mrpLineType.getElementSelect() == 5;
    }

    protected void computeCumulativeQty() {
        for (Product product : this.productMap.keySet()) {
            this.computeCumulativeQty(product);
        }
    }

    protected void computeCumulativeQty(Product product) {
        List mrpLineList = this.mrpLineRepository.all().filter("self.mrp = ?1 AND self.product = ?2", new Object[]{this.mrp, product}).order("maturityDate").order("mrpLineType.typeSelect").order("mrpLineType.sequence").order("id").fetch();
        BigDecimal previousCumulativeQty = BigDecimal.ZERO;
        for (MrpLine mrpLine : mrpLineList) {
            if (mrpLine.getMrpLineType().getElementSelect() == 1) {
                mrpLine.setCumulativeQty(mrpLine.getQty());
            } else {
                mrpLine.setCumulativeQty(previousCumulativeQty.add(mrpLine.getQty()));
            }
            previousCumulativeQty = mrpLine.getCumulativeQty();
            this.log.debug("Cumulative qty is ({}) for product ({}) and move ({}) at the maturity date ({})", new Object[]{previousCumulativeQty, mrpLine.getProduct().getFullName(), mrpLine.getMrpLineType().getName(), mrpLine.getMaturityDate()});
        }
    }

    protected void createPurchaseMrpLines() throws AxelorException {
        MrpLineType purchaseProposalMrpLineType = this.getMrpLineType(2);
        List purchaseOrderLineList = this.purchaseOrderLineRepository.all().filter("self.product in (?1) AND self.purchaseOrder.location in (?2) AND self.purchaseOrder.receiptState = ?3 AND self.purchaseOrder.statusSelect = ?4", new Object[]{this.productMap.keySet(), this.locationList, 1, 3}).fetch();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
            LocalDate maturityDate = purchaseOrderLine.getEstimatedDelivDate();
            if (maturityDate == null) {
                maturityDate = purchaseOrder.getDeliveryDate();
            }
            if (maturityDate == null) {
                maturityDate = purchaseOrder.getOrderDate();
            }
            if (!this.isBeforeEndDate(maturityDate)) continue;
            Unit unit = purchaseOrderLine.getProduct().getUnit();
            BigDecimal qty = purchaseOrderLine.getQty();
            if (!unit.equals((Object)purchaseOrderLine.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convertWithProduct(purchaseOrderLine.getUnit(), unit, qty, purchaseOrderLine.getProduct());
            }
            this.mrp.addMrpLineListItem(this.createMrpLine(purchaseOrderLine.getProduct(), purchaseProposalMrpLineType, qty, maturityDate, BigDecimal.ZERO, purchaseOrder.getLocation(), new Model[]{purchaseOrderLine}));
        }
    }

    protected void createSaleOrderMrpLines() throws AxelorException {
        MrpLineType saleForecastMrpLineType = this.getMrpLineType(3);
        ArrayList<SaleOrderLine> saleOrderLineList = new ArrayList<SaleOrderLine>();
        if (this.mrp.getSaleOrderLineSet().isEmpty()) {
            saleOrderLineList.addAll(this.saleOrderLineRepository.all().filter("self.product in (?1) AND self.saleOrder.location in (?2) AND self.saleOrder.deliveryState = ?3 AND self.saleOrder.statusSelect = ?4", new Object[]{this.productMap.keySet(), this.locationList, SaleOrderRepository.STATE_NOT_DELIVERED, 3}).fetch());
        } else {
            saleOrderLineList.addAll(this.mrp.getSaleOrderLineSet());
        }
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            SaleOrder saleOrder = saleOrderLine.getSaleOrder();
            LocalDate maturityDate = saleOrderLine.getEstimatedDelivDate();
            if (maturityDate == null) {
                maturityDate = saleOrder.getDeliveryDate();
            }
            if (maturityDate == null) {
                maturityDate = saleOrder.getOrderDate();
            }
            if (maturityDate == null) {
                maturityDate = saleOrder.getCreationDate();
            }
            if (!this.isBeforeEndDate(maturityDate)) continue;
            Unit unit = saleOrderLine.getProduct().getUnit();
            BigDecimal qty = saleOrderLine.getQty();
            if (!unit.equals((Object)saleOrderLine.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convertWithProduct(saleOrderLine.getUnit(), unit, qty, saleOrderLine.getProduct());
            }
            this.mrp.addMrpLineListItem(this.createMrpLine(saleOrderLine.getProduct(), saleForecastMrpLineType, qty, maturityDate, BigDecimal.ZERO, saleOrder.getLocation(), new Model[]{saleOrderLine}));
        }
    }

    protected void createSaleForecastMrpLines() throws AxelorException {
        MrpLineType saleForecastMrpLineType = this.getMrpLineType(4);
        ArrayList<MrpForecast> mrpForecastList = new ArrayList<MrpForecast>();
        if (this.mrp.getMrpForecastSet().isEmpty()) {
            mrpForecastList.addAll(this.mrpForecastRepository.all().filter("self.product in (?1) AND self.location in (?2) AND self.forecastDate >= ?3", new Object[]{this.productMap.keySet(), this.locationList, this.today, this.today}).fetch());
        } else {
            mrpForecastList.addAll(this.mrp.getMrpForecastSet());
        }
        for (MrpForecast mrpForecast : mrpForecastList) {
            LocalDate maturityDate = mrpForecast.getForecastDate();
            if (!this.isBeforeEndDate(maturityDate)) continue;
            Unit unit = mrpForecast.getProduct().getUnit();
            BigDecimal qty = mrpForecast.getQty();
            if (!unit.equals((Object)mrpForecast.getUnit())) {
                qty = ((UnitConversionService)Beans.get(UnitConversionService.class)).convertWithProduct(mrpForecast.getUnit(), unit, qty, mrpForecast.getProduct());
            }
            this.mrp.addMrpLineListItem(this.createMrpLine(mrpForecast.getProduct(), saleForecastMrpLineType, qty, maturityDate, BigDecimal.ZERO, mrpForecast.getLocation(), new Model[]{mrpForecast}));
        }
    }

    public boolean isBeforeEndDate(LocalDate maturityDate) {
        return maturityDate != null && !maturityDate.isBefore((ReadablePartial)this.today) && (this.mrp.getEndDate() == null || !maturityDate.isAfter((ReadablePartial)this.mrp.getEndDate()));
    }

    protected void createAvailableStockMrpLines() throws AxelorException {
        MrpLineType availableStockMrpLineType = this.getMrpLineType(1);
        for (Product product : this.productMap.keySet()) {
            for (Location location : this.locationList) {
                this.mrp.addMrpLineListItem(this.createAvailableStockMrpLine(product, location, availableStockMrpLineType));
            }
        }
    }

    protected MrpLine createAvailableStockMrpLine(Product product, Location location, MrpLineType availableStockMrpLineType) {
        BigDecimal qty = BigDecimal.ZERO;
        LocationLine locationLine = this.getLocationLine(product, location);
        if (locationLine != null) {
            qty = locationLine.getCurrentQty();
        }
        return this.createMrpLine(product, availableStockMrpLineType, qty, this.today, qty, location, new Model[0]);
    }

    protected MrpLineType getMrpLineType(int elementSelect) throws AxelorException {
        MrpLineType mrpLineType = (MrpLineType)this.mrpLineTypeRepository.all().filter("self.elementSelect = ?1", new Object[]{elementSelect}).fetchOne();
        if (mrpLineType != null) {
            return mrpLineType;
        }
        throw new AxelorException(String.format(I18n.get((String)"No move type found for element : %s"), elementSelect), 4, new Object[0]);
    }

    protected LocationLine getLocationLine(Product product, Location location) {
        return (LocationLine)this.locationLineRepository.all().filter("self.location = ?1 AND self.product = ?2", new Object[]{location, product}).fetchOne();
    }

    protected Set<Product> getProductList() throws AxelorException {
        HashSet productSet = Sets.newHashSet();
        if (!this.mrp.getProductSet().isEmpty()) {
            productSet.addAll(this.mrp.getProductSet());
        }
        if (!this.mrp.getProductCategorySet().isEmpty()) {
            productSet.addAll(this.productRepository.all().filter("self.productCategory in (?1) AND self.productTypeSelect = ?2 AND self.excludeFromMrp = false", new Object[]{this.mrp.getProductCategorySet(), "storable"}).fetch());
        }
        if (!this.mrp.getProductFamilySet().isEmpty()) {
            productSet.addAll(this.productRepository.all().filter("self.productFamily in (?1) AND self.productTypeSelect = ?2 AND self.excludeFromMrp = false", new Object[]{this.mrp.getProductFamilySet(), "storable"}).fetch());
        }
        for (SaleOrderLine saleOrderLine : this.mrp.getSaleOrderLineSet()) {
            productSet.add(saleOrderLine.getProduct());
        }
        for (MrpForecast mrpForecast : this.mrp.getMrpForecastSet()) {
            productSet.add(mrpForecast.getProduct());
        }
        if (productSet.isEmpty()) {
            throw new AxelorException(String.format(I18n.get((String)"Please select an element to run calculation"), new Object[0]), 4, new Object[0]);
        }
        return productSet;
    }

    public boolean isMrpProduct(Product product) {
        return product != null && product.getExcludeFromMrp() == false && product.getProductTypeSelect().equals("storable");
    }

    protected void assignProductAndLevel(Set<Product> productList) {
        for (Product product : productList) {
            this.assignProductAndLevel(product);
        }
    }

    protected void assignProductAndLevel(Product product) {
        this.log.debug("Add of the product : {}", (Object)product.getFullName());
        this.productMap.put(product, 0);
    }

    protected MrpLine createMrpLine(Product product, MrpLineType mrpLineType, BigDecimal qty, LocalDate maturityDate, BigDecimal cumulativeQty, Location location, Model ... models) {
        return this.mrpLineService.createMrpLine(product, this.productMap.get((Object)product), mrpLineType, qty, maturityDate, cumulativeQty, location, models);
    }

    protected void copyMrpLineOrigins(MrpLine mrpLine, List<MrpLineOrigin> mrpLineOriginList) {
        if (mrpLineOriginList != null) {
            for (MrpLineOrigin mrpLineOrigin : mrpLineOriginList) {
                mrpLine.addMrpLineOriginListItem(this.mrpLineService.copyMrpLineOrigin(mrpLineOrigin));
            }
        }
    }

    protected List<Location> getAllLocationAndSubLocation(Location location) {
        List subLocationList = this.locationRepository.all().filter("self.parent = ?1", new Object[]{location}).fetch();
        for (Location subLocation : subLocationList) {
            subLocationList.addAll(this.getAllLocationAndSubLocation(subLocation));
        }
        subLocationList.add(location);
        return subLocationList;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generateProposals(Mrp mrp) throws AxelorException {
        for (MrpLine mrpLine : mrp.getMrpLineList()) {
            this.mrpLineService.generateProposal(mrpLine);
        }
    }
}

