/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderInvoiceServiceImpl
implements PurchaseOrderInvoiceService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private InvoiceService invoiceService;
    @Inject
    private InvoiceRepository invoiceRepo;
    @Inject
    private PurchaseOrderRepository purchaseOrderRepo;

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Invoice generateInvoice(PurchaseOrder purchaseOrder) throws AxelorException {
        Invoice invoice = this.createInvoice(purchaseOrder);
        this.invoiceRepo.save((Model)invoice);
        this.invoiceService.setDraftSequence(invoice);
        if (invoice != null) {
            purchaseOrder.setInvoice(invoice);
            this.purchaseOrderRepo.save((Model)purchaseOrder);
        }
        return invoice;
    }

    @Override
    public Invoice createInvoice(PurchaseOrder purchaseOrder) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.createInvoiceGenerator(purchaseOrder);
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, purchaseOrder.getPurchaseOrderLineList()));
        return invoice;
    }

    @Override
    public InvoiceGenerator createInvoiceGenerator(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getCurrency() == null) {
            throw new AxelorException(String.format(I18n.get((String)"Please, select a currency for the order %s"), purchaseOrder.getPurchaseOrderSeq()), 4, new Object[0]);
        }
        InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(purchaseOrder){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        return invoiceGenerator;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<PurchaseOrderLine> purchaseOrderLineList) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            if ("subscriptable".equals(purchaseOrderLine.getProduct().getProductTypeSelect())) continue;
            invoiceLineList.addAll(this.createInvoiceLine(invoice, purchaseOrderLine));
            purchaseOrderLine.setInvoiced(true);
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        Product product = purchaseOrderLine.getProduct();
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit(), purchaseOrderLine.getSequence(), false, null, purchaseOrderLine, null){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Override
    public BigDecimal getInvoicedAmount(PurchaseOrder purchaseOrder) {
        return this.getInvoicedAmount(purchaseOrder, null, true);
    }

    @Override
    public BigDecimal getInvoicedAmount(PurchaseOrder purchaseOrder, Long currentInvoiceId, boolean excludeCurrentInvoice) {
        BigDecimal invoicedAmount = BigDecimal.ZERO;
        BigDecimal purchaseAmount = this.getAmountVentilated(purchaseOrder, currentInvoiceId, excludeCurrentInvoice, 1);
        BigDecimal refundAmount = this.getAmountVentilated(purchaseOrder, currentInvoiceId, excludeCurrentInvoice, 2);
        if (purchaseAmount != null) {
            invoicedAmount = invoicedAmount.add(purchaseAmount);
        }
        if (refundAmount != null) {
            invoicedAmount = invoicedAmount.subtract(refundAmount);
        }
        if (!purchaseOrder.getCurrency().equals((Object)purchaseOrder.getCompany().getCurrency()) && purchaseOrder.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = invoicedAmount.divide(purchaseOrder.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmount = purchaseOrder.getExTaxTotal().multiply(rate);
        }
        this.log.debug("Compute the invoiced amount ({}) of the purchase order : {}", (Object)invoicedAmount, (Object)purchaseOrder.getPurchaseOrderSeq());
        return invoicedAmount;
    }

    private BigDecimal getAmountVentilated(PurchaseOrder purchaseOrder, Long currentInvoiceId, boolean excludeCurrentInvoice, int invoiceOperationTypeSelect) {
        BigDecimal invoicedAmount;
        String query = "SELECT SUM(self.companyExTaxTotal) FROM InvoiceLine as self WHERE ((self.purchaseOrderLine.purchaseOrder.id = :purchaseOrderId AND self.invoice.purchaseOrder IS NULL) OR self.invoice.purchaseOrder.id = :purchaseOrderId ) AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect AND self.invoice.statusSelect = :statusVentilated";
        if (currentInvoiceId != null) {
            query = excludeCurrentInvoice ? query + " AND self.invoice.id <> :invoiceId" : query + " OR (self.invoice.id = :invoiceId AND self.invoice.operationTypeSelect = :invoiceOperationTypeSelect) ";
        }
        TypedQuery q = JPA.em().createQuery(query, BigDecimal.class);
        q.setParameter("purchaseOrderId", (Object)purchaseOrder.getId());
        q.setParameter("statusVentilated", (Object)3);
        q.setParameter("invoiceOperationTypeSelect", (Object)invoiceOperationTypeSelect);
        if (currentInvoiceId != null) {
            q.setParameter("invoiceId", (Object)currentInvoiceId);
        }
        if ((invoicedAmount = (BigDecimal)q.getSingleResult()) != null) {
            return invoicedAmount;
        }
        return BigDecimal.ZERO;
    }
}

